/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FileResourceGovernor {
    private final long mTotalSizeLimit;
    private final int mFileCountLimit;
    private long mTotalSize = 0L;
    private int mFileCount = 0;

    public static FileResourceGovernor unlimited() {
        return new FileResourceGovernor(-1L, -1);
    }

    public FileResourceGovernor(long totalSizeLimit, int fileCountLimit) {
        this.mTotalSizeLimit = totalSizeLimit;
        this.mFileCountLimit = fileCountLimit;
    }

    public long getTotalSizeLimit() {
        return this.mTotalSizeLimit;
    }

    public int getFileCountLimit() {
        return this.mFileCountLimit;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public int getFileCount() {
        return this.mFileCount;
    }

    public void incrementFileCount(int numFiles) {
        this.mFileCount += numFiles;
    }

    public void incrementTotalSize(long numBytes) {
        this.mTotalSize += numBytes;
    }

    public boolean isTotalSizeOk() {
        return this.mTotalSizeLimit < 0L || this.mTotalSize <= this.mTotalSizeLimit;
    }

    public boolean isFileCountOk() {
        return this.mFileCountLimit < 0 || this.mFileCount <= this.mFileCountLimit;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("totalSize", this.mTotalSize).append("totalSizeLimit", this.mTotalSizeLimit).append("fileCount", this.mFileCount).append("fileCountLimit", this.mFileCountLimit).toString();
    }
}

