/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.dataimport.resource.WriteResourceOp;
import com.ibm.neo.dataimport.resource.WriteResourceOpFactory;
import com.ibm.neo.io.CancellableInputStream;
import com.ibm.neo.io.LimitedInputStream;
import com.ibm.neo.io.ObservableCountingInputStream;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.FilenameUtils;

public class WriteArchiveFileOp
extends WriteResourceOp {
    private final CancellableInputStream mInput;
    private volatile WriteResourceOp mCurrentChildOp;

    WriteArchiveFileOp(File directory, String filename, InputStream input, Long expectedSize, FileResourceGovernor governor) {
        super(directory, filename, null, expectedSize, governor);
        this.mInput = new CancellableInputStream((InputStream)new ObservableCountingInputStream(input, new ObservableCountingInputStream.IByteCountObserver(){

            public void onByteCountChanged(long delta, long count) {
                WriteArchiveFileOp.this.setCompletedWork(count);
            }
        }, 102400L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileResource[] callImpl() throws Exception {
        ArrayList<FileResource> resources = new ArrayList<FileResource>();
        boolean success = false;
        this.mLogger.debug("Expanding archive file '{}'", (Object)this.getOriginalFilename());
        ArchiveStreamFactory factory = new ArchiveStreamFactory();
        ArchiveInputStream archiveInput = null;
        try {
            archiveInput = factory.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)this.mInput));
        }
        catch (ArchiveException e) {
            throw WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withMessage((IMessageKey)NeoImportError.UNSUPPORTED_ARCHIVE_FORMAT).build();
        }
        try {
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (null != entry) {
                FileResource[] childResources;
                if (this.isCanceled()) {
                    throw new CancellationException();
                }
                if (entry.isDirectory()) {
                    entry = archiveInput.getNextEntry();
                    continue;
                }
                if (entry.getName().contains("__MACOSX")) {
                    entry = archiveInput.getNextEntry();
                    continue;
                }
                File logicalFile = new File(this.getOriginalFilename(), entry.getName());
                this.mCurrentChildOp = entry.getSize() >= 0L ? WriteResourceOpFactory.create(this.getDirectory(), FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)logicalFile.getPath())), null, (InputStream)new LimitedInputStream((InputStream)archiveInput, entry.getSize()), entry.getSize(), this.getGovernor()) : WriteResourceOpFactory.create(this.getDirectory(), FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)logicalFile.getPath())), null, (InputStream)archiveInput, null, this.getGovernor());
                for (FileResource r : childResources = (FileResource[])this.mCurrentChildOp.call()) {
                    resources.add(r);
                }
                entry = archiveInput.getNextEntry();
            }
            success = true;
            FileResource[] fileResourceArray = resources.toArray(new FileResource[resources.size()]);
            return fileResourceArray;
        }
        finally {
            if (!success) {
                for (FileResource r : resources) {
                    r.deleteQuietly();
                }
            }
        }
    }

    protected void cancelImpl() {
        this.mInput.cancel();
        WriteResourceOp op = this.mCurrentChildOp;
        if (null != op) {
            op.cancel();
        }
    }
}

