/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.dataimport.resource.WriteResourceOp;
import com.ibm.neo.dataimport.resource.WriteResourceOpFactory;
import com.ibm.neo.io.CancellableInputStream;
import com.ibm.neo.io.ObservableCountingInputStream;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;

public class WriteCompressedFileOp
extends WriteResourceOp {
    private final String mUncompressedFilename;
    private final CancellableInputStream mInput;
    private volatile WriteResourceOp mChildOp;

    WriteCompressedFileOp(File directory, String filename, InputStream input, Long expectedSize, FileResourceGovernor governor) {
        this(directory, filename, null, input, expectedSize, governor);
    }

    WriteCompressedFileOp(File directory, String filename, String contentType, InputStream input, Long expectedSize, FileResourceGovernor governor) {
        super(directory, filename, contentType, expectedSize, governor);
        this.mUncompressedFilename = !WriteResourceOpFactory.isKnownCompressedType(filename, null) ? filename : FilenameUtils.removeExtension((String)filename);
        this.mInput = new CancellableInputStream((InputStream)new ObservableCountingInputStream(input, new ObservableCountingInputStream.IByteCountObserver(){

            public void onByteCountChanged(long delta, long count) {
                WriteCompressedFileOp.this.setCompletedWork(count);
            }
        }, 102400L));
    }

    protected FileResource[] callImpl() throws Exception {
        this.mLogger.debug("Expanding compressed file '{}' into '{}'", (Object)this.getOriginalFilename(), (Object)this.mUncompressedFilename);
        CompressorStreamFactory factory = new CompressorStreamFactory();
        CompressorInputStream decompressorInput = null;
        try {
            decompressorInput = factory.createCompressorInputStream((InputStream)new BufferedInputStream((InputStream)this.mInput));
        }
        catch (CompressorException e) {
            throw WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withMessage((IMessageKey)NeoImportError.UNSUPPORTED_COMPRESSION_TYPE).build();
        }
        this.mChildOp = WriteResourceOpFactory.create(this.getDirectory(), this.mUncompressedFilename, this.getUncompressedContentType(), (InputStream)decompressorInput, null, this.getGovernor());
        return (FileResource[])this.mChildOp.call();
    }

    protected String getUncompressedContentType() {
        if (StringUtils.isNotEmpty((String)this.getContentType())) {
            try {
                ContentType type = ContentType.parse((String)this.getContentType());
                String[] mimeTypeSplit = type.getMimeType().split("/");
                if (mimeTypeSplit.length == 2) {
                    String subType = mimeTypeSplit[1];
                    if (mimeTypeSplit[1].endsWith("+gzip")) {
                        String answer = mimeTypeSplit[0] + "/" + subType.substring(0, subType.length() - 5);
                        return answer;
                    }
                }
            }
            catch (ParseException e) {
                this.mLogger.warn("Unable to parse content-type", (Throwable)e);
            }
        }
        return null;
    }

    protected void cancelImpl() {
        this.mInput.cancel();
        if (null != this.mChildOp) {
            this.mChildOp.cancel();
        }
    }
}

