/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.dataimport.resource.QuotaViolatedRuntimeException;
import com.ibm.neo.dataimport.resource.WriteResourceOp;
import com.ibm.neo.io.CancellableInputStream;
import com.ibm.neo.io.ObservableCountingInputStream;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class WriteFileOp
extends WriteResourceOp {
    private final CancellableInputStream mInput;

    WriteFileOp(File directory, String filename, String contentType, InputStream input, Long expectedSize, FileResourceGovernor governor) {
        super(directory, filename, contentType, expectedSize, governor);
        this.mInput = new CancellableInputStream((InputStream)new ObservableCountingInputStream(input, new ObservableCountingInputStream.IByteCountObserver(){

            public void onByteCountChanged(long delta, long count) {
                FileResourceGovernor governor = WriteFileOp.this.getGovernor();
                governor.incrementTotalSize(delta);
                if (!governor.isTotalSizeOk()) {
                    throw new QuotaViolatedRuntimeException(WAImportException.newBuilder().withConditionCode(EImportMessageCode.FILE_SIZE_QUOTA_EXCEEDED).withContextAttribute(EImportMessageContext.FILE_SIZE, (Object)governor.getTotalSize()).withContextAttribute(EImportMessageContext.FILE_SIZE_LIMIT, (Object)governor.getTotalSizeLimit()).build());
                }
                WriteFileOp.this.setCompletedWork(count);
            }
        }, 102400L));
    }

    protected FileResource[] callImpl() throws Exception {
        FileResourceGovernor governor = this.getGovernor();
        governor.incrementFileCount(1);
        if (!governor.isFileCountOk()) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.TOO_MANY_FILES).withConditionCode(EImportMessageCode.TOO_MANY_FILES).build();
        }
        String physicalFilename = UUID.randomUUID().toString() + "." + FilenameUtils.getExtension((String)this.getOriginalFilename());
        File physicalFile = new File(this.getDirectory(), physicalFilename);
        File logicalFile = new File(this.getOriginalFilename());
        FileResource resource = new FileResource(physicalFile, logicalFile, this.getContentType());
        OutputStream output = null;
        boolean success = false;
        this.mLogger.debug("Writing logical file '{}' to temporary file '{}'", (Object)logicalFile.getPath(), (Object)physicalFile.getPath());
        if (!this.getDirectory().exists()) {
            FileUtils.forceMkdir((File)this.getDirectory());
        }
        try {
            output = resource.openOutputStream();
            try {
                IOUtils.copyLarge((InputStream)this.mInput, (OutputStream)output);
            }
            catch (QuotaViolatedRuntimeException ex) {
                throw (Exception)ex.getCause();
            }
            success = true;
            FileResource[] ex = new FileResource[]{resource};
            return ex;
        }
        catch (EOFException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).withConditionCode(EImportMessageCode.INVALID_FILE_FORMAT).withMessage((IMessageKey)NeoImportError.NEO_IS_FILE_INVALID_FORMAT).build();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
            if (!success) {
                FileUtils.deleteQuietly((File)physicalFile);
            }
        }
    }

    protected void cancelImpl() {
        this.mInput.cancel();
    }
}

