/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.util.ops.CallableOperation;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteResourceOp
extends CallableOperation<FileResource[]> {
    protected static final int PROGRESS_MILESTONE_SIZE = 102400;
    protected final Logger mLogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final File mDirectory;
    private final String mFilename;
    private final String mContentType;
    private final FileResourceGovernor mGovernor;

    protected WriteResourceOp(File directory, String filename, String contentType, Long expectedSize, FileResourceGovernor governor) {
        this.mDirectory = directory;
        this.mFilename = filename;
        this.mContentType = contentType;
        this.mGovernor = null != governor ? governor : FileResourceGovernor.unlimited();
        if (expectedSize == null) {
            this.setTotalWork(Long.MIN_VALUE);
        } else {
            this.setTotalWork(expectedSize);
        }
    }

    public File getDirectory() {
        return this.mDirectory;
    }

    protected String getOriginalFilename() {
        return this.mFilename;
    }

    protected String getContentType() {
        return this.mContentType;
    }

    protected FileResourceGovernor getGovernor() {
        return this.mGovernor;
    }
}

