/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.dataimport.resource.WriteArchiveFileOp;
import com.ibm.neo.dataimport.resource.WriteCompressedFileOp;
import com.ibm.neo.dataimport.resource.WriteFileOp;
import com.ibm.neo.dataimport.resource.WriteResourceOp;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResourceOpFactory {
    private static final String[] DEFAULT_KNOWN_COMPRESSED_FILE_EXTENSIONS = new String[]{"bz2", "gz", "lzma", "xz", "z"};
    private static final String[] DEFAULT_KNOWN_COMPRESSED_MIME_TYPES = new String[]{"application/gzip", "application/gzipped", "application/gzip-compressed", "application/x-compress", "application/x-compressed", "application/x-bzip2", "application/x-gtar", "application/x-gzip", "application/x-gunzip", "application/x-xz", "gzip/document"};
    private static final String[] DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS = new String[]{"a", "ar", "bcpio", "cpio", "jar", "tar", "ustar", "zipx", "zip"};
    private static final String[] DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS_ZIP = Arrays.copyOf(DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS, DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS.length - 2);
    private static final String[] DEFAULT_KNOWN_ARCHIVE_MIME_TYPES = new String[]{"application/x-bcpio", "application/x-cpio", "application/x-tar", "application/x-ustar", "application/x-zip", "application/x-zip-compressed", "application/zip", "multipart/x-zip"};
    private static final String[] DEFAULT_KNOWN_ARCHIVE_MIME_TYPES_ZIP = Arrays.copyOf(DEFAULT_KNOWN_ARCHIVE_MIME_TYPES, DEFAULT_KNOWN_ARCHIVE_MIME_TYPES.length - 4);
    private static final Set<String> KNOWN_COMPRESSED_FILE_EXTENSIONS = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_COMPRESSED_FILE_EXTENSIONS));
    private static final Set<String> KNOWN_COMPRESSED_MIME_TYPES = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_COMPRESSED_MIME_TYPES));
    private static final Set<String> KNOWN_ARCHIVE_FILE_EXTENSIONS = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS));
    private static final Set<String> KNOWN_ARCHIVE_MIME_TYPES = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_ARCHIVE_MIME_TYPES));
    private static final Set<String> KNOWN_ARCHIVE_FILE_EXTENSIONS_ZIP = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_ARCHIVE_FILE_EXTENSIONS_ZIP));
    private static final Set<String> KNOWN_ARCHIVE_MIME_TYPES_ZIP = new HashSet<String>(Arrays.asList(DEFAULT_KNOWN_ARCHIVE_MIME_TYPES_ZIP));
    private static final transient Logger mLogger = LoggerFactory.getLogger(WriteResourceOpFactory.class);

    private WriteResourceOpFactory() {
    }

    private static boolean isZipEnabled() {
        Properties config;
        return ImportService.isInitialized() && null != (config = ImportService.getInstance().getConfiguration()).get("com.ibm.neo.dataimport.cdf.scrape.archive.zip-as-workbook") && Boolean.parseBoolean(config.getProperty("com.ibm.neo.dataimport.cdf.scrape.archive.zip-as-workbook"));
    }

    public static WriteResourceOp create(File directory, String filename, String contentType, InputStream input, Long expectedSize, FileResourceGovernor governor) {
        if (WriteResourceOpFactory.isKnownCompressedType(filename, contentType)) {
            return new WriteCompressedFileOp(directory, filename, contentType, input, expectedSize, governor);
        }
        if (WriteResourceOpFactory.isKnownArchiveType(filename, contentType)) {
            return new WriteArchiveFileOp(directory, filename, input, expectedSize, governor);
        }
        return new WriteFileOp(directory, filename, contentType, input, expectedSize, governor);
    }

    public static boolean canHandleType(String filename, String contentType) {
        return WriteResourceOpFactory.isKnownCompressedType(filename, contentType) || WriteResourceOpFactory.isKnownArchiveType(filename, contentType);
    }

    public static boolean isKnownCompressedType(String filename, String contentType) {
        if (StringUtils.isNotEmpty((String)contentType)) {
            try {
                ContentType type = ContentType.parse((String)contentType);
                String[] mimeTypeSplit = type.getMimeType().split("/");
                if (mimeTypeSplit.length == 2 && mimeTypeSplit[1].endsWith("+gzip")) {
                    return true;
                }
            }
            catch (ParseException e) {
                mLogger.warn("Unable to parse content-type", (Throwable)e);
            }
        }
        if (KNOWN_COMPRESSED_MIME_TYPES.contains(WriteResourceOpFactory.removeParametersFromType(contentType))) {
            return true;
        }
        return FilenameUtils.isExtension((String)filename, KNOWN_COMPRESSED_FILE_EXTENSIONS);
    }

    public static boolean isKnownArchiveType(String filename, String contentType) {
        Set<String> mimeType;
        boolean zipSupported = WriteResourceOpFactory.isZipEnabled();
        Set<String> set = mimeType = zipSupported ? KNOWN_ARCHIVE_MIME_TYPES_ZIP : KNOWN_ARCHIVE_MIME_TYPES;
        if (mimeType.contains(WriteResourceOpFactory.removeParametersFromType(contentType))) {
            return true;
        }
        Set<String> fileTypes = zipSupported ? KNOWN_ARCHIVE_FILE_EXTENSIONS_ZIP : KNOWN_ARCHIVE_FILE_EXTENSIONS;
        return FilenameUtils.isExtension((String)filename, fileTypes);
    }

    private static String removeParametersFromType(String contentType) {
        if (contentType != null && contentType.contains(";")) {
            return contentType.substring(0, contentType.indexOf(59));
        }
        return contentType;
    }
}

