/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.upgrade;

import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.upgrade.IUpgradeLogger;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;

public class DataSourceSizeUpdater {
    private final PersistenceService mPersistenceService;
    private final ImportService mImportService;
    private final IUpgradeLogger mLogger;

    public DataSourceSizeUpdater(PersistenceService ps, ImportService is, IUpgradeLogger logger) {
        this.mPersistenceService = ps;
        this.mImportService = is;
        this.mLogger = logger;
    }

    public void setDataSourceSize(DocumentDataSource dds) {
        dds.setContentSize(1L);
        if (!(dds instanceof UploadDataSource)) {
            this.mLogger.warn("UserDataSource " + this.getLogIdentifier((UserDataSource)dds) + " is not an UploadDataSource. Setting the size to 1 byte.");
            return;
        }
        try {
            IBlob uploadedBlob = this.mImportService.getUploadedBlob((UploadDataSource)dds);
            long size = this.computeBlobSize(uploadedBlob);
            if (size < 1L) {
                this.mLogger.warn("The stored file blob for data source " + this.getLogIdentifier((UserDataSource)dds) + " is missing or has an invalid size. Setting the size to 1 byte.");
            } else {
                dds.setContentSize(size);
            }
        }
        catch (Exception e) {
            this.mLogger.warn("Encountered exception while getting the blob size for data source " + this.getLogIdentifier((UserDataSource)dds) + ". Setting the size to 1 byte.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeBlobSize(IBlob blob) throws BlobStoreException, IOException {
        if (blob == null) {
            return 0L;
        }
        if (blob.isCompressed() || blob.isEncrypted()) {
            long l;
            CountingInputStream cis = null;
            try {
                cis = new CountingInputStream(blob.open());
                cis.skip(Long.MAX_VALUE);
                l = cis.getByteCount();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)cis);
            return l;
        }
        return blob.getContentLength();
    }

    public boolean existsDataSourcesWithInvalidSize() throws PersistenceException {
        IDocumentCollection col = ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mPersistenceService).getDocumentCollection();
        IONObjectId id = (IONObjectId)col.findOneAndProject(this.buildInvalidSizeFieldQuery(), "_id", IONObjectId.class, EReadPreference.SECONDARY_PREFERRED);
        return id != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureDataSourcesHaveSize() throws PersistenceException {
        IONObject invalidSizeFieldQuery;
        NobjectCollection dsCol = ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mPersistenceService);
        if (null == dsCol.findOne(invalidSizeFieldQuery = this.buildInvalidSizeFieldQuery(), EReadPreference.SECONDARY_PREFERRED)) {
            return;
        }
        int updateCount = 0;
        try (ICursor dsCursor = dsCol.find(invalidSizeFieldQuery);){
            while (dsCursor.hasNext()) {
                DocumentDataSource dds = (DocumentDataSource)dsCursor.next();
                this.setDataSourceSize(dds);
                IONObject update = new UpdateBuilder().set("content-size", (Object)dds.getContentSize()).toDocument();
                if (1 != dsCol.getDocumentCollection().update(dds.getId(), update)) {
                    if (dsCol.getDocumentCollection().get(dds.getId()) == null) continue;
                    this.mLogger.warn("Failed to set the size field on data source " + this.getLogIdentifier((UserDataSource)dds) + ".");
                    continue;
                }
                ++updateCount;
            }
        }
        this.mLogger.info("Updated the size of " + updateCount + " data sources.");
    }

    private IONObject buildInvalidSizeFieldQuery() {
        IONObject invalidSizeFieldQuery = new QueryBuilder().or(new IONObject[]{new QueryBuilder().notExists("content-size").toDocument(), new QueryBuilder().lessThan("content-size", (Object)1).toDocument()}).toDocument();
        return invalidSizeFieldQuery;
    }

    private String getLogIdentifier(UserDataSource uds) {
        return uds == null ? "[no id]" : uds.getId().getIdentifier();
    }
}

