/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.upgrade;

import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.upgrade.DataSourceSizeUpdater;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.upgrade.AbstractUpgradeDelta;
import com.ibm.neo.upgrade.IUpgradeDelta;
import com.ibm.neo.upgrade.IUpgradeLogger;
import com.ibm.neo.upgrade.UpgradeException;

public class SetDataSourceSizeDelta
extends AbstractUpgradeDelta {
    public int getTargetContentVersion() {
        return 11;
    }

    public boolean isApplicable(IUpgradeDelta.IContext context) throws UpgradeException {
        try {
            return this.makeUpdater(context).existsDataSourcesWithInvalidSize();
        }
        catch (Exception e) {
            this.wrapException(e);
            return false;
        }
    }

    public void apply(IUpgradeDelta.IContext context) throws UpgradeException {
        try {
            this.makeUpdater(context).ensureDataSourcesHaveSize();
        }
        catch (Exception e) {
            this.wrapException(e);
        }
    }

    public void verify(IUpgradeDelta.IContext context) throws UpgradeException {
        try {
            this.makeUpdater(context);
        }
        catch (Exception e) {
            this.wrapException(e);
        }
    }

    private DataSourceSizeUpdater makeUpdater(IUpgradeDelta.IContext context) {
        IUpgradeLogger logger = ((AbstractUpgradeDelta.BaseContext)context).getLogger();
        return new DataSourceSizeUpdater(PersistenceService.getInstance(), ImportService.getInstance(), logger);
    }
}

