/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.upgrade;

import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.util.DatasetStatsCollector;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.upgrade.AbstractUpgradeDelta;
import com.ibm.neo.upgrade.IUpgradeDelta;
import com.ibm.neo.upgrade.UpgradeException;

public class SetStorageCostUpgrade
extends AbstractUpgradeDelta {
    public int getTargetContentVersion() {
        return 9;
    }

    public boolean isApplicable(IUpgradeDelta.IContext _context) throws UpgradeException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(IUpgradeDelta.IContext _context) throws UpgradeException {
        try {
            PersistenceService ps = PersistenceService.getInstance();
            try (ICursor datasetCur = ImportPersistence.getDatasetCollection((PersistenceService)ps).findAll();){
                while (datasetCur.hasNext()) {
                    Dataset ds = (Dataset)datasetCur.next();
                    double storageCost = DatasetStatsCollector.computeStorageCost(ds);
                    ImportPersistence.getDatasetCollection((PersistenceService)ps).getDocumentCollection().update(ds.getId(), new UpdateBuilder().set("storage-cost", (Object)storageCost).toDocument());
                }
            }
        }
        catch (Exception ex) {
            throw new UpgradeException((Throwable)ex);
        }
    }

    public void verify(IUpgradeDelta.IContext _context) throws UpgradeException {
        IONObject dsWithNoStorageCostQuery = new QueryBuilder().notExists("storage-cost").toDocument();
        try {
            NobjectCollection col = ImportPersistence.getDatasetCollection();
            this.assertTrue(col.count(dsWithNoStorageCostQuery) == 0L, "Some datasets have no storage-cost field set.");
        }
        catch (PersistenceException e) {
            throw UpgradeException.convertException((Throwable)e);
        }
    }
}

