/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.plugin.EPluginType;
import com.ibm.neo.dataimport.plugin.IAnalyzePlugin;
import com.ibm.neo.dataimport.plugin.IPluginContext;
import com.ibm.neo.dataimport.plugin.PluginException;
import com.ibm.neo.dataimport.plugin.framework.PluginContext;
import com.ibm.neo.dataimport.plugin.framework.PluginManager;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.IOperation;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzePluginHelper
implements IObserver<IOperation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzePluginHelper.class);
    private final PluginManager mManager;
    private Properties mConfiguration;
    private PersistenceService mPersistenceService;
    private CDFService mCDFService;
    private UserDataSource mDataSource;
    private List<Dataset> mDatasets;

    public AnalyzePluginHelper(PluginManager manager) {
        this.mManager = manager;
    }

    public AnalyzePluginHelper withConfiguration(Properties configuration) {
        this.mConfiguration = configuration;
        return this;
    }

    public AnalyzePluginHelper withPersistenceService(PersistenceService persistenceService) {
        this.mPersistenceService = persistenceService;
        return this;
    }

    public AnalyzePluginHelper withCDFService(CDFService cdfService) {
        this.mCDFService = cdfService;
        return this;
    }

    public AnalyzePluginHelper withDataSource(UserDataSource dataSource) {
        this.mDataSource = dataSource;
        return this;
    }

    public AnalyzePluginHelper withDatasets(List<Dataset> datasets) {
        this.mDatasets = datasets;
        return this;
    }

    public void preAnalyze() {
        List chain = this.mManager.getPluginChain(EPluginType.ANALYZE, IAnalyzePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        for (IAnalyzePlugin p : chain) {
            try {
                p.preAnalyze((IPluginContext)context);
            }
            catch (PluginException ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void datasetPlanned(Dataset dataset) {
        List chain = this.mManager.getPluginChain(EPluginType.ANALYZE, IAnalyzePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("dataset", (Object)dataset);
        for (IAnalyzePlugin p : chain) {
            try {
                p.datasetPlanned((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void postAnalyze(Throwable error) {
        List chain = this.mManager.getPluginChain(EPluginType.ANALYZE, IAnalyzePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("datasets", this.mDatasets);
        for (IAnalyzePlugin p : chain) {
            try {
                p.postAnalyze((IPluginContext)context, error);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void updated(IOperation subject) {
        if (subject.hasStarted()) {
            if (subject.hasFinished()) {
                this.postAnalyze(subject.getError());
            } else {
                this.preAnalyze();
            }
        }
    }
}

