/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.nodel.DataItem;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class AnalyzeUtils {
    public static String formatHeaderLabel(ICDFCell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.isNull()) {
            return "";
        }
        NumberFormatDecoration numFormatDecor = null;
        DateTimeFormatDecoration dateTimeFormatDecor = null;
        DecorationMap decorations = cell.getDecorations();
        if (null != decorations) {
            for (Decoration d : decorations) {
                if (d.getDecorationType() == EDecorationType.NUMBER_FORMAT) {
                    numFormatDecor = (NumberFormatDecoration)d;
                    continue;
                }
                if (d.getDecorationType() != EDecorationType.DATETIME_FORMAT) continue;
                dateTimeFormatDecor = (DateTimeFormatDecoration)d;
            }
        }
        DecimalFormat decimalFormat = null;
        SimpleDateFormat dateFormat = null;
        if (null != numFormatDecor) {
            DecimalFormatSymbols symbols = null;
            symbols = null != numFormatDecor.getSymbolsLocale() ? DecimalFormatSymbols.getInstance((Locale)numFormatDecor.getSymbolsLocale()) : DecimalFormatSymbols.getInstance();
            decimalFormat = new DecimalFormat(numFormatDecor.getFormatPattern(), symbols);
        }
        if (null != dateTimeFormatDecor) {
            dateFormat = new SimpleDateFormat(dateTimeFormatDecor.getFormatPattern(), dateTimeFormatDecor.getSymbolsLocale());
        }
        switch (cell.getDataType()) {
            case STRING: {
                return cell.stringValue();
            }
            case INT8: {
                if (null != decimalFormat) {
                    return decimalFormat.format((long)cell.byteValue());
                }
                return Byte.toString(cell.byteValue());
            }
            case INT16: {
                if (null != decimalFormat) {
                    return decimalFormat.format((long)cell.shortValue());
                }
                return Integer.toString(cell.shortValue());
            }
            case INT32: {
                if (null != decimalFormat) {
                    return decimalFormat.format((long)cell.intValue());
                }
                return Long.toString(cell.intValue());
            }
            case INT64: {
                if (null != decimalFormat) {
                    return decimalFormat.format(cell.longValue());
                }
                return Long.toString(cell.longValue());
            }
            case FLOAT32: {
                if (null != decimalFormat) {
                    return decimalFormat.format((double)cell.floatValue());
                }
                return Float.toString(cell.floatValue());
            }
            case FLOAT64: {
                if (null != decimalFormat) {
                    return decimalFormat.format(cell.doubleValue());
                }
                return Double.toString(cell.doubleValue());
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                if (null != dateFormat) {
                    return dateFormat.format(cell.dateValue());
                }
                return cell.toString();
            }
        }
        return cell.toString();
    }

    public static void ensureHeadersAreUnique(List<DataItem> dataItems, boolean setOldNamesAsLabels) {
        HashSet<String> headerSet = new HashSet<String>();
        for (int i = 0; i < dataItems.size(); ++i) {
            DataItem item = dataItems.get(i);
            String header = item.getName();
            assert (header != null);
            if (headerSet.add(header)) continue;
            int j = 0;
            do {
                item.setName(header + "-" + ++j);
                if (!setOldNamesAsLabels) continue;
                item.setLabel(header);
            } while (!headerSet.add(header + "-" + j));
        }
    }

    public static String cleanIdentifier(String value) {
        int codePoint;
        if (null == value) {
            return null;
        }
        if (value.isEmpty()) {
            return "";
        }
        int length = value.length();
        StringBuilder builder = new StringBuilder(length);
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (Character.isWhitespace(codePoint)) {
                builder.append(' ');
                continue;
            }
            if (!AnalyzeUtils.isValidXmlChar(codePoint) || AnalyzeUtils.isDiscouragedXmlChar(codePoint)) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    private static boolean isValidXmlChar(int codePoint) {
        if (codePoint >= 32 && codePoint <= 55295) {
            return true;
        }
        if (codePoint >= 57344 && codePoint <= 65533) {
            return true;
        }
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    private static boolean isDiscouragedXmlChar(int codePoint) {
        if (codePoint >= 127 && codePoint <= 159) {
            return true;
        }
        if (codePoint >= 64976 && codePoint <= 65007) {
            return true;
        }
        int tmp = codePoint & 0xFFFF;
        return tmp >= 65534 && tmp <= 65535;
    }
}

