/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.ImpersonationHelper;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Tenant;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class BlobStoreHelper {
    public static final String UPLOADS_CONTAINER_NAME = "import.uploads-fs";
    private static final String SHEETS_CONTAINER_NAME = "import.sheets-fs";

    public static IBlobContainer getUploadsContainer(IBlobStore blobStore) throws BlobStoreException {
        return blobStore.getContainer(UPLOADS_CONTAINER_NAME, true);
    }

    public static IBlobContainer getSheetsContainer(IBlobStore blobStore) throws BlobStoreException {
        return blobStore.getContainer(SHEETS_CONTAINER_NAME, true);
    }

    public static String createBlobAsTenant(final IBlobStore blobStore, AccessControlService acs, Account account, Tenant tenant, final String containerName, final String filename, final InputStream contentStream, final String contentType, final boolean compress) throws BlobStoreException {
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return blobStore.getContainer(containerName, true).create(filename, contentType, contentStream, compress).getKey();
            }
        };
        try {
            return (String)ImpersonationHelper.callAsTenant((AccessControlService)acs, (Account)account, (Tenant)tenant, (Callable)callable);
        }
        catch (Throwable e) {
            if (e instanceof BlobStoreException) {
                throw (BlobStoreException)e;
            }
            throw new BlobStoreException("Exception creating a blob as impersonated tenant " + tenant.getId().getIdentifier() + ".", e);
        }
    }

    public static InputStream openBlobAsTenant(final IBlobStore blobStore, AccessControlService acs, Account account, Tenant tenant, final String containerName, final String blobId) throws BlobStoreException {
        Callable<InputStream> callable = new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                IBlob blob = blobStore.getContainer(containerName, true).get(blobId);
                if (blob == null) {
                    return null;
                }
                return blob.open();
            }
        };
        try {
            return (InputStream)ImpersonationHelper.callAsTenant((AccessControlService)acs, (Account)account, (Tenant)tenant, (Callable)callable);
        }
        catch (Throwable e) {
            if (e instanceof BlobStoreException) {
                throw (BlobStoreException)e;
            }
            throw new BlobStoreException("Exception getting or opening blob " + blobId + " as impersonated tenant " + tenant.getId().getIdentifier() + ".", e);
        }
    }

    public static ProxyBlob getProxyBlobAsTenant(final IBlobStore blobStore, final AccessControlService acs, final Account account, final Tenant tenant, final String containerName, final String blobId) throws BlobStoreException {
        Callable<ProxyBlob> callable = new Callable<ProxyBlob>(){

            @Override
            public ProxyBlob call() throws Exception {
                IBlob blob = blobStore.getContainer(containerName, true).get(blobId);
                if (blob == null) {
                    return null;
                }
                return new ProxyBlob(blob, acs, account, tenant);
            }
        };
        try {
            return (ProxyBlob)ImpersonationHelper.callAsTenant((AccessControlService)acs, (Account)account, (Tenant)tenant, (Callable)callable);
        }
        catch (Throwable e) {
            if (e instanceof BlobStoreException) {
                throw (BlobStoreException)e;
            }
            throw new BlobStoreException("Exception getting or opening blob " + blobId + " as impersonated tenant " + tenant.getId().getIdentifier() + ".", e);
        }
    }

    public static void deleteBlobAsTenant(final IBlobStore blobStore, AccessControlService acs, Account account, Tenant tenant, final String containerName, final String blobId) throws BlobStoreException {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                blobStore.getContainer(containerName, true).delete(blobId);
                return null;
            }
        };
        try {
            ImpersonationHelper.callAsTenant((AccessControlService)acs, (Account)account, (Tenant)tenant, (Callable)callable);
        }
        catch (Throwable e) {
            if (e instanceof BlobStoreException) {
                throw (BlobStoreException)e;
            }
            throw new BlobStoreException("Exception getting blob " + blobId + " as impersonated tenant " + tenant.getId().getIdentifier() + ".", e);
        }
    }

    public static class ProxyBlob {
        private final IBlob source;
        private AccessControlService acs;
        private Account account;
        private Tenant tenant;
        private String key;
        private String filename;
        private String contentType;
        private long contentLength;
        private byte[] iv;
        private boolean compressed;
        private boolean encrypted;
        private Date creationTime;
        private Map<String, Object> metadata;

        private ProxyBlob(IBlob source, AccessControlService acs, Account account, Tenant tenant) throws BlobStoreException {
            this.source = source;
            this.acs = acs;
            this.account = account;
            this.tenant = tenant;
            this.key = source.getKey();
            this.filename = source.getFilename();
            this.contentType = source.getContentType();
            this.contentLength = source.getContentLength();
            this.compressed = source.isCompressed();
            this.encrypted = source.isEncrypted();
            this.creationTime = source.getCreationTime();
            this.metadata = new HashMap<String, Object>();
            for (String key : source.getMetadataKeys()) {
                this.metadata.put(key, source.getMetadataValue(key));
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }

        public Set<String> getMetadataKeys() {
            return this.metadata.keySet();
        }

        public Object getMetadataValue(String key) {
            return this.metadata.get(key);
        }

        public InputStream openBlob() throws BlobStoreException, IOException {
            return this.impersonateAndHandle(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return ProxyBlob.this.source.open();
                }
            });
        }

        public void remove() throws BlobStoreException, IOException {
            this.impersonateAndHandle(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProxyBlob.this.source.remove();
                    return null;
                }
            });
        }

        private <T> T impersonateAndHandle(Callable<T> callable) throws BlobStoreException, IOException {
            try {
                return (T)ImpersonationHelper.callAsTenant((AccessControlService)this.acs, (Account)this.account, (Tenant)this.tenant, callable);
            }
            catch (BlobStoreException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new BlobStoreException(e);
            }
        }
    }
}

