/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.persist.AggregationPipelineBuilder;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSizeAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceSizeAggregator.class);

    private DataSourceSizeAggregator() {
    }

    public static long sumDataSourceSizes(PersistenceService ps) throws PersistenceException {
        IDocumentCollection dsCol = ImportPersistence.getUserDataSourceCollection((PersistenceService)ps).getDocumentCollection();
        AggregationPipelineBuilder apb = new AggregationPipelineBuilder();
        IONObject sumOp = new IONObjectBuilder().put("$sum", (Object)"$content-size").toDocument();
        String totalSizeField = "totalSize";
        apb.group(new IONObjectBuilder().put("_id", null).put("totalSize", (Object)sumOp).toDocument());
        IONArray results = dsCol.aggregate(apb.toIONDocuments(), EReadPreference.SECONDARY_PREFERRED);
        if (results.size() == 1) {
            IONObject result = results.getIONObject(0);
            if (result != null && result.containsKey((Object)"totalSize")) {
                return result.getLong("totalSize");
            }
            LOG.warn("Expecting a '{}' field when aggregating all data source content sizes.", (Object)"totalSize");
            return 0L;
        }
        return 0L;
    }
}

