/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.storage.Column;
import com.ibm.neo.dataimport.nodel.storage.ColumnStats;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.JoinPath;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.util.Assertions;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetStatsCollector {
    private final StorageService mStorageService;
    private final Dataset mDataset;
    private final Database mDB;
    private final Table mTable;
    private final Logger mLogger = LoggerFactory.getLogger(DatasetStatsCollector.class);

    public DatasetStatsCollector(StorageService storageService, Dataset dataset, Database db, Table table) {
        this.mStorageService = storageService;
        this.mDataset = dataset;
        this.mDB = db;
        this.mTable = table;
    }

    public void collect() throws WAStorageException {
        List dataItems = this.mDataset.getDataItems();
        String schemaName = this.mTable.getSchemaName();
        String tableName = this.mTable.getTableName();
        String[] colNames = new String[dataItems.size()];
        this.mLogger.debug("Collecting stats for dataset {}", (Object)this.mDataset.getName());
        for (int i = 0; i < dataItems.size(); ++i) {
            DataItem di = (DataItem)dataItems.get(i);
            Column col = this.mTable.getColumnByDataItemName(di.getName());
            Assertions.assertNotNull((Object)col, (String)"Could not find column for data item.");
            colNames[i] = col.getColumnName();
        }
        IDatabaseAccessor accessor = this.mStorageService.getOrCreateAccessor(this.mDB.getDbType());
        long rowCount = accessor.getTableRowCount(this.mDB, schemaName, tableName, new JoinPath[0]);
        this.mDataset.setRowCount(rowCount);
        ColumnStats[] colStats = accessor.getTableColumnStats(this.mDB, schemaName, tableName, colNames, new JoinPath[0]);
        for (int i = 0; i < dataItems.size(); ++i) {
            DataItem di = (DataItem)dataItems.get(i);
            di.setDistinctCount(colStats[i].getDistinctCount());
            di.setNullCount(rowCount - colStats[i].getNonNullCount());
            di.setMin(colStats[i].getMin());
            di.setMax(colStats[i].getMax());
            if (rowCount > 0L) {
                di.setDensity((float)colStats[i].getNonNullCount() / (float)rowCount);
                continue;
            }
            di.setDensity(0.0f);
        }
        this.mTable.setStorageCost(DatasetStatsCollector.computeStorageCost(this.mDataset));
        this.mDataset.setStorageCost(this.mTable.getStorageCost());
    }

    public static double computeStorageCost(Dataset dataset) {
        List dataItems = dataset.getDataItems();
        double totalCost = 1.0;
        for (int i = 0; i < dataItems.size(); ++i) {
            DataItem di = (DataItem)dataItems.get(i);
            long nonNullCount = dataset.getRowCount() - di.getNullCount();
            double columnCost = 1.0 + (double)((long)di.getDataType().unitStorageCost() * nonNullCount);
            if (di.getDataType() == EDataType.STRING) {
                columnCost *= (double)di.getMaxStringLength();
            }
            totalCost += (columnCost += (double)di.getNullCount());
        }
        return totalCost;
    }
}

