/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.api.IDatasetSampleProvider;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.plugin.EPluginType;
import com.ibm.neo.dataimport.plugin.IDeployPlugin;
import com.ibm.neo.dataimport.plugin.IPluginContext;
import com.ibm.neo.dataimport.plugin.framework.PluginContext;
import com.ibm.neo.dataimport.plugin.framework.PluginManager;
import com.ibm.neo.persist.PersistenceService;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployPluginHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployPluginHelper.class);
    private final PluginManager mManager;
    private Properties mConfiguration;
    private PersistenceService mPersistenceService;
    private CDFService mCDFService;
    private IDatasetSampleProvider mSampleProvider;
    private UserDataSource mDataSource;
    private Dataset mDataset;
    private Database mDatabase;
    private Table mTable;

    public DeployPluginHelper(PluginManager manager) {
        this.mManager = manager;
    }

    public DeployPluginHelper withConfiguration(Properties configuration) {
        this.mConfiguration = configuration;
        return this;
    }

    public DeployPluginHelper withPersistenceService(PersistenceService persistenceService) {
        this.mPersistenceService = persistenceService;
        return this;
    }

    public DeployPluginHelper withCDFService(CDFService cdfService) {
        this.mCDFService = cdfService;
        return this;
    }

    public DeployPluginHelper withSampleProvider(IDatasetSampleProvider sampleProvider) {
        this.mSampleProvider = sampleProvider;
        return this;
    }

    public DeployPluginHelper withDataSource(UserDataSource dataSource) {
        this.mDataSource = dataSource;
        return this;
    }

    public DeployPluginHelper withDataset(Dataset dataset) {
        this.mDataset = dataset;
        return this;
    }

    public DeployPluginHelper withDatabase(Database database) {
        this.mDatabase = database;
        return this;
    }

    public DeployPluginHelper withTable(Table table) {
        this.mTable = table;
        return this;
    }

    public void preDeploy() {
        List chain = this.mManager.getPluginChain(EPluginType.DEPLOY, IDeployPlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("dataset", (Object)this.mDataset);
        for (IDeployPlugin p : chain) {
            try {
                p.preDeploy((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void tableCreated() {
        List chain = this.mManager.getPluginChain(EPluginType.DEPLOY, IDeployPlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("dataset", (Object)this.mDataset);
        context.put("database", (Object)this.mDatabase);
        context.put("table", (Object)this.mTable);
        for (IDeployPlugin p : chain) {
            try {
                p.tableCreated((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void tableLoaded() {
        List chain = this.mManager.getPluginChain(EPluginType.DEPLOY, IDeployPlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("dataset", (Object)this.mDataset);
        context.put("database", (Object)this.mDatabase);
        context.put("table", (Object)this.mTable);
        for (IDeployPlugin p : chain) {
            try {
                p.tableLoaded((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void postDeploy(Throwable error) {
        List chain = this.mManager.getPluginChain(EPluginType.DEPLOY, IDeployPlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)this.mDataSource);
        context.put("dataset", (Object)this.mDataset);
        context.put("database", (Object)this.mDatabase);
        context.put("table", (Object)this.mTable);
        context.put("sampleProvider", (Object)this.mSampleProvider);
        for (IDeployPlugin p : chain) {
            try {
                p.postDeploy((IPluginContext)context, error);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }
}

