/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.api.EImportFeatureFlag;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ImportFeatureFlagHelper {
    public static final String HEADER_BA_IMPORT = "ba-import";
    private static final Map<String, EImportFeatureFlag> NORMALIZED_FLAGS = new HashMap<String, EImportFeatureFlag>();
    private static final String VAL_ENABLED = "enabled";
    private static final String VAL_DISABLED = "disabled";

    private ImportFeatureFlagHelper() {
    }

    public static Map<EImportFeatureFlag, Boolean> determineFeatureFlags() {
        HashMap<EImportFeatureFlag, Boolean> modes = new HashMap<EImportFeatureFlag, Boolean>();
        for (EImportFeatureFlag code : EImportFeatureFlag.values()) {
            modes.put(code, Boolean.FALSE);
        }
        ImportFeatureFlagHelper.getEnabledFeatureFlags(modes);
        return modes;
    }

    @Deprecated
    public static boolean isEnabled(AccessControlService acs, EImportFeatureFlag code) {
        return Boolean.TRUE.equals(ImportFeatureFlagHelper.determineFeatureFlags().get(code));
    }

    public static boolean isEnabled(EImportFeatureFlag code) {
        return Boolean.TRUE.equals(ImportFeatureFlagHelper.determineFeatureFlags().get(code));
    }

    public static String generateHeaderValue(boolean encodeValue, Map<EImportFeatureFlag, Boolean> flags) {
        TreeMap<String, String> featurePairs = new TreeMap<String, String>();
        for (Map.Entry<EImportFeatureFlag, Boolean> entry : flags.entrySet()) {
            String featureKey = EImportFeatureFlag.toFeatureFlagKey((EImportFeatureFlag)entry.getKey());
            String value = Boolean.TRUE.equals(entry.getValue()) ? VAL_ENABLED : VAL_DISABLED;
            featurePairs.put(featureKey, value);
        }
        String headerValue = WatsonHeaders.encodeKeyValuePairs(featurePairs);
        if (encodeValue) {
            return WatsonHeaders.encodeURL((String)headerValue);
        }
        return headerValue;
    }

    private static Map<EImportFeatureFlag, Boolean> getEnabledFeatureFlags(Map<EImportFeatureFlag, Boolean> modes) {
        String importHeader = WatsonHeaders.getFirstValue((Map)ACSHelper.getCurrentHttpHeaders(), (String)HEADER_BA_IMPORT, (boolean)true);
        if (importHeader != null) {
            Properties flagProps = WatsonHeaders.decodeKeyValuePairs((String)importHeader);
            for (Map.Entry<Object, Object> e : flagProps.entrySet()) {
                String key = ((String)e.getKey()).toLowerCase();
                String value = (String)e.getValue();
                if (!NORMALIZED_FLAGS.containsKey(key)) continue;
                EImportFeatureFlag code = NORMALIZED_FLAGS.get(key);
                modes.put(code, VAL_ENABLED.equals(value));
            }
        } else {
            modes.put(EImportFeatureFlag.ENFORCE_FILE_QUOTAS, Boolean.TRUE);
            modes.put(EImportFeatureFlag.ENFORCE_DISK_QUOTA, Boolean.TRUE);
        }
        return modes;
    }

    public static boolean isAvailable(EImportFeatureFlag code) {
        HashMap<EImportFeatureFlag, Boolean> modes = new HashMap<EImportFeatureFlag, Boolean>();
        return ImportFeatureFlagHelper.getEnabledFeatureFlags(modes).containsKey(code);
    }

    static {
        for (EImportFeatureFlag code : EnumSet.allOf(EImportFeatureFlag.class)) {
            String normalizedCode = code.name().replace("_", "").toLowerCase();
            NORMALIZED_FLAGS.put(normalizedCode, code);
        }
    }
}

