/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.api.EImportFeedbackCode;
import com.ibm.neo.security.ACSHelper;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ImportFeedbackParser {
    public static final String HEADER_BA_IMPORT_FEEDBACK = "ba-import-feedback";
    private static final Map<String, EImportFeedbackCode> NORMALIZED_FEEDBACK_CODES = new HashMap<String, EImportFeedbackCode>();
    private static final String VAL_ENABLED = "enabled";
    private static final String VAL_DISABLED = "disabled";

    private ImportFeedbackParser() {
    }

    public static Map<EImportFeedbackCode, Boolean> determineFeedbackModes(Properties config) {
        HashMap<EImportFeedbackCode, Boolean> modes = new HashMap<EImportFeedbackCode, Boolean>();
        for (EImportFeedbackCode code : EImportFeedbackCode.values()) {
            modes.put(code, Boolean.FALSE);
        }
        String importFeedbackHeader = WatsonHeaders.getFirstValue((Map)ACSHelper.getCurrentHttpHeaders(), (String)HEADER_BA_IMPORT_FEEDBACK, (boolean)true);
        if (importFeedbackHeader != null) {
            Properties feedbackProps = WatsonHeaders.decodeKeyValuePairs((String)importFeedbackHeader);
            for (Map.Entry<Object, Object> e : feedbackProps.entrySet()) {
                String key = ((String)e.getKey()).toLowerCase();
                String value = (String)e.getValue();
                if (!NORMALIZED_FEEDBACK_CODES.containsKey(key)) continue;
                EImportFeedbackCode code = NORMALIZED_FEEDBACK_CODES.get(key);
                modes.put(code, VAL_ENABLED.equals(value));
            }
        }
        return modes;
    }

    public static boolean isEnabled(Properties config, EImportFeedbackCode code) {
        return Boolean.TRUE.equals(ImportFeedbackParser.determineFeedbackModes(config).get(code));
    }

    public static String generateHeaderValue(boolean encodeValue, Map<EImportFeedbackCode, Boolean> flags) {
        TreeMap<String, String> featurePairs = new TreeMap<String, String>();
        for (Map.Entry<EImportFeedbackCode, Boolean> entry : flags.entrySet()) {
            String featureKey = EImportFeedbackCode.toFeatureFlagKey((EImportFeedbackCode)entry.getKey());
            String value = Boolean.TRUE.equals(entry.getValue()) ? VAL_ENABLED : VAL_DISABLED;
            featurePairs.put(featureKey, value);
        }
        String headerValue = WatsonHeaders.encodeKeyValuePairs(featurePairs);
        if (encodeValue) {
            return WatsonHeaders.encodeURL((String)headerValue);
        }
        return headerValue;
    }

    static {
        for (EImportFeedbackCode code : EnumSet.allOf(EImportFeedbackCode.class)) {
            String normalizedCode = code.name().replace("_", "").toLowerCase();
            NORMALIZED_FEEDBACK_CODES.put(normalizedCode, code);
        }
    }
}

