/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerService;
import java.util.concurrent.TimeUnit;

public abstract class LockHelper {
    public static final long DEFAULT_LOCK_TIMEOUT_SECONDS = 120L;

    public static DLock acquireDataSourceLock(WranglerService wrangler, IONObjectId dataSourceId, long timeoutSeconds) throws WAImportException {
        String lockName = "import.dataSource." + dataSourceId.getIdentifier();
        DLock lock = null;
        boolean acquired = false;
        try {
            lock = wrangler.getDLock(lockName);
            acquired = lock.tryAcquire(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_FAILED_DS_LOCK, new Object[]{lockName}).withCause((Throwable)ex).build();
        }
        if (acquired) {
            return lock;
        }
        return null;
    }

    public static DLock acquireDatasetRepairLock(WranglerService wrangler, IONObjectId datasetId, long timeoutSeconds) throws WAImportException {
        String lockName = "import.dataset-repair." + datasetId.getIdentifier();
        DLock lock = null;
        boolean acquired = false;
        try {
            lock = wrangler.getDLock(lockName);
            acquired = lock.tryAcquire(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_FAILED_REPAIR_LOCK, new Object[]{lockName}).withCause((Throwable)ex).build();
        }
        if (acquired) {
            return lock;
        }
        return null;
    }
}

