/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportFeatureFlag;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.util.DataSourceSizeAggregator;
import com.ibm.neo.dataimport.util.ImportFeatureFlagHelper;
import com.ibm.neo.dataimport.util.ImportQuotas;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.security.AccessControlService;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoImportQuotas
extends ImportQuotas {
    static final long DEFAULT_UPLOAD_TOTAL_SIZE_LIMIT = 0x500000000L;
    private static final int DEFAULT_UPLOAD_FILE_COUNT_LIMIT = 20;
    private static final Logger LOG = LoggerFactory.getLogger(NeoImportQuotas.class);
    private final PersistenceService mPS;
    private final boolean mFileQuotasEnabled;
    private final boolean mDiskQuotaEnabled;
    private Properties mConfig;
    private IONObject mTenantQuotas;

    public NeoImportQuotas(Properties config, PersistenceService ps, AccessControlService acs) {
        this.mConfig = config;
        this.mPS = ps;
        try {
            this.mTenantQuotas = acs.getCurrentTenant().getExtendedFields();
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception while retrieving tenant quota values.", (Throwable)e);
        }
        boolean enforceQuotas = Boolean.parseBoolean(this.mConfig.getProperty("com.ibm.neo.dataimport.quotas.enforce-quotas", "true"));
        if (enforceQuotas) {
            Map<EImportFeatureFlag, Boolean> importFeatureFlags = ImportFeatureFlagHelper.determineFeatureFlags();
            this.mFileQuotasEnabled = importFeatureFlags.get(EImportFeatureFlag.ENFORCE_FILE_QUOTAS);
            this.mDiskQuotaEnabled = importFeatureFlags.get(EImportFeatureFlag.ENFORCE_DISK_QUOTA);
        } else {
            this.mFileQuotasEnabled = false;
            this.mDiskQuotaEnabled = false;
        }
    }

    public int getMaxColumnCount() {
        if (!this.mFileQuotasEnabled) {
            return Integer.MAX_VALUE;
        }
        Long count = this.getTenantQuotaValue("MaxDatasourceFieldsNo");
        if (count != null) {
            return count.intValue();
        }
        return (int)this.getConfigValue("com.ibm.neo.dataimport.quotas.max-column-count", 50L);
    }

    public long getMaxRowCount() {
        if (!this.mFileQuotasEnabled) {
            return Long.MAX_VALUE;
        }
        Long count = this.getTenantQuotaValue("MaxDatasourceRecsNo");
        if (count != null) {
            return count;
        }
        return this.getConfigValue("com.ibm.neo.dataimport.quotas.max-row-count", 100000L);
    }

    public long getMaxFileSize() {
        if (!this.mFileQuotasEnabled) {
            return this.getConfigValue("com.ibm.neo.dataimport.upload.total-size-limit", 0x500000000L);
        }
        Long count = this.getTenantQuotaValue("MaxFileUploadSize");
        if (count != null) {
            return count;
        }
        if (this.mConfig.containsKey("com.ibm.neo.dataimport.quotas.max-file-size")) {
            return this.getConfigValue("com.ibm.neo.dataimport.quotas.max-file-size", 524288000L);
        }
        return this.getConfigValue("com.ibm.neo.dataimport.upload.total-size-limit", 524288000L);
    }

    public int getMaxFileUploadCount() {
        return (int)this.getConfigValue("com.ibm.neo.dataimport.upload.file-count-limit", 20L);
    }

    public long getDiskSpaceQuota() {
        if (!this.mDiskQuotaEnabled) {
            return Long.MAX_VALUE;
        }
        Long count = this.getTenantQuotaValue("DiskSpaceQuota");
        if (count != null) {
            return count;
        }
        return this.getConfigValue("com.ibm.neo.dataimport.quotas.disk-space-quota", 524288000L);
    }

    public void checkColumnCount(int numColumns) throws WAImportException {
        int maxColumnsQuota;
        if (this.mFileQuotasEnabled && numColumns > (maxColumnsQuota = this.getMaxColumnCount())) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.COLUMN_COUNT_QUOTA_EXCEEDED).withContextAttribute(EImportMessageContext.COLUMN_COUNT, (Object)numColumns).withContextAttribute(EImportMessageContext.COLUMN_COUNT_LIMIT, (Object)maxColumnsQuota).withMessage((IMessageKey)NeoImportError.COLUMN_COUNT_QUOTA_EXCEEDED, new Object[]{String.valueOf(numColumns), String.valueOf(maxColumnsQuota)}).build();
        }
    }

    public void checkRowCount(long numRows) throws WAImportException {
        long maxRowsQuota;
        if (this.mFileQuotasEnabled && numRows > (maxRowsQuota = this.getMaxRowCount())) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.ROW_COUNT_QUOTA_EXCEEDED).withContextAttribute(EImportMessageContext.ROW_COUNT, (Object)numRows).withContextAttribute(EImportMessageContext.ROW_COUNT_LIMIT, (Object)maxRowsQuota).withMessage((IMessageKey)NeoImportError.ROW_COUNT_QUOTA_EXCEEDED, new Object[]{String.valueOf(numRows), String.valueOf(maxRowsQuota)}).build();
        }
    }

    public void checkFileSize(long fileSize) throws WAImportException {
        long maxFileSizeQuota;
        if (this.mFileQuotasEnabled && fileSize > (maxFileSizeQuota = this.getMaxFileSize())) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.FILE_SIZE_QUOTA_EXCEEDED).withContextAttribute(EImportMessageContext.FILE_SIZE, (Object)fileSize).withContextAttribute(EImportMessageContext.FILE_SIZE_LIMIT, (Object)maxFileSizeQuota).build();
        }
    }

    public void checkDiskUsage(long newDataSize) throws WAImportException {
        if (this.mDiskQuotaEnabled) {
            long currentDiskUsage;
            long maxDiskSizeQuota = this.getDiskSpaceQuota();
            try {
                currentDiskUsage = DataSourceSizeAggregator.sumDataSourceSizes(this.mPS);
            }
            catch (PersistenceException e) {
                LOG.warn("Exception while aggregating the current disk usage. Disk quota cannot be verified or enforced.", (Throwable)e);
                return;
            }
            long newDiskUsage = currentDiskUsage + newDataSize;
            if (newDiskUsage > maxDiskSizeQuota) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.DISK_QUOTA_EXCEEDED).withContextAttribute(EImportMessageContext.DISK_USAGE_INCREMENT, (Object)newDataSize).withContextAttribute(EImportMessageContext.DISK_USAGE, (Object)newDiskUsage).withContextAttribute(EImportMessageContext.DISK_USAGE_LIMIT, (Object)maxDiskSizeQuota).build();
            }
        }
    }

    private Long getTenantQuotaValue(String fieldName) {
        if (this.mTenantQuotas != null && this.mTenantQuotas.containsKey((Object)fieldName)) {
            try {
                return Long.valueOf(this.mTenantQuotas.getString(fieldName));
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse tenant quota field {} as Long.", (Object)fieldName, (Object)e);
            }
        }
        return null;
    }

    private long getConfigValue(String parameter, long defaultValue) {
        String stringValue = this.mConfig.getProperty(parameter);
        if (stringValue != null) {
            try {
                long parsedValue = Long.parseLong(stringValue);
                if (parsedValue < 0L) {
                    LOG.warn("Value for parameter {} is negative. Using default value.", (Object)parameter);
                }
                return parsedValue;
            }
            catch (NumberFormatException e) {
                LOG.warn("Error parsing {} as a long. Using default value for {}.", new Object[]{stringValue, parameter, e});
            }
        }
        return defaultValue;
    }
}

