/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.util;

import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.plugin.EPluginType;
import com.ibm.neo.dataimport.plugin.IPluginContext;
import com.ibm.neo.dataimport.plugin.IRemovePlugin;
import com.ibm.neo.dataimport.plugin.framework.PluginContext;
import com.ibm.neo.dataimport.plugin.framework.PluginManager;
import com.ibm.neo.persist.PersistenceService;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovePluginHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemovePluginHelper.class);
    private final PluginManager mManager;
    private Properties mConfiguration;
    private PersistenceService mPersistenceService;
    private CDFService mCDFService;
    private boolean mReplaceHint;

    public RemovePluginHelper(PluginManager manager) {
        this.mManager = manager;
    }

    public RemovePluginHelper withConfiguration(Properties configuration) {
        this.mConfiguration = configuration;
        return this;
    }

    public RemovePluginHelper withPersistenceService(PersistenceService persistenceService) {
        this.mPersistenceService = persistenceService;
        return this;
    }

    public RemovePluginHelper withCDFService(CDFService cdfService) {
        this.mCDFService = cdfService;
        return this;
    }

    public RemovePluginHelper withReplaceHint(boolean isReplace) {
        this.mReplaceHint = isReplace;
        return this;
    }

    public void tableDropped(UserDataSource dataSource, Dataset dataset, Database database, Table table) {
        List chain = this.mManager.getPluginChain(EPluginType.REMOVE, IRemovePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)dataSource);
        context.put("dataset", (Object)dataset);
        context.put("database", (Object)database);
        context.put("table", (Object)table);
        if (this.mReplaceHint) {
            context.put("replaceHint", (Object)true);
        }
        for (IRemovePlugin p : chain) {
            try {
                p.tableDropped((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void datasetRemoved(UserDataSource dataSource, Dataset dataset) {
        List chain = this.mManager.getPluginChain(EPluginType.REMOVE, IRemovePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)dataSource);
        context.put("dataset", (Object)dataset);
        if (this.mReplaceHint) {
            context.put("replaceHint", (Object)true);
        }
        for (IRemovePlugin p : chain) {
            try {
                p.datasetRemoved((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }

    public void dataSourceRemoved(UserDataSource dataSource) {
        List chain = this.mManager.getPluginChain(EPluginType.REMOVE, IRemovePlugin.class);
        PluginContext context = new PluginContext(this.mConfiguration, this.mPersistenceService, this.mCDFService);
        context.put("dataSource", (Object)dataSource);
        if (this.mReplaceHint) {
            context.put("replaceHint", (Object)true);
        }
        for (IRemovePlugin p : chain) {
            try {
                p.dataSourceRemoved((IPluginContext)context);
            }
            catch (Exception ex) {
                LOGGER.error("Plugin error", (Throwable)ex);
            }
        }
    }
}

