/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab;

import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetWriter;
import com.ibm.neo.dataimport.cdf.sheet.impl.SubSheet;
import com.ibm.neo.dataimport.cdf.util.CDFUtils;
import com.ibm.neo.dataimport.nodel.CrossTabInfo;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.dataimport.xtab.XTabData;
import com.ibm.neo.dataimport.xtab.XTabHelper;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class XSheet
implements ICDFSheet {
    private final ICDFSheet mSource;
    private final CrossTabInfo crossTabInfo;
    private int[] mMaxStringLengths;

    public CrossTabInfo getCrossTabInfo() {
        return this.crossTabInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSheet(ICDFSheet source, int rowSampleCount, boolean disableXtabDetection) throws IOException {
        if (null == source) {
            throw new NullArgumentException("source");
        }
        this.mSource = source;
        try (ICDFSheetReader sheetReader = this.mSource.openReader();){
            ICDFRowCursor cursor = sheetReader.cursor();
            cursor.next();
            XTabHelper helper = new XTabHelper(cursor, rowSampleCount, Locale.US, disableXtabDetection);
            int numColumns = 0;
            if (helper.isCrosstab()) {
                XTabData xtab = new XTabData(cursor, helper.getStartDataX(), helper.getStartDataY(), helper.hasLabels());
                xtab.load();
                numColumns = xtab.getColumnCount();
            }
            this.crossTabInfo = new CrossTabInfo(helper.isCrosstab(), helper.hasLabels(), helper.getDimensionRowCount(), helper.getDimensionColumnCount(), helper.getStartRow(), numColumns, helper.getStartDataX(), helper.getStartDataY());
        }
    }

    public XSheet(ICDFSheet source, CrossTabInfo crossTabInfo) throws IOException {
        if (null == source) {
            throw new NullArgumentException("source");
        }
        this.mSource = source;
        this.crossTabInfo = crossTabInfo;
    }

    ICDFSheet getSource() {
        return this.mSource;
    }

    public SheetInfo getSheetInfo() {
        if (this.crossTabInfo.isCrossTab()) {
            SheetInfo info = new SheetInfo();
            info.setSheetId(this.getId());
            info.setColumnExtent(this.getColumnCount());
            info.setRowExtent(this.getRowCount());
            return info;
        }
        return this.mSource.getSheetInfo();
    }

    public String getId() {
        return this.mSource.getId();
    }

    public File getDataDirectory() {
        return this.mSource.getDataDirectory();
    }

    public long getRowCount() {
        if (this.crossTabInfo.isCrossTab()) {
            return (long)(this.mSource.getColumnCount() - this.crossTabInfo.getStartDataX()) * (this.mSource.getRowCount() - (long)this.crossTabInfo.getStartDataY());
        }
        return this.mSource.getRowCount();
    }

    public int getColumnCount() {
        if (this.crossTabInfo.isCrossTab()) {
            return this.crossTabInfo.getColumnCount();
        }
        return this.mSource.getColumnCount();
    }

    public int getMaxStringLength(int columnIndex) {
        if (this.crossTabInfo.isCrossTab()) {
            if (this.mMaxStringLengths == null) {
                this.mMaxStringLengths = CDFUtils.computeMaxStringLengths((ICDFSheet)this);
            }
            return this.mMaxStringLengths[columnIndex];
        }
        return this.mSource.getMaxStringLength(columnIndex);
    }

    public EDataType getDataType(int columnIndex) {
        return this.mSource.getDataType(columnIndex);
    }

    public boolean isPartitioned() {
        return false;
    }

    public ICDFSheet subSheet(CellRange range) {
        return new SubSheet((ICDFSheet)this, range);
    }

    public ICDFSheetWriter openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ICDFSheetReader openReader() throws IOException {
        if (this.crossTabInfo.isCrossTab()) {
            return new XSheetReader(this.crossTabInfo);
        }
        return this.mSource.openReader();
    }

    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void loadMetadata() throws IOException {
        this.mSource.loadMetadata();
    }

    public void saveMetadata() throws IOException {
        this.mSource.saveMetadata();
    }

    public void destroy() throws IOException {
    }

    public boolean isDestroyed() {
        return false;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("source", (Object)this.mSource.getId());
        return builder.toString();
    }

    private class XSheetReader
    implements ICDFSheetReader {
        final int startDataX;
        final int startDataY;
        final boolean hasLabels;
        private boolean mClosed = false;
        private final ICDFSheetReader sheetReader;

        public XSheetReader(CrossTabInfo crossTabInfo) throws IOException {
            this.sheetReader = XSheet.this.mSource.openReader();
            this.startDataX = crossTabInfo.getStartDataX();
            this.startDataY = crossTabInfo.getStartDataY();
            this.hasLabels = crossTabInfo.hasLabels();
        }

        public void close() throws IOException {
            if (!this.mClosed) {
                this.mClosed = true;
                this.sheetReader.close();
            }
        }

        public ICDFSheet getSheet() {
            return XSheet.this;
        }

        public ICDFRowCursor cursor() throws IOException {
            ICDFRowCursor cursor = this.sheetReader.cursor();
            XTabData xtab = new XTabData(cursor, this.startDataX, this.startDataY, this.hasLabels);
            return new Cursor(xtab);
        }

        public ICDFRow rowAt(long rowIndex) throws IOException {
            if (rowIndex < 0L) {
                throw new IllegalArgumentException("rowIndex < 0");
            }
            ICDFRowCursor cur = this.cursor();
            if (cur.position(rowIndex)) {
                return cur.getRow();
            }
            return null;
        }

        private final class Cursor
        implements ICDFRowCursor {
            private final XTabData xtab;
            private ICDFRow mCurrentRow = null;
            private boolean mReachedEnd = false;

            public Cursor(XTabData xtab) throws IOException {
                this.xtab = xtab;
                this.beforeFirst();
            }

            public long getRowIndex() throws IOException {
                if (null == this.mCurrentRow) {
                    return -1L;
                }
                return this.mCurrentRow.getRowIndex();
            }

            public ICDFRow getRow() throws IOException {
                return this.mCurrentRow;
            }

            public void beforeFirst() throws IOException {
                this.mReachedEnd = false;
                this.mCurrentRow = null;
                try {
                    this.xtab.load();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            public boolean first() throws IOException {
                this.beforeFirst();
                return this.next();
            }

            public boolean next() throws IOException {
                if (this.mReachedEnd) {
                    return false;
                }
                try {
                    this.mCurrentRow = this.xtab.nextRow();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                if (this.mCurrentRow == null) {
                    this.mReachedEnd = true;
                    return false;
                }
                return true;
            }

            public boolean position(long rowIndex) throws IOException {
                this.mCurrentRow = this.xtab.position(rowIndex);
                if (this.mCurrentRow != null) {
                    this.mReachedEnd = false;
                    return true;
                }
                return false;
            }
        }
    }
}

