/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.impl.SimpleCell;
import com.ibm.neo.dataimport.cdf.sheet.impl.SimpleRow;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.util.AnalyzeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class XTabData {
    public static final String VALUE = "Value";
    private final CrosstabParams params;
    private boolean loaded = false;
    private boolean empty = true;
    private int sourceColHeadersDepth;
    private int sourceColsNum;
    private String[][] sourceColumnHeaders;
    private int[] sourceColumnMap;
    private int sourceRowHeadersDepth;
    private int transformedColumnsCount;
    private ICDFCell[] transformedColumnHeaders;
    private int transformedNextRow = 0;
    private int nextColumn = 0;
    private ICDFCell[] currentDataRow = null;
    private ICDFCell[] lastRowHeader;
    private static final String[] excludeArray = new String[]{" total", "sum "};
    private int pivotWidth = 0;
    private final ICDFRowCursor cursor;

    public ICDFCell[] getTransformedColumnHeaders() {
        return this.transformedColumnHeaders;
    }

    public int getTransformedNextRow() {
        return this.transformedNextRow;
    }

    public XTabData(ICDFRowCursor cursor, int startDataX, int startDataY, boolean hasLabels) {
        this.cursor = cursor;
        this.params = new CrosstabParams(startDataX, startDataY, hasLabels);
    }

    public boolean load() throws IOException {
        boolean load = this.load(null);
        return load;
    }

    private boolean load(boolean[] rawCellRead) throws IOException {
        this.cursor.beforeFirst();
        for (int i = 0; i < this.params.startImportAt; ++i) {
            this.nextRow(this.cursor);
        }
        int startImportAt = this.params.startImportAt;
        while (this.nextRow(this.cursor).getCellCount() == 0) {
            ++startImportAt;
        }
        int pivotHeadersDepth = this.params.startY - startImportAt;
        int sourceColHeadersOffset = this.params.hasLabels ? 1 : 0;
        this.sourceColHeadersDepth = pivotHeadersDepth - sourceColHeadersOffset;
        this.sourceRowHeadersDepth = this.params.startX;
        assert (this.sourceColHeadersDepth > 0 && this.sourceRowHeadersDepth > 0);
        this.transformedNextRow = 0;
        this.nextColumn = 0;
        String[][] pivotHeader = this.loadHeader(pivotHeadersDepth);
        if (pivotHeader == null) {
            return false;
        }
        this.extractDimensionNameFormXYAxis(pivotHeader, pivotHeadersDepth);
        this.initializeColumnData(this.pivotWidth, pivotHeader, pivotHeadersDepth, sourceColHeadersOffset);
        this.lastRowHeader = new ICDFCell[this.sourceRowHeadersDepth];
        this.currentDataRow = this.loadNextRawDataRow(rawCellRead);
        this.empty = this.currentDataRow == null;
        this.loaded = true;
        return true;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void dispose() {
        this.empty = true;
        this.loaded = false;
    }

    public int getColumnCount() {
        if (this.transformedColumnHeaders != null) {
            return this.transformedColumnHeaders.length;
        }
        return this.transformedColumnsCount;
    }

    public ICDFRow nextRow() throws Exception {
        if (this.currentDataRow == null) {
            return null;
        }
        long rowIndex = this.transformedNextRow;
        ICDFCell[] rawCells = this.nextRawRow(null);
        return new SimpleRow(rowIndex, rawCells);
    }

    private ICDFCell[] nextRawRow(boolean[] rawCellRead) throws Exception {
        int currentColumn;
        int sourceDataColId;
        ICDFCell value;
        assert (this.loaded);
        do {
            if (this.currentDataRow == null) {
                return null;
            }
            if (this.transformedNextRow++ == 0) {
                if (this.transformedColumnHeaders != null) {
                    return this.transformedColumnHeaders;
                }
                return new ICDFCell[this.transformedColumnsCount];
            }
            if (this.nextColumn >= this.sourceColsNum) {
                this.nextColumn = 0;
                try {
                    this.currentDataRow = this.loadNextRawDataRow(rawCellRead);
                }
                catch (Exception th) {
                    this.currentDataRow = null;
                    throw th;
                }
                if (this.currentDataRow == null) {
                    return null;
                }
            }
            if (this.sourceColumnMap == null || this.sourceColumnMap.length == 0) {
                return null;
            }
            ++this.nextColumn;
        } while ((value = this.getCell(this.currentDataRow, (sourceDataColId = this.sourceColumnMap[currentColumn]) + this.params.startX)) == null || value.isNull());
        ICDFCell[] transformedRow = new ICDFCell[this.transformedColumnsCount];
        System.arraycopy(this.currentDataRow, 0, transformedRow, 0, this.sourceRowHeadersDepth);
        String[] colHeaders = this.sourceColumnHeaders[currentColumn];
        for (int i = 0; i < this.sourceColHeadersDepth; ++i) {
            transformedRow[this.sourceRowHeadersDepth + i] = new SimpleCell(EDataType.STRING, (Object)colHeaders[i], null);
        }
        transformedRow[this.transformedColumnsCount - 1] = value;
        return transformedRow;
    }

    private String[] getStringRow(ICDFRow row) throws IOException {
        if (row == null) {
            return null;
        }
        String[] sRow = new String[row.getCellCount()];
        for (int i = 0; i < row.getCellCount(); ++i) {
            ICDFCell c = row.getCell(i);
            sRow[i] = AnalyzeUtils.formatHeaderLabel(c);
        }
        return sRow;
    }

    private ICDFRow nextRow(ICDFRowCursor cursor) throws IOException {
        if (cursor.next()) {
            ICDFRow row = cursor.getRow();
            return row;
        }
        return null;
    }

    private ICDFCell[] loadNextRawDataRow(boolean[] rawCellRead) throws IOException {
        ICDFRow row;
        while (this.isTotalRow(row = this.nextRow(this.cursor))) {
        }
        if (row == null) {
            return null;
        }
        ICDFCell[] cells = row.getCells(null);
        int rowHeadersDepth = this.sourceRowHeadersDepth > row.getCellCount() ? row.getCellCount() : this.sourceRowHeadersDepth;
        for (int i = 0; i < rowHeadersDepth; ++i) {
            if (cells[i] != null && !cells[i].isNull()) continue;
            cells[i] = this.lastRowHeader[i];
        }
        System.arraycopy(cells, 0, this.lastRowHeader, 0, rowHeadersDepth);
        return cells;
    }

    private boolean isTotalRow(ICDFRow crow) throws IOException {
        String[] row = this.getStringRow(crow);
        if (row == null) {
            return false;
        }
        if (row.length == 0) {
            return true;
        }
        String deepestHeader = XTabData.getCell(row, this.sourceRowHeadersDepth - 1);
        return this.sourceRowHeadersDepth == 1 && deepestHeader.toLowerCase().endsWith(" total") || this.sourceRowHeadersDepth > 1 && deepestHeader.length() == 0;
    }

    private static String getCell(String[] row, int col) {
        String cell = col < row.length ? row[col] : null;
        return cell == null ? "" : cell;
    }

    private ICDFCell getCell(ICDFCell[] row, int col) {
        ICDFCell cell = col < row.length ? row[col] : null;
        return cell;
    }

    private static String[] copyRange(String[] source, int start, int length) {
        String[] copy = new String[length];
        if (start >= source.length) {
            return copy;
        }
        int len = Math.min(length, source.length - start);
        System.arraycopy(source, start, copy, 0, len);
        return copy;
    }

    private boolean includeIt(String name) {
        String lowerCase = name.toLowerCase();
        for (String value : excludeArray) {
            if (!lowerCase.contains(value)) continue;
            return false;
        }
        return true;
    }

    private void initializeColumnData(int pivotWidth, String[][] pivotHeader, int pivotHeadersDepth, int sourceColHeadersOffset) {
        int sourceDataColumns = pivotWidth - this.sourceRowHeadersDepth;
        String[] previousColumnHeaders = new String[this.sourceColHeadersDepth];
        ArrayList<String[]> columnHeaders = new ArrayList<String[]>();
        HashSet<Integer> skipSourceColumns = new HashSet<Integer>();
        for (int i = 0; i < sourceDataColumns; ++i) {
            String deepestHeader = XTabData.getCell(pivotHeader[pivotHeadersDepth - 1], this.sourceRowHeadersDepth + i);
            if (this.sourceColHeadersDepth == 1 && !this.includeIt(deepestHeader) || this.sourceColHeadersDepth > 1 && deepestHeader.length() == 0) {
                skipSourceColumns.add(i);
                continue;
            }
            String[] nestedHeaders = new String[this.sourceColHeadersDepth];
            for (int h = 0; h < this.sourceColHeadersDepth; ++h) {
                nestedHeaders[h] = XTabData.getCell(pivotHeader[h + sourceColHeadersOffset], this.sourceRowHeadersDepth + i);
                this.fillInColumnValueIfBlank(nestedHeaders, previousColumnHeaders, h);
            }
            columnHeaders.add(nestedHeaders);
        }
        this.sourceColumnHeaders = (String[][])columnHeaders.toArray((T[])new String[columnHeaders.size()][]);
        this.sourceColsNum = this.sourceColumnHeaders.length;
        this.sourceColumnMap = new int[this.sourceColsNum];
        int idx = 0;
        for (int i = 0; i < sourceDataColumns; ++i) {
            if (skipSourceColumns.contains(i)) continue;
            this.sourceColumnMap[idx++] = i;
        }
    }

    private void fillInColumnValueIfBlank(String[] nestedHeaders, String[] previousColumnHeaders, int headerIndex) {
        if (nestedHeaders[headerIndex] != null && !"".equals(nestedHeaders[headerIndex])) {
            previousColumnHeaders[headerIndex] = nestedHeaders[headerIndex];
        } else if (previousColumnHeaders[headerIndex] != null && !"".equals(previousColumnHeaders[headerIndex])) {
            nestedHeaders[headerIndex] = previousColumnHeaders[headerIndex];
        }
    }

    private String[][] loadHeader(int pivotHeadersDepth) throws IOException {
        String[][] headerCache = new String[pivotHeadersDepth][];
        for (int i = 0; i < pivotHeadersDepth; ++i) {
            String[] row = this.getStringRow(this.cursor.getRow());
            if (row == null) {
                return null;
            }
            headerCache[i] = row;
            this.pivotWidth = Math.max(this.pivotWidth, row.length);
            if (i >= pivotHeadersDepth - 1) continue;
            this.nextRow(this.cursor);
        }
        String[][] pivotHeader = new String[pivotHeadersDepth][];
        for (int i = 0; i < pivotHeadersDepth; ++i) {
            String[] row = headerCache[i];
            pivotHeader[i] = XTabData.copyRange(row, 0, this.pivotWidth);
        }
        return pivotHeader;
    }

    private void extractDimensionNameFormXYAxis(String[][] pivotHeader, int pivotHeadersDepth) {
        this.transformedColumnsCount = this.sourceColHeadersDepth + this.sourceRowHeadersDepth + 1;
        if (this.params.hasLabels) {
            this.transformedColumnHeaders = new ICDFCell[this.transformedColumnsCount];
            String[] row = pivotHeader[pivotHeadersDepth - 1];
            ICDFCell[] sourceRowHeaderNames = new ICDFCell[this.sourceRowHeadersDepth];
            for (int i = 0; i < this.sourceRowHeadersDepth; ++i) {
                String name = XTabData.getCell(row, i);
                sourceRowHeaderNames[i] = new SimpleCell(EDataType.STRING, (Object)name, null);
            }
            row = pivotHeader[0];
            ArrayList<String> tempArray = new ArrayList<String>();
            ICDFCell[] sourceColHeaderNames = new ICDFCell[this.sourceColHeadersDepth];
            int sourceColHeaderCount = 0;
            for (int i = 0; i < row.length; ++i) {
                String name = XTabData.getCell(row, this.sourceRowHeadersDepth + i);
                if (!tempArray.contains(name)) {
                    sourceColHeaderNames[sourceColHeaderCount++] = new SimpleCell(EDataType.STRING, (Object)name, null);
                    tempArray.add(name);
                }
                if (sourceColHeaderCount == this.sourceColHeadersDepth) break;
            }
            tempArray.clear();
            String measureName = XTabData.getCell(row, 0);
            if (measureName.length() == 0) {
                measureName = VALUE;
            }
            System.arraycopy(sourceRowHeaderNames, 0, this.transformedColumnHeaders, 0, this.sourceRowHeadersDepth);
            System.arraycopy(sourceColHeaderNames, 0, this.transformedColumnHeaders, this.sourceRowHeadersDepth, this.sourceColHeadersDepth);
            this.transformedColumnHeaders[this.transformedColumnHeaders.length - 1] = new SimpleCell(EDataType.STRING, (Object)measureName, null);
        } else {
            this.transformedColumnHeaders = null;
        }
    }

    public int getTrasformedColumnIndex(int i) {
        if (this.transformedColumnsCount < i) {
            return this.transformedColumnsCount;
        }
        return 0;
    }

    public ICDFRow position(long rowIndex) throws IOException {
        if ((long)this.transformedNextRow == rowIndex - 1L) {
            return new SimpleRow((long)this.transformedNextRow, this.currentDataRow);
        }
        if (rowIndex < (long)this.transformedNextRow) {
            this.load();
        }
        ICDFRow row = null;
        try {
            row = this.nextRow();
            while (rowIndex > (long)(this.transformedNextRow - 1)) {
                row = this.nextRow();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return row;
    }

    public class CrosstabParams {
        public static final int ALL = -1;
        public final boolean hasLabels;
        public final int startX;
        public final int startY;
        public final int startImportAt;

        public CrosstabParams(int startX, int startY, boolean hasLabels) {
            assert (startX > 0 && startY > 0);
            this.startX = startX;
            this.startY = startY;
            this.hasLabels = hasLabels;
            this.startImportAt = 0;
        }
    }
}

