/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.util.AnalyzeUtils;
import com.ibm.neo.dataimport.xtab.format.TypeDetect;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XTabHelper
extends TypeDetect {
    private static final int MAX_COUNT_DIMENSION = 10;
    private static Logger logger = LoggerFactory.getLogger(XTabHelper.class);
    private static final Pattern parenthesesPattern = Pattern.compile("\\(.+\\)");
    private final int __startAtRow;
    private IStructuredData data = null;
    private boolean m_isCrossTab = false;
    private int m_startDataX = 0;
    private int m_startDataY = 0;
    private int m_dimensionRowCount = 0;
    private int m_dimensionColumnCount = 0;
    private boolean m_hasLabels = false;
    private int m_startAnalysisAtRow;
    private Map<Integer, FactColumnInfo> fciByColumn = new HashMap<Integer, FactColumnInfo>();
    private FactColumnInfo dimColumn = null;
    private boolean isBlankColumn = false;

    public XTabHelper(ICDFRowCursor cursor, int rowSampleCount, Locale locale, boolean disableXtabDetection) throws IOException {
        super(locale);
        this.data = new SampleData(cursor, rowSampleCount);
        this.m_startAnalysisAtRow = this.__startAtRow = rowSampleCount;
        logger.debug("** Begin crosstab analysis");
        if (!disableXtabDetection) {
            this.initCrosstabData();
        }
        logger.debug("** End crosstab analysis");
    }

    public boolean isCrosstab() {
        return this.m_isCrossTab;
    }

    public int getDimensionColumnCount() {
        return this.m_dimensionColumnCount;
    }

    public int getDimensionRowCount() {
        return this.m_dimensionRowCount - (this.m_hasLabels ? 1 : 0);
    }

    public boolean hasLabels() {
        return this.m_hasLabels;
    }

    public int getStartRow() {
        return this.m_startDataY - this.m_dimensionRowCount;
    }

    public int getStartDataX() {
        return this.m_startDataX;
    }

    public int getStartDataY() {
        return this.m_startDataY;
    }

    private void initCrosstabData() throws IOException {
        this.m_startAnalysisAtRow = Math.min(this.data.rowsCount() - 1, this.__startAtRow);
        if (!this.getFactXYPosition()) {
            logger.debug("No fact area so not a crosstab");
            return;
        }
        while (this.checkForNumericHeader()) {
        }
        if (this.m_startDataX == 0) {
            logger.debug("No header rows so not a crosstab");
            return;
        }
        if (this.m_startDataY == 0) {
            logger.debug("No header columns so not a crosstab");
            return;
        }
        if (this.topLeftAreaFull()) {
            logger.debug("Top left is populated, not a crosstab");
            return;
        }
        this.detectDimensionRows();
        if (this.m_dimensionRowCount == 0) {
            logger.debug("No dimension rows, not a crosstab");
            return;
        }
        this.m_dimensionColumnCount = this.m_startDataX;
        logger.debug("Detected " + this.m_dimensionColumnCount + " dimension columns");
        if (this.m_dimensionColumnCount > 10 && this.isBlankColumn) {
            logger.debug("More  dimension columns, then we support");
            return;
        }
        this.m_isCrossTab = this.determineIfCrossTab();
        if (this.m_isCrossTab && !this.m_hasLabels) {
            this.m_hasLabels = this.determineIfLabels();
        }
    }

    private boolean topLeftAreaFull() throws IOException {
        if (this.m_startDataY <= 1 || this.m_startDataX <= 1) {
            logger.debug("Small top-left area, no check for top-left area full.");
            return false;
        }
        int totalCells = 0;
        int emptyCells = 0;
        for (int y = 0; y < this.m_startDataY; ++y) {
            String[] row = this.data.getRow(y);
            for (int x = 0; x < this.m_startDataX; ++x) {
                ++totalCells;
                String s = XTabHelper.removeWhitespace(this.getRowValue(row, x));
                if (s != null && s.length() != 0 && !s.equalsIgnoreCase("null")) continue;
                ++emptyCells;
            }
        }
        double ratioOfEmptyCells = (double)emptyCells / (double)totalCells;
        logger.debug("Percentage of empty cells in top-left: " + ratioOfEmptyCells * 100.0);
        return ratioOfEmptyCells < 0.1;
    }

    private boolean determineIfLabels() throws IOException {
        int nonBlankCellsAboveDimensionColumns = 0;
        String[] row = this.data.getRow(this.m_startDataY - 1);
        for (int x = 0; x < this.m_startDataX; ++x) {
            String s = XTabHelper.removeWhitespace(this.getRowValue(row, x));
            if (s == null || s.length() <= 0) continue;
            ++nonBlankCellsAboveDimensionColumns;
        }
        if (nonBlankCellsAboveDimensionColumns < this.m_startDataX) {
            logger.debug("Some cells above the dimension columns are empty: no labels");
            return false;
        }
        int firstRowIdx = this.m_startDataY - this.m_dimensionRowCount;
        if (firstRowIdx > 0) {
            ++this.m_dimensionRowCount;
            logger.debug("Dimension columns have labels, bumping up the dimension row count by 1 to accommodate: labels");
            return true;
        }
        logger.debug("Couldn't bump the dimension row count up by 1: no labels");
        return false;
    }

    private String getRowValue(String[] row, int i) {
        if (i < row.length) {
            return row[i];
        }
        return "";
    }

    private boolean determineIfCrossTab() throws IOException {
        for (int x = 0; x < this.m_startDataX; ++x) {
            FactColumnInfo fci = this.lookForFactsInColumn(x, this.m_startAnalysisAtRow);
            if (fci.earliestFactRow == null || TypeDetect.eFactType.DIGITS.equals((Object)fci.getColumnType()) || TypeDetect.eFactType.YEAR.equals((Object)fci.getColumnType())) continue;
            logger.debug("Column " + x + ": is a fact column to the left of the fact area identified -- not a crosstab.");
            return false;
        }
        if (this.m_dimensionRowCount > 1) {
            logger.debug("More than one header row: crosstab");
            return true;
        }
        String[] rowHeader = this.data.getRow(this.m_startDataY - 1);
        for (int x = 0; x < this.m_startDataX; ++x) {
            String s = XTabHelper.removeWhitespace(this.getRowValue(rowHeader, x));
            if (s != null && s.length() != 0) continue;
            logger.debug("Blanks in the header row: crosstab");
            return true;
        }
        HashSet<String> checkUniqueStrings = new HashSet<String>();
        for (int i = this.m_startDataX; i < rowHeader.length; ++i) {
            String s = XTabHelper.removeWhitespace(rowHeader[i]);
            if (s == null || s.length() == 0) continue;
            if (checkUniqueStrings.contains(s)) {
                logger.debug("Duplicates in the 1 dimension row: crosstab");
                return true;
            }
            checkUniqueStrings.add(s);
        }
        TypeDetect.eFactType commonType = null;
        for (FactColumnInfo fci : this.fciByColumn.values()) {
            TypeDetect.eFactType columnType = fci.getColumnType();
            if (columnType == null) continue;
            if (commonType != null && !columnType.equals((Object)commonType)) {
                logger.debug("Fact column types found with heterogeneous types -- not a crosstab: " + commonType.name() + " and " + columnType.name());
                return false;
            }
            commonType = columnType;
        }
        if (parenthesesPattern.matcher(rowHeader[0]).matches()) {
            logger.debug("Top-left column header in parentheses " + rowHeader[0] + ": crosstab");
            return true;
        }
        if (this.m_dimensionColumnCount == 1 && this.fciByColumn.size() > 1 && this.fciByColumn.size() + 1 == rowHeader.length && this.dimColumn != null && !TypeDetect.eFactType.YEAR.equals((Object)this.dimColumn.getColumnType())) {
            logger.debug("Only one dimension column but " + this.fciByColumn.size() + " fact columns -- crosstab");
            return true;
        }
        logger.debug("Nothing definitive makes it a crosstab -- so it is a list");
        return false;
    }

    private void detectDimensionRows() throws IOException {
        this.m_dimensionRowCount = 0;
        for (int y = this.m_startDataY - 1; y >= 0; --y) {
            String[] row = this.data.getRow(y);
            if (row == null) {
                return;
            }
            int nonEmptyLabels = 0;
            boolean sawBlank = false;
            boolean sawLabelAfterBlank = false;
            for (int x = this.m_startDataX; x < row.length; ++x) {
                String s = XTabHelper.removeWhitespace(row[x]);
                if (s == null || s.length() == 0) {
                    sawBlank = true;
                    continue;
                }
                if (!sawBlank) {
                    ++nonEmptyLabels;
                    continue;
                }
                sawLabelAfterBlank = true;
            }
            if (nonEmptyLabels == 0 && !sawLabelAfterBlank) break;
            if (nonEmptyLabels == this.m_dimensionRowCount && !sawLabelAfterBlank && this.m_dimensionRowCount > 0) {
                logger.debug("Top dimension row looks like a label row since it has " + nonEmptyLabels + " contiguous non-empty values: labels");
                this.m_hasLabels = true;
            }
            ++this.m_dimensionRowCount;
            if (this.m_hasLabels) break;
        }
        logger.debug("Detected " + this.m_dimensionRowCount + " dimension rows");
    }

    private boolean checkForNumericHeader() throws IOException {
        boolean bl;
        TypeDetect.eFactType ft;
        int x;
        if (this.data.rowsCount() - this.m_startDataY <= 1) {
            return false;
        }
        String[] topRow = this.data.getRow(this.m_startDataY);
        if (topRow == null) {
            return false;
        }
        String[] nextRow = this.data.getRow(this.m_startDataY + 1);
        if (nextRow == null) {
            return false;
        }
        boolean hasDigits = false;
        boolean hasBlanks = false;
        for (x = this.m_startDataX; x < topRow.length; ++x) {
            ft = this.detectFact(topRow[x]);
            if (TypeDetect.eFactType.BLANK.equals((Object)ft)) {
                hasBlanks = true;
                continue;
            }
            if (TypeDetect.eFactType.DIGITS.equals((Object)ft) || TypeDetect.eFactType.YEAR.equals((Object)ft)) {
                hasDigits = true;
                continue;
            }
            logger.debug("Top row of fact data contains other than digit/blank, don't adjust the header position.");
            return false;
        }
        if (hasBlanks && !hasDigits) {
            logger.debug("Top row of fact data is all blanks, so don't adjust the header position.");
            return false;
        }
        if (this.m_startDataX > 0 && this.m_startDataX < topRow.length && this.m_startDataX < nextRow.length) {
            TypeDetect.eFactType ftLeft = this.detectFact(topRow[this.m_startDataX - 1]);
            TypeDetect.eFactType ftLeftDown = this.detectFact(nextRow[this.m_startDataX - 1]);
            if (TypeDetect.eFactType.BLANK.equals((Object)ftLeft) && ftLeftDown == null) {
                ++this.m_startDataY;
                logger.debug("Moving fact Y down to " + this.m_startDataY + " since the top row was all digits, the cell to the left of the fact data area is blank but the one below that is text.");
                return true;
            }
        }
        for (x = this.m_startDataX; x < nextRow.length; ++x) {
            ft = this.detectFact(nextRow[x]);
            if (!TypeDetect.eFactType.CURRENCY.equals((Object)ft) && !TypeDetect.eFactType.PERCENT.equals((Object)ft) && !TypeDetect.eFactType.DOUBLE.equals((Object)ft)) continue;
            ++this.m_startDataY;
            logger.debug("Moving fact Y down to " + this.m_startDataY + " since the top row was all digits but the next was not -- we presume it is actually a header.");
            return true;
        }
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (int x2 = this.m_startDataX; x2 < topRow.length; ++x2) {
            String s = XTabHelper.removeWhitespace(topRow[x2]);
            if (s == null || s.length() <= 0) continue;
            try {
                ParsePosition parsePosition = new ParsePosition(0);
                Object number = this.numberFormat.parseObject(s, parsePosition);
                if (number instanceof Integer) {
                    vals.add((Integer)number);
                    continue;
                }
                if (number instanceof Long) {
                    vals.add(((Long)number).intValue());
                    continue;
                }
                vals.add(Integer.MAX_VALUE);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int yearsFound = 0;
        for (Integer n : vals) {
            if (1900 >= n || n >= 2100) continue;
            ++yearsFound;
        }
        if (yearsFound > 1 && yearsFound == vals.size()) {
            ++this.m_startDataY;
            logger.debug("Moving fact Y down to " + this.m_startDataY + " since digits in the top row all seem like years.");
            return true;
        }
        HashSet<Integer> seq = new HashSet<Integer>();
        for (Integer val : vals) {
            seq.add(val);
        }
        boolean bl2 = seq.size() > 1;
        for (int i = 1; i <= seq.size(); ++i) {
            if (seq.contains(i)) continue;
            bl = false;
            break;
        }
        if (bl && this.dimColumn != null && !TypeDetect.eFactType.YEAR.equals((Object)this.dimColumn.getColumnType())) {
            ++this.m_startDataY;
            logger.debug("Moving fact Y down to " + this.m_startDataY + " since digits in the top row form in increasing sequence (possibly repeating)");
            return true;
        }
        return false;
    }

    private boolean getFactXYPosition() throws IOException {
        int x;
        Integer startDataX = null;
        Integer startDataY = null;
        int minY = 0;
        FactColumnInfo fci = null;
        if (this.data.columnsCount() <= 2) {
            return false;
        }
        for (x = this.data.columnsCount() - 1; x >= 0; --x) {
            fci = this.lookForFactsInColumn(x, this.m_startAnalysisAtRow);
            if (fci.earliestFactRow == null && fci.earliestBlankRow == null || TypeDetect.eFactType.YEAR.equals((Object)fci.getColumnType())) {
                logger.debug("Column " + x + ": not a fact column");
                if (startDataX != null || this.fciByColumn.size() <= 0 || minY <= 0) break;
                boolean foundNonFactColumn = false;
                for (Integer idx : this.fciByColumn.keySet()) {
                    FactColumnInfo checkIfReallyBlank = this.lookForFactsInColumn(idx, this.data.rowsCount() - 1);
                    Integer earliestRow = checkIfReallyBlank.earliestRow();
                    if (earliestRow == null || earliestRow <= minY) continue;
                    logger.debug("Row " + idx + " is not really blank; don't consider this a crosstab.");
                    foundNonFactColumn = true;
                    break;
                }
                if (foundNonFactColumn) break;
                logger.debug("Blank columns with likely headers found. Setting minimum Y position to " + minY);
                startDataX = x + 1;
                startDataY = minY;
                this.isBlankColumn = true;
                break;
            }
            minY = Math.max(minY, fci.earliestRow());
            if (startDataY != null && minY > startDataY) {
                logger.debug("Column " + x + " is not a fact column: non-facts located below identified facts");
                break;
            }
            if (fci.earliestFactRow != null) {
                int earliestFactRow = fci.earliestFactRow;
                if (earliestFactRow < minY) {
                    logger.debug("Column " + x + " found fact data in row " + earliestFactRow + " but the minimum Y position is " + minY);
                    earliestFactRow = minY;
                }
                if (startDataY == null || earliestFactRow < startDataY) {
                    startDataY = earliestFactRow;
                    logger.debug("Column " + x + ": is a fact column, the earliest row is now " + startDataY);
                }
                startDataX = x;
            } else {
                logger.debug("Column " + x + ": is blank");
                if (startDataX != null) {
                    startDataX = x;
                    logger.debug(" -> earliest row is now " + x);
                }
            }
            this.fciByColumn.put(x, fci);
        }
        if (x >= 0) {
            this.dimColumn = fci;
        }
        boolean foundFactXYPosition = startDataX != null;
        logger.debug("foundFactXYPosition? " + foundFactXYPosition);
        if (foundFactXYPosition) {
            if (minY < startDataY) {
                startDataY = minY;
                logger.debug("Changing earliest row to " + startDataY + " to encompass blank rows in the fact data.");
            }
            this.m_startDataX = startDataX;
            this.m_startDataY = startDataY;
            logger.debug("X: " + this.m_startDataX + ", Y: " + this.m_startDataY);
        }
        return foundFactXYPosition;
    }

    private FactColumnInfo lookForFactsInColumn(int x, int y) throws IOException {
        FactColumnInfo fci = new FactColumnInfo();
        while (y >= 0) {
            String value = this.data.getValue(x, y);
            if (value != null) {
                TypeDetect.eFactType ft = this.detectFact(value);
                if (ft == null) break;
                if (ft.equals((Object)TypeDetect.eFactType.BLANK)) {
                    fci.earliestBlankRow = y;
                } else {
                    fci.earliestFactRow = y;
                }
                fci.addFactType(ft);
            } else {
                fci.earliestBlankRow = y;
            }
            --y;
        }
        return fci;
    }

    private static class FactColumnInfo {
        Integer earliestFactRow = null;
        Integer earliestBlankRow = null;
        Map<TypeDetect.eFactType, Integer> typeCount = new HashMap<TypeDetect.eFactType, Integer>();

        private FactColumnInfo() {
        }

        public String toString() {
            return "FactColumnInfo [earliestFactRow=" + this.earliestFactRow + ", earliestBlankRow=" + this.earliestBlankRow + ", typeCount=" + this.typeCount + "]";
        }

        void addFactType(TypeDetect.eFactType ft) {
            int count = this.getFactCount(ft);
            this.typeCount.put(ft, ++count);
        }

        int getFactCount(TypeDetect.eFactType ft) {
            Integer count = this.typeCount.get((Object)ft);
            if (count == null) {
                count = 0;
            }
            return count;
        }

        Integer earliestRow() {
            if (this.earliestFactRow == null) {
                return this.earliestBlankRow;
            }
            if (this.earliestBlankRow == null) {
                return this.earliestFactRow;
            }
            return Math.min(this.earliestBlankRow, this.earliestFactRow);
        }

        TypeDetect.eFactType getColumnType() {
            TypeDetect.eFactType result = null;
            for (TypeDetect.eFactType key : this.typeCount.keySet()) {
                if (TypeDetect.eFactType.BLANK.equals((Object)key)) continue;
                if (result != null) {
                    return null;
                }
                result = key;
            }
            return result;
        }
    }

    private static class SampleData
    implements IStructuredData {
        private final ICDFRowCursor cursor;
        private final int numColumns;
        private int mRowSampleCount;

        public SampleData(ICDFRowCursor cursor, int rowSampleCount) throws IOException {
            this.cursor = cursor;
            this.mRowSampleCount = rowSampleCount;
            this.numColumns = this.getColumnCount();
        }

        private int getColumnCount() throws IOException {
            long currentPosition = this.cursor.getRowIndex();
            int cellsCount = 0;
            Long count = 0L;
            while (this.cursor.next()) {
                ICDFRow row = this.cursor.getRow();
                int n = cellsCount = row.getCellCount() > cellsCount ? row.getCellCount() : cellsCount;
                if (this.mRowSampleCount < Long.valueOf(this.cursor.getRowIndex()).intValue()) break;
                count = this.cursor.getRowIndex();
            }
            this.mRowSampleCount = count.intValue();
            this.cursor.position(currentPosition);
            return cellsCount;
        }

        @Override
        public int rowsCount() {
            return this.mRowSampleCount;
        }

        @Override
        public String[] getRow(int index) throws IOException {
            if ((long)index == this.cursor.getRowIndex()) {
                return this.getRow();
            }
            if (this.cursor.position((long)index)) {
                return this.getRow();
            }
            return null;
        }

        private String[] getRow() throws IOException {
            ICDFRow row = this.cursor.getRow();
            String[] sRow = new String[row.getCellCount()];
            for (int i = 0; i < row.getCellCount(); ++i) {
                ICDFCell c = row.getCell(i);
                sRow[i] = AnalyzeUtils.formatHeaderLabel(c);
            }
            return sRow;
        }

        @Override
        public int columnsCount() {
            return this.numColumns;
        }

        @Override
        public String[] nextRow() throws Exception {
            if (this.cursor.next()) {
                return this.getRow();
            }
            return null;
        }

        @Override
        public String getValue(int x, int y) throws IOException {
            ICDFRow row = null;
            if (this.cursor.getRowIndex() == (long)y) {
                row = this.cursor.getRow();
            } else if (this.cursor.position((long)y)) {
                row = this.cursor.getRow();
            } else {
                return null;
            }
            if (x < row.getCellCount()) {
                ICDFCell c = row.getCell(x);
                String value = AnalyzeUtils.formatHeaderLabel(c);
                return value;
            }
            return null;
        }
    }

    protected static interface IStructuredData {
        public int rowsCount();

        public String[] getRow(int var1) throws IOException;

        public int columnsCount();

        public String[] nextRow() throws Exception;

        public String getValue(int var1, int var2) throws IOException;
    }
}

