/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab.format;

import com.ibm.icu.text.Transliterator;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class CurrencyFormat
extends NumberFormat {
    private static final long serialVersionUID = -408063593468019431L;
    private final NumberFormat currencyFormat;
    private static Transliterator widthTransliterator;

    public CurrencyFormat(Locale locale) {
        this.currencyFormat = NumberFormat.getCurrencyInstance(locale);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.currencyFormat.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.currencyFormat.format(number, toAppendTo, pos);
    }

    @Override
    public Number parse(String value) {
        return this.parse(value, new ParsePosition(0));
    }

    @Override
    public Number parse(String value, ParsePosition parsePosition) {
        Number currency = (Number)this.currencyFormat.parseObject(value, parsePosition);
        if (currency == null) {
            int indexCurrency = -1;
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (26 != Character.getType(ch)) continue;
                indexCurrency = i;
                break;
            }
            if (indexCurrency >= 0) {
                this.createWidthTransliterator();
                char currSymbol = value.charAt(indexCurrency);
                String newCurrSymbol = widthTransliterator.transliterate(Character.toString(currSymbol));
                if (newCurrSymbol != null && newCurrSymbol.length() > 0) {
                    value = value.replace(value.charAt(indexCurrency), newCurrSymbol.charAt(0));
                    currency = (Number)this.currencyFormat.parseObject(value, new ParsePosition(0));
                }
            }
        }
        return currency;
    }

    private synchronized void createWidthTransliterator() {
        if (widthTransliterator == null && widthTransliterator == null) {
            widthTransliterator = Transliterator.getInstance((String)"Halfwidth-Fullwidth");
        }
    }
}

