/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class ScientificFormat
extends NumberFormat {
    private static final long serialVersionUID = 3559830818851340046L;
    private final NumberFormat numberFormat;

    public ScientificFormat(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition position) {
        int startIndex = position.getIndex();
        Number number = this.numberFormat.parse(source, position);
        if (position.getErrorIndex() == -1 && position.getIndex() == source.length()) {
            return number;
        }
        String orgSource = source;
        int idx = source.toLowerCase().indexOf("e+");
        if (idx >= 0) {
            source = source.substring(0, idx + 1) + source.substring(idx + 2);
            position.setIndex(startIndex);
            number = this.numberFormat.parse(source, position);
            if (position.getIndex() == source.length()) {
                position.setIndex(orgSource.length());
            }
        }
        return number;
    }
}

