/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.xtab.format;

import com.ibm.neo.dataimport.xtab.format.CurrencyFormat;
import com.ibm.neo.dataimport.xtab.format.ScientificFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Pattern;

public class TypeDetect {
    protected static final Pattern NO_VALUE_REGEX = Pattern.compile("-+|[nN][aA]|[nN]/[aA]|\\.|\\.\\.|\\.\\.\\.");
    private static final Pattern codePattern = Pattern.compile("0[0-9]+");
    private static final Pattern PATTERN_SPACE = Pattern.compile("[\\s\\u00A0]");
    protected final CurrencyFormat currencyFormat;
    protected final NumberFormat numberFormat;
    protected final NumberFormat percentFormat;

    public TypeDetect(Locale locale) {
        this.numberFormat = new ScientificFormat(locale);
        this.percentFormat = NumberFormat.getPercentInstance(locale);
        this.currencyFormat = new CurrencyFormat(locale);
    }

    private static boolean filter(String str) {
        return str == null || str.trim().length() == 0 || NO_VALUE_REGEX.matcher(str).matches();
    }

    protected static String removeWhitespace(String s) {
        if (s == null) {
            return s;
        }
        return PATTERN_SPACE.matcher(s).replaceAll("");
    }

    public static String[] splitWhitespace(String s) {
        if (s == null) {
            return null;
        }
        return PATTERN_SPACE.split(s, -1);
    }

    public eFactType detectFact(String value) {
        value = TypeDetect.removeWhitespace(value);
        eFactType result = null;
        if (value == null || value.length() == 0 || TypeDetect.filter(value)) {
            result = eFactType.BLANK;
        } else if (codePattern.matcher(value).matches()) {
            result = null;
        } else {
            ParsePosition position;
            Object number;
            Object currency;
            Object percent = this.percentFormat.parseObject(value, new ParsePosition(0));
            if (percent != null) {
                value = percent.toString();
                result = eFactType.PERCENT;
            } else if (value.contains("%")) {
                value = value.replace("%", "");
                result = eFactType.PERCENT;
            }
            if (result == null && (currency = this.currencyFormat.parseObject(value, new ParsePosition(0))) != null) {
                value = currency.toString();
                result = eFactType.CURRENCY;
            }
            if ((number = this.numberFormat.parseObject(value, position = new ParsePosition(0))) == null || position.getErrorIndex() != -1 || position.getIndex() < value.length()) {
                result = null;
            } else if (result == null) {
                if (number instanceof Double) {
                    result = eFactType.DOUBLE;
                } else {
                    long n = 0L;
                    if (number instanceof Integer) {
                        n = ((Integer)number).intValue();
                    } else if (number instanceof Long) {
                        n = (Long)number;
                    }
                    result = 1900L < n && n < 2100L ? eFactType.YEAR : eFactType.DIGITS;
                }
            }
        }
        return result;
    }

    public static enum eFactType {
        BLANK,
        DIGITS,
        DOUBLE,
        PERCENT,
        CURRENCY,
        YEAR;

    }
}

