/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.api;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.api.model.EAggregateType;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Grouping;
import com.ibm.neo.g11n.LocaleUtil;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ImportSlipReader {
    private static final IONArray EMPTY_ARRAY = new IONArray();
    private ISDataSource mSource;

    public ImportSlipReader(IONObject importSlip) {
        this.mSource = importSlip == null ? new ISDataSource() : new ISDataSource(importSlip);
    }

    public ISDataSource dataSource() {
        return this.mSource;
    }

    public static class ISDataItem
    extends ISElement {
        private static final long serialVersionUID = 1L;
        private static final Set<String> DATA_ITEM_EXTENDED_FIELDS = new HashSet<String>(Arrays.asList("aggregate", "deploy-as-local-tz", "derived-from", "enable-data-groups", "expand-to-seconds", "values-indexable", "visible"));

        public ISDataItem() {
        }

        public ISDataItem(IONObject contents) {
            super(contents);
        }

        public int getIndex() {
            return this.getInt("index", -1);
        }

        public String getId() {
            return this.getString("id");
        }

        public ImportSlip.ISDataType getDataType() {
            String typeName = this.getString("data-type");
            if (typeName != null) {
                for (ImportSlip.ISDataType type : ImportSlip.ISDataType.values()) {
                    if (!StringUtils.equalsIgnoreCase((String)type.name(), (String)typeName)) continue;
                    return type;
                }
            }
            return null;
        }

        public String getReplaces() {
            return this.getString("replaces");
        }

        public String getLabel() {
            return this.getString("label");
        }

        public boolean getValuesIndexable() {
            return this.getBoolean("values-indexable", true);
        }

        public int getMaxStringLength() {
            long value = this.getLong("max-string-length", -1L);
            if (value <= 0L) {
                return -1;
            }
            if (value > (long)ImportSlip.PROP_CAP_MAX_STRING_LENGTH.intValue()) {
                return ImportSlip.PROP_CAP_MAX_STRING_LENGTH;
            }
            return (int)value;
        }

        public EAggregateType getAggregate() {
            String aggregateStr = this.getString("aggregate");
            if (aggregateStr != null) {
                return EAggregateType.getAggregate((String)aggregateStr);
            }
            return null;
        }

        public boolean deployAsLocalTimezone() {
            return this.getBoolean("deploy-as-local-tz", false);
        }

        public boolean enableDataGroups() {
            return this.getBoolean("enable-data-groups", true);
        }

        public boolean expandToSeconds() {
            return this.getBoolean("expand-to-seconds", false);
        }

        public String getDerivedFrom() {
            return this.getString("derived-from");
        }

        public boolean visible() {
            return this.getBoolean("visible", true);
        }

        public DataItem getDataItem(List<DataItem> items) {
            int index;
            ArrayList<DataItem> visibleItems = new ArrayList<DataItem>(items.size());
            visibleItems.addAll(items);
            for (int i = 0; i < visibleItems.size(); ++i) {
                if (!((DataItem)visibleItems.get(i)).getName().equals("__row_id__")) continue;
                visibleItems.remove(i);
                break;
            }
            if ((index = this.getIndex()) >= 0 && index < visibleItems.size()) {
                return (DataItem)visibleItems.get(index);
            }
            String id = this.getId();
            if (id != null) {
                for (DataItem item : visibleItems) {
                    if (!item.getName().equals(id)) continue;
                    return item;
                }
            }
            return null;
        }

        @Override
        protected Set<String> getExtendedFieldKeys() {
            return DATA_ITEM_EXTENDED_FIELDS;
        }

        @Override
        protected String getChildenArrayFieldName() {
            return "";
        }

        @Override
        protected IONArray getChildrenIONs() {
            return EMPTY_ARRAY;
        }
    }

    public static class ISDataset
    extends ISElement {
        private static final long serialVersionUID = 1L;
        private static final Set<String> DATASET_EXTENDED_FIELDS = new HashSet<String>(Arrays.asList("related-artifacts"));
        private ISDataItem mItem = new ISDataItem();

        public ISDataset() {
        }

        public ISDataset(IONObject contents) {
            super(contents);
        }

        public ISDataItem getItem(String id) {
            this.mItem = new ISDataItem(this.getChildION(id));
            return this.mItem;
        }

        public ISDataItem getItem(int index) {
            this.mItem = new ISDataItem(this.getChildION(index));
            return this.mItem;
        }

        public ISDataItem getItem(int index, String id) {
            this.mItem = new ISDataItem(this.getChildIONByIndexOrId(index, id));
            return this.mItem;
        }

        public List<ISDataItem> getDataItemsWithField(String field) {
            ArrayList<ISDataItem> dataItems = new ArrayList<ISDataItem>();
            IONArray children = this.getChildrenWithField(field);
            for (int i = 0; i < children.size(); ++i) {
                dataItems.add(new ISDataItem(children.getIONObject(i)));
            }
            return dataItems;
        }

        public ISDataItem nextItem() {
            this.mItem = new ISDataItem(this.nextChildION());
            return this.mItem;
        }

        public ISDataItem item() {
            return this.mItem;
        }

        public int getIndex() {
            return this.getInt("index", -1);
        }

        public String getId() {
            return this.getString("id");
        }

        public long getHeaderRowIndex() {
            return this.getLong("header-row-index", -1L);
        }

        public List<Grouping> getGroupings() {
            if (this.containsKey("groupings")) {
                IONArray array = this.getIONArray("groupings");
                ArrayList<Grouping> groupings = new ArrayList<Grouping>();
                for (int i = 0; i < array.size(); ++i) {
                    Grouping grouping = new Grouping();
                    grouping.decodeION(array.getIONObject(i));
                    groupings.add(grouping);
                }
                return groupings;
            }
            return null;
        }

        public IONObject getRelatedArtifacts() {
            return this.getIONObject("related-artifacts");
        }

        @Override
        protected Set<String> getExtendedFieldKeys() {
            return DATASET_EXTENDED_FIELDS;
        }

        @Override
        protected String getChildenArrayFieldName() {
            return "data-items";
        }

        public ISDataItem getItemForDataItem(DataItem dataItem) {
            if (dataItem == null) {
                return null;
            }
            if (dataItem.getSourceColumnIndex() >= 0) {
                return this.getItem(dataItem.getSourceColumnIndex(), dataItem.getName());
            }
            return this.getItem(dataItem.getName());
        }
    }

    public static class ISDataSource
    extends ISElement {
        private static final long serialVersionUID = 1L;
        private static final Set<String> DATA_SOURCE_EXTENDED_FIELDS = Collections.emptySet();
        private ISDataset mDataset = new ISDataset();

        public ISDataSource() {
        }

        public ISDataSource(IONObject contents) {
            super(contents);
        }

        public ISDataset getDataset(String id) {
            this.mDataset = new ISDataset(this.getChildION(id));
            return this.mDataset;
        }

        public ISDataset getDataset(int index) {
            this.mDataset = new ISDataset(this.getChildION(index));
            return this.mDataset;
        }

        public ISDataset getDataset(int index, String id) {
            this.mDataset = new ISDataset(this.getChildIONByIndexOrId(index, id));
            return this.mDataset;
        }

        public List<ISDataset> getDatasetsWithField(String field) {
            ArrayList<ISDataset> datasets = new ArrayList<ISDataset>();
            IONArray children = this.getChildrenWithField(field);
            for (int i = 0; i < children.size(); ++i) {
                datasets.add(new ISDataset(children.getIONObject(i)));
            }
            return datasets;
        }

        public ISDataset nextDataset() {
            this.mDataset = new ISDataset(this.nextChildION());
            return this.mDataset;
        }

        public ISDataset dataset() {
            return this.mDataset;
        }

        public int getVersion() {
            return this.getInt("slip-version", 0);
        }

        public boolean isAppendData() {
            return this.getBoolean("append-data", false);
        }

        public List<Integer> getSelectedSections() throws WAImportException {
            if (this.containsKey("sections")) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                for (Object entry : this.getChildArray("sections")) {
                    if (!(entry instanceof Number)) continue;
                    values.add(((Number)entry).intValue());
                }
                return values;
            }
            return null;
        }

        public ImportSlip.UnmatchedColumnsMode getUnmatchedColumnsMode() {
            try {
                return ImportSlip.UnmatchedColumnsMode.valueOf(this.getString("unmatched-columns", ImportSlip.UnmatchedColumnsMode.prompt.name()));
            }
            catch (IllegalArgumentException e) {
                return ImportSlip.UnmatchedColumnsMode.prompt;
            }
        }

        public String getCharacterSetEncoding() {
            return this.getString("iso-character-set-encoding");
        }

        public Character getFieldEncapsulator() {
            String charString = this.getString("field-encapsulator");
            if (StringUtils.isEmpty((String)charString)) {
                return null;
            }
            return Character.valueOf(charString.charAt(0));
        }

        public Locale getAnalyticsLocale() {
            return LocaleUtil.localeFromString((String)this.getString("analytics-locale"));
        }

        @Override
        protected Set<String> getExtendedFieldKeys() {
            return DATA_SOURCE_EXTENDED_FIELDS;
        }

        @Override
        protected String getChildenArrayFieldName() {
            return "datasets";
        }
    }

    public static abstract class ISElement
    extends IONObject {
        private static final long serialVersionUID = 1L;
        protected static final int INVALID_INDEX = -1;
        protected int mChildIndex = -1;

        public ISElement() {
        }

        public ISElement(IONObject contents) {
            super((Map)contents);
        }

        public String getName() {
            return this.getString("name");
        }

        public IONObject getExtendedFields() {
            IONObject properties = new IONObject();
            Set<String> extendedKeys = this.getExtendedFieldKeys();
            for (Map.Entry entry : this.entrySet()) {
                if (!extendedKeys.contains(entry.getKey())) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
            return properties;
        }

        public IONObject getCustomProperties() {
            return this.getIONObject("custom-properties");
        }

        protected abstract Set<String> getExtendedFieldKeys();

        protected IONObject getChildION(String id) {
            this.mChildIndex = -1;
            IONObject currentChild = new IONObject();
            if (id != null) {
                IONArray children = this.getChildrenIONs();
                for (int i = 0; i < children.size(); ++i) {
                    IONObject child = children.getIONObject(i);
                    if (!id.equals(child.getString("id"))) continue;
                    currentChild = child;
                    if (!child.containsKey((Object)"index")) continue;
                    this.mChildIndex = child.getInt("index");
                }
            }
            return currentChild;
        }

        protected IONObject getChildION(int index) {
            this.mChildIndex = index;
            IONObject currentChild = new IONObject();
            IONArray children = this.getChildrenIONs();
            for (int i = 0; i < children.size(); ++i) {
                IONObject child = children.getIONObject(i);
                if (child.getInt("index", -1) != index) continue;
                currentChild = child;
            }
            return currentChild;
        }

        protected IONObject getChildIONByIndexOrId(int index, String id) {
            IONObject byIndex = this.getChildION(index);
            if (byIndex.containsKey((Object)"index")) {
                return byIndex;
            }
            return this.getChildION(id);
        }

        protected IONObject nextChildION() {
            return this.getChildION(++this.mChildIndex);
        }

        protected IONArray getChildArray(String field) throws WAImportException {
            try {
                return this.getIONArray(field);
            }
            catch (Exception e) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INVALID_IMPORT_SLIP).withMessage((IMessageKey)NeoImportError.NEOIMPORTAPI_ERR_INVALID_IMPORT_SLIP, field).build();
            }
        }

        protected IONArray getChildrenIONs() {
            if (this.containsKey(this.getChildenArrayFieldName())) {
                return this.getIONArray(this.getChildenArrayFieldName());
            }
            return EMPTY_ARRAY;
        }

        protected abstract String getChildenArrayFieldName();

        protected IONArray getChildrenWithField(String field) {
            IONArray array = new IONArray();
            for (Object child : this.getChildrenIONs()) {
                IONObject ionChild;
                if (!(child instanceof IONObject) || !(ionChild = (IONObject)child).containsKey((Object)field)) continue;
                array.add((Object)ionChild);
            }
            return array;
        }
    }
}

