/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.api;

import com.ibm.cognos.aurora.api.model.EAggregateType;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.g11n.LocaleUtil;
import com.ibm.neo.messages.NeoMessageKeys;
import com.ibm.neo.messages.NeoMessageUtil;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ImportSlipValidator {
    public List<Concern> validateSlip(IONObject slip) {
        LinkedList<Concern> concerns = new LinkedList<Concern>();
        if (slip != null) {
            this.validateDataSource(slip, concerns);
        }
        return concerns;
    }

    public List<Concern> validateSlipUnset(IONObject unset) {
        LinkedList<Concern> concerns = new LinkedList<Concern>();
        if (unset != null) {
            this.validateDataSourceUnset(unset, concerns);
        }
        return concerns;
    }

    public static IONArray toIONs(List<Concern> concerns) {
        IONArray array = new IONArray();
        for (Concern concern : concerns) {
            array.add((Object)concern.toION());
        }
        return array;
    }

    public static void throwExceptionIfConcerned(List<Concern> concerns) throws WAImportException {
        if (!concerns.isEmpty()) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INVALID_IMPORT_SLIP).withContextAttribute(EImportMessageContext.IMPORT_SLIP_CONCERNS, ImportSlipValidator.toIONs(concerns)).build();
        }
    }

    private void validateDataSource(IONObject dataSource, List<Concern> concerns) {
        String type = "data-source";
        this.validateCommonProperties(type, dataSource, concerns);
        Iterator iterator = dataSource.keySet().iterator();
        block27: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "slip-version": {
                    this.validateIntegerProperty(type, dataSource, key, false, new Long(0L), concerns);
                    continue block27;
                }
                case "append-data": {
                    this.validateProperty(type, dataSource, key, Boolean.class, false, concerns);
                    continue block27;
                }
                case "analytics-locale": {
                    Locale analyticsLocale = null;
                    try {
                        analyticsLocale = LocaleUtil.localeFromString((String)dataSource.getString("analytics-locale"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (analyticsLocale != null) continue block27;
                    concerns.add(new Concern(type, key, Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_ANALYTICS_LOCALE, "analytics-locale")));
                    continue block27;
                }
                case "sections": {
                    this.validateArrayProperty(type, dataSource, key, Long.class, false, false, new Long(0L), concerns);
                    continue block27;
                }
                case "unmatched-columns": {
                    this.validateEnumProperty(type, dataSource, key, ImportSlip.UnmatchedColumnsMode.class, false, concerns);
                    continue block27;
                }
                case "field-encapsulator": {
                    this.validateProperty(type, dataSource, key, String.class, false, concerns);
                    if (dataSource.getString("field-encapsulator").length() == 1) continue block27;
                    concerns.add(new Concern(type, "field-encapsulator", Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_FIELD_ENCAPSULATOR, "field-encapsulator")));
                    continue block27;
                }
                case "iso-character-set-encoding": {
                    this.validateProperty(type, dataSource, key, String.class, false, concerns);
                    String charsetName = dataSource.getString("iso-character-set-encoding");
                    try {
                        Charset.forName(charsetName);
                    }
                    catch (Exception e) {
                        concerns.add(new Concern(type, "iso-character-set-encoding", Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_ISO_CHARACTER_SET_ENCODING, "iso-character-set-encoding", Charset.availableCharsets().keySet().stream().collect(Collectors.joining(",")))));
                    }
                    continue block27;
                }
                case "datasets": {
                    continue block27;
                }
                case "status": 
                case "statusCode": {
                    continue block27;
                }
            }
            this.handleRemainingProperty(type, key, concerns);
        }
        if (dataSource.containsKey((Object)"datasets") && this.validateArrayProperty(type, dataSource, "datasets", IONObject.class, false, true, null, concerns)) {
            IONArray datasets = dataSource.getIONArray("datasets");
            HashSet<Object> usedDatasetLocatorValues = new HashSet<Object>();
            for (int i = 0; i < datasets.size(); ++i) {
                this.validateDataset(datasets.getIONObject(i), usedDatasetLocatorValues, concerns);
            }
        }
    }

    private void validateDataSourceUnset(IONObject datasource, List<Concern> concerns) {
        String type = "data-source";
        for (Map.Entry entry : datasource.entrySet()) {
            if (((String)entry.getKey()).equals("datasets")) {
                Object datasets = entry.getValue();
                if (datasets instanceof IONArray) {
                    this.validateArrayProperty(type, datasource, (String)entry.getKey(), IONObject.class, false, true, null, concerns);
                    IONArray array = (IONArray)datasets;
                    HashSet<Object> usedDatasetLocatorValues = new HashSet<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        this.validateDatasetUnset(array.getIONObject(i), usedDatasetLocatorValues, concerns);
                    }
                    continue;
                }
                this.validateProperty(type, datasource, (String)entry.getKey(), Boolean.class, false, concerns);
                continue;
            }
            this.validateProperty(type, datasource, (String)entry.getKey(), Boolean.class, false, concerns);
        }
    }

    private void validateDataset(IONObject dataset, Set<Object> usedDatasetLocatorValues, List<Concern> concerns) {
        String type = "dataset";
        this.validateCommonProperties(type, dataset, concerns);
        this.validateLocatorProperties(dataset, type, usedDatasetLocatorValues, concerns);
        Iterator iterator = dataset.keySet().iterator();
        block12: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "header-row-index": {
                    this.validateIntegerProperty(type, dataset, key, false, new Long(0L), concerns);
                    continue block12;
                }
                case "groupings": {
                    this.validateGrouping(dataset, concerns);
                    continue block12;
                }
                case "data-items": {
                    continue block12;
                }
                case "related-artifacts": {
                    continue block12;
                }
            }
            this.handleRemainingProperty(type, key, concerns);
        }
        if (dataset.containsKey((Object)"data-items") && this.validateArrayProperty(type, dataset, "data-items", IONObject.class, false, true, null, concerns)) {
            IONArray dataItems = dataset.getIONArray("data-items");
            HashSet<Object> usedDataItemLocatorValues = new HashSet<Object>();
            for (int i = 0; i < dataItems.size(); ++i) {
                this.validateDataItem(dataItems.getIONObject(i), usedDataItemLocatorValues, concerns);
            }
        }
    }

    private void validateDatasetUnset(IONObject dataset, Set<Object> usedDatasetLocatorValues, List<Concern> concerns) {
        String type = "dataset";
        this.validateLocatorProperties(dataset, "dataset", usedDatasetLocatorValues, concerns);
        for (Map.Entry entry : dataset.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("index") || key.equals("id")) continue;
            if (key.equals("data-items")) {
                Object datasets = entry.getValue();
                if (datasets instanceof IONArray) {
                    this.validateArrayProperty(type, dataset, key, IONObject.class, false, true, null, concerns);
                    IONArray array = (IONArray)datasets;
                    HashSet<Object> usedDataItemLocatorValues = new HashSet<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        this.validateDataItemUnset(array.getIONObject(i), usedDataItemLocatorValues, concerns);
                    }
                    continue;
                }
                this.validateProperty(type, dataset, key, Boolean.class, false, concerns);
                continue;
            }
            this.validateProperty(type, dataset, key, Boolean.class, false, concerns);
        }
    }

    private void validateDataItem(IONObject dataItem, Set<Object> usedDataItemLocatorValues, List<Concern> concerns) {
        String type = "data-item";
        this.validateCommonProperties(type, dataItem, concerns);
        this.validateLocatorProperties(dataItem, type, usedDataItemLocatorValues, concerns);
        Iterator iterator = dataItem.keySet().iterator();
        block26: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "data-type": {
                    this.validateEnumProperty(type, dataItem, key, ImportSlip.ISDataType.class, false, concerns);
                    continue block26;
                }
                case "replaces": {
                    this.validateProperty(type, dataItem, key, String.class, false, concerns);
                    continue block26;
                }
                case "max-string-length": {
                    this.validateIntegerProperty(type, dataItem, key, false, 0L, concerns);
                    continue block26;
                }
                case "aggregate": {
                    this.validateEnumProperty(type, dataItem, key, EAggregateType.class, false, concerns);
                    continue block26;
                }
                case "label": {
                    this.validateProperty(type, dataItem, key, String.class, false, concerns);
                    continue block26;
                }
                case "deploy-as-local-tz": {
                    this.validateProperty(type, dataItem, key, Boolean.class, false, concerns);
                    continue block26;
                }
                case "derived-from": {
                    this.validateProperty(type, dataItem, key, String.class, false, concerns);
                    continue block26;
                }
                case "enable-data-groups": {
                    this.validateProperty(type, dataItem, key, Boolean.class, false, concerns);
                    continue block26;
                }
                case "expand-to-seconds": {
                    this.validateProperty(type, dataItem, key, Boolean.class, false, concerns);
                    continue block26;
                }
                case "values-indexable": {
                    this.validateProperty(type, dataItem, key, Boolean.class, false, concerns);
                    continue block26;
                }
                case "visible": {
                    this.validateProperty(type, dataItem, key, Boolean.class, false, concerns);
                    continue block26;
                }
            }
            this.handleRemainingProperty(type, key, concerns);
        }
    }

    private void validateDataItemUnset(IONObject dataItem, Set<Object> usedDataItemLocatorValues, List<Concern> concerns) {
        String type = "data-item";
        this.validateLocatorProperties(dataItem, type, usedDataItemLocatorValues, concerns);
        for (Map.Entry entry : dataItem.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("index") || key.equals("id")) continue;
            this.validateProperty(type, dataItem, (String)entry.getKey(), Boolean.class, false, concerns);
        }
    }

    private void handleRemainingProperty(String type, String key, List<Concern> concerns) {
        if (!ImportSlip.COMMON_PROPERTIES.contains(key)) {
            concerns.add(new Concern(type, key, Concern.Reason.invalid, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_UNSUPPORTED_PROPERTY, key)));
        }
    }

    private void validateCommonProperties(String parentType, IONObject object, List<Concern> concerns) {
        this.validateProperty(parentType, object, "name", String.class, false, concerns);
        this.validateProperty(parentType, object, "custom-properties", IONObject.class, false, concerns);
    }

    void validateLocatorProperties(IONObject childEntry, String entryType, Set<Object> usedLocatorValues, List<Concern> concerns) {
        boolean foundValidator = false;
        if (childEntry.containsKey((Object)"index")) {
            if (this.isDuplicateLocator(childEntry, entryType, "index", usedLocatorValues, concerns)) {
                return;
            }
            this.validateIntegerProperty(entryType, childEntry, "index", true, new Long(0L), concerns);
            foundValidator = true;
        }
        if (childEntry.containsKey((Object)"id")) {
            if (this.isDuplicateLocator(childEntry, entryType, "id", usedLocatorValues, concerns)) {
                return;
            }
            this.validateProperty(entryType, childEntry, "id", String.class, true, concerns);
            foundValidator = true;
        }
        if (!foundValidator) {
            concerns.add(new Concern(entryType, "index", Concern.Reason.missing, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_INDEX, "index", "id")));
        }
    }

    private boolean isDuplicateLocator(IONObject childEntry, String entryType, String locatorKey, Set<Object> usedLocatorValues, List<Concern> concerns) {
        Object locatorValue = childEntry.get((Object)locatorKey);
        if (usedLocatorValues.contains(locatorValue)) {
            concerns.add(new Concern(entryType, locatorKey, Concern.Reason.invalid, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_DUPLICATE_LOCATOR, entryType, locatorKey, locatorValue.toString())));
            return true;
        }
        usedLocatorValues.add(locatorValue);
        return false;
    }

    private <T> void validateProperty(String parentType, IONObject object, String key, Class<T> expectedType, boolean isRequired, List<Concern> concerns) {
        if (object.containsKey((Object)key)) {
            Object value = object.get((Object)key);
            if (!expectedType.isAssignableFrom(value.getClass())) {
                concerns.add(new Concern(parentType, key, Concern.Reason.wrongType, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_WRONG_TYPE, key, expectedType.getName().toLowerCase())));
            }
        } else if (isRequired) {
            concerns.add(new Concern(parentType, key, Concern.Reason.missing, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_MISSING, key)));
        }
    }

    private <T> void validateIntegerProperty(String parentType, IONObject object, String key, boolean isRequired, long minValue, List<Concern> concerns) {
        if (object.containsKey((Object)key)) {
            Object value = object.get((Object)key);
            this.isValidInteger(parentType, key, value, minValue, concerns);
        } else if (isRequired) {
            concerns.add(new Concern(parentType, key, Concern.Reason.missing, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_MISSING, key)));
        }
    }

    private boolean isValidInteger(String parentType, String key, Object value, long minValue, List<Concern> concerns) {
        boolean checkMinValue = Long.MIN_VALUE != minValue;
        Concern.Reason reason = Concern.Reason.badValue;
        if (Number.class.isAssignableFrom(value.getClass())) {
            Number numericValue = (Number)value;
            double doubleValue = numericValue.doubleValue();
            if (doubleValue == Math.floor(doubleValue) && (!checkMinValue || doubleValue >= (double)minValue)) {
                return true;
            }
        } else {
            reason = Concern.Reason.wrongType;
        }
        String greaterThanClause = checkMinValue ? "" : NeoMessageUtil.getMessage(NeoMessageKeys.NEOIMPORTAPI_CONC_GREATER_OR_EQUAL) + minValue;
        String concernMessage = NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_WHOLE_NUMBER, key, greaterThanClause);
        concerns.add(new Concern(parentType, key, reason, concernMessage));
        return false;
    }

    private <E extends Enum<E>> void validateEnumProperty(String parentType, IONObject object, String key, Class<E> expectedEnum, boolean isRequired, List<Concern> concerns) {
        if (object.containsKey((Object)key)) {
            String value = object.get((Object)key).toString();
            try {
                this.validateEnumValue(expectedEnum, value);
            }
            catch (IllegalArgumentException e) {
                concerns.add(new Concern(parentType, key, Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_BAD_VALUE, key, this.getValidEnumValues(expectedEnum).stream().collect(Collectors.joining(",")))));
            }
        } else if (isRequired) {
            concerns.add(new Concern(parentType, key, Concern.Reason.missing, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_MISSING, key)));
        }
    }

    private <E extends Enum<E>> void validateEnumValue(Class<E> expectedEnumType, String value) {
        Set<String> expectedValues = this.getValidEnumValues(expectedEnumType);
        if (!expectedValues.contains(value)) {
            throw new IllegalArgumentException(NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_ERR_EXPECTED_VALUE, value, expectedValues.stream().collect(Collectors.joining(","))));
        }
    }

    private <E extends Enum<E>> Set<String> getValidEnumValues(Class<E> expectedEnumType) {
        TreeSet<String> values = new TreeSet<String>();
        for (Enum enumValue : EnumSet.allOf(expectedEnumType)) {
            String externalValue = null;
            externalValue = ImportSlip.ISDataType.class.isAssignableFrom(expectedEnumType) ? ((ImportSlip.ISDataType)enumValue).name().toLowerCase() : (EAggregateType.class.isAssignableFrom(expectedEnumType) ? ((EAggregateType)enumValue).toString() : enumValue.name());
            values.add(externalValue);
        }
        return values;
    }

    private <T> boolean validateArrayProperty(String parentType, IONObject object, String key, Class<T> expectedElementType, boolean isRequired, boolean canBeEmpty, Comparable<T> minValue, List<Concern> concerns) {
        if (object.containsKey((Object)key)) {
            IONArray array = null;
            try {
                array = object.getIONArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (array == null) {
                concerns.add(new Concern(parentType, key, Concern.Reason.wrongType, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_WRONG_TYPE_ARR, key)));
                return false;
            }
            if (array.isEmpty() && !canBeEmpty) {
                concerns.add(new Concern(parentType, key, Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_NOT_EMPTY, key)));
                return false;
            }
            for (Object element : array) {
                Object elem;
                if (expectedElementType.equals(Long.class)) {
                    this.isValidInteger(parentType, key, element, minValue == null ? Long.MIN_VALUE : (Long)minValue, concerns);
                    continue;
                }
                if (!expectedElementType.isAssignableFrom(element.getClass())) {
                    concerns.add(new Concern(parentType, key, Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_INCORRECT_NUM_OF_VAL, key, expectedElementType.getName().toLowerCase())));
                    return false;
                }
                if (minValue == null || minValue.compareTo(elem = element) < 1) continue;
                concerns.add(new Concern(parentType, key, Concern.Reason.badValue, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_INCORRECT_GREATER_EQUAL, key, minValue.toString())));
                return false;
            }
        } else if (isRequired) {
            concerns.add(new Concern(parentType, key, Concern.Reason.missing, NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_CONC_PROPERTY_MISSING, key)));
            return false;
        }
        return true;
    }

    private void validateGrouping(IONObject datasetION, List<Concern> concerns) {
        String type = "dataset";
        String key = "groupings";
        if (datasetION.containsKey((Object)key)) {
            this.validateArrayProperty(type, datasetION, key, IONObject.class, false, false, null, concerns);
            IONArray groupings = datasetION.getIONArray(key);
            for (int i = 0; i < groupings.size(); ++i) {
                IONObject grouping = groupings.getIONObject(i);
                this.validateIntegerProperty("grouping", grouping, "order", true, 0L, concerns);
                this.validateArrayProperty("grouping", grouping, "key", String.class, true, false, null, concerns);
                this.validateArrayProperty("grouping", grouping, "attributes", String.class, true, false, null, concerns);
            }
        }
    }

    public static class Concern {
        private final String elementType;
        private final String name;
        private final Reason reason;
        private final String message;

        public Concern(String elementType, String name, Reason reason, String message) {
            this.elementType = elementType;
            this.name = name;
            this.reason = reason;
            this.message = message;
        }

        public String getElementType() {
            return this.elementType;
        }

        public String getName() {
            return this.name;
        }

        public Reason getReason() {
            return this.reason;
        }

        public String getMessage() {
            return String.format("[%s]:%s", this.elementType, this.message);
        }

        public String toString() {
            return String.format("{[%s][%s][%s]:%s}", this.elementType, this.name, this.reason.toString(), this.message);
        }

        public IONObject toION() {
            return new IONObjectBuilder().put("element-type", (Object)this.getElementType()).put("property", (Object)this.getName()).put("reason", (Object)this.getReason().name()).put("message", (Object)this.message).toDocument();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Concern)) {
                return false;
            }
            Concern rhs = (Concern)other;
            return new EqualsBuilder().append((Object)this.elementType, (Object)rhs.elementType).append((Object)this.name, (Object)rhs.name).append((Object)this.reason, (Object)rhs.reason).isEquals();
        }

        public static enum Reason {
            missing,
            invalid,
            wrongType,
            badValue;

        }
    }
}

