/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.api;

import com.ibm.cognos.aurora.api.model.EAggregateType;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.ImportSlipValidator;
import com.ibm.neo.dataimport.api.ImportSlipWriterException;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.Grouping;
import com.ibm.neo.messages.NeoMessageUtil;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ImportSlipWriter {
    public static final String TYPE_DATA_ITEM = "data-item";
    public static final String TYPE_DATASET = "dataset";
    public static final String TYPE_DATASOURCE = "data-source";
    private IONObject slip;
    private ISDataSource currentDataSource;
    private ISDataset currentDataset;
    private ISDataItem currentDataItem;

    public ImportSlipWriter() {
        this(new IONObject());
    }

    public ImportSlipWriter(IONObject init) {
        this.slip = init == null ? new IONObject() : init.duplicate();
        this.currentDataSource = new ISDataSource(this.slip);
    }

    public IONObject build() throws WAImportException {
        this.currentDataSource.cleanChildEntries();
        List<ImportSlipValidator.Concern> concerns = new ImportSlipValidator().validateSlip(this.slip);
        ImportSlipValidator.throwExceptionIfConcerned(concerns);
        return this.currentDataSource.source.duplicate();
    }

    public ISDataSource selectDataSource() {
        return this.currentDataSource;
    }

    public ImportSlipWriter merge(IONObject merge) throws WAImportException {
        if (merge != null) {
            this.currentDataSource.merge(merge);
        }
        return this;
    }

    public ImportSlipWriter unset(IONObject unset) throws WAImportException {
        if (unset != null) {
            this.currentDataSource.unset(unset);
        }
        return this;
    }

    public class ISDataItem
    extends ISElement<ISDataItem> {
        private ISDataItem(IONObject source) {
            super(source);
        }

        @Override
        String getChildrenFieldName() {
            return null;
        }

        @Override
        String getTypeName() {
            return ImportSlipWriter.TYPE_DATA_ITEM;
        }

        public ISDataItem setDataType(ImportSlip.ISDataType type) {
            return (ISDataItem)this.put("data-type", type.name().toLowerCase());
        }

        @Deprecated
        public ISDataItem setDataType(EDataType type) {
            ImportSlip.ISDataType isDataType = ImportSlip.ISDataType.STRING;
            switch (type) {
                case BOOLEAN: {
                    isDataType = ImportSlip.ISDataType.BOOLEAN;
                    break;
                }
                case STRING: 
                case CHAR: {
                    isDataType = ImportSlip.ISDataType.STRING;
                    break;
                }
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: {
                    isDataType = ImportSlip.ISDataType.INTEGER;
                    break;
                }
                case FLOAT32: 
                case FLOAT64: 
                case DECIMAL64: {
                    isDataType = ImportSlip.ISDataType.NUMBER;
                    break;
                }
                case DATE: {
                    isDataType = ImportSlip.ISDataType.DATE;
                    break;
                }
                case TIME: {
                    isDataType = ImportSlip.ISDataType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    isDataType = ImportSlip.ISDataType.TIMESTAMP;
                    break;
                }
            }
            return this.setDataType(isDataType);
        }

        public ISDataItem unsetDataType() {
            return (ISDataItem)this.remove("data-type");
        }

        public ISDataItem setReplaces(String id) {
            return (ISDataItem)this.put("replaces", id);
        }

        public ISDataItem unsetReplaces() {
            return (ISDataItem)this.remove("replaces");
        }

        public ISDataItem setMaxStringLength(int maxStringLength) {
            return (ISDataItem)this.put("max-string-length", maxStringLength);
        }

        public ISDataItem unsetMaxStringLength() {
            return (ISDataItem)this.remove("max-string-length");
        }

        public ISDataItem setAggregate(EAggregateType type) {
            return (ISDataItem)this.put("aggregate", type.toString());
        }

        public ISDataItem unsetAggregate() {
            return (ISDataItem)this.remove("aggregate");
        }

        public ISDataItem setDeployAsLocalTimezone(boolean flag) {
            return (ISDataItem)this.put("deploy-as-local-tz", flag);
        }

        public ISDataItem unsetDeployAsLocalTimezone() {
            return (ISDataItem)this.remove("deploy-as-local-tz");
        }

        public ISDataItem setDerivedFrom(String derivedFrom) {
            return (ISDataItem)this.put("derived-from", derivedFrom);
        }

        public ISDataItem unsetDerivedFrom() {
            return (ISDataItem)this.remove("derived-from");
        }

        public ISDataItem setEnableDataGroups(boolean flag) {
            return (ISDataItem)this.put("enable-data-groups", flag);
        }

        public ISDataItem unsetEnableDataGroups() {
            return (ISDataItem)this.remove("enable-data-groups");
        }

        public ISDataItem setExpandToSeconds(boolean flag) {
            return (ISDataItem)this.put("expand-to-seconds", flag);
        }

        public ISDataItem unsetExpandToSeconds() {
            return (ISDataItem)this.remove("expand-to-seconds");
        }

        public ISDataItem setValuesIndexable(boolean flag) {
            return (ISDataItem)this.put("values-indexable", flag);
        }

        public ISDataItem unsetValuesIndexable() {
            return (ISDataItem)this.remove("values-indexable");
        }

        public ISDataItem setVisible(boolean flag) {
            return (ISDataItem)this.put("visible", flag);
        }

        public ISDataItem unsetVisible() {
            return (ISDataItem)this.remove("visible");
        }

        @Override
        ISElement<?> makeChild(IONObject childSource) {
            return null;
        }

        public ISDataItem setLabel(String label) {
            return (ISDataItem)this.put("label", label);
        }

        public ISDataItem unsetLabel() {
            return (ISDataItem)this.remove("label");
        }
    }

    public class ISDataset
    extends ISElement<ISDataset> {
        private ISDataset(IONObject source) {
            super(source);
        }

        public ISDataItem selectDataItem(int index) throws ImportSlipWriterException {
            ImportSlipWriter.this.currentDataItem = new ISDataItem(this.currentDataset().findChildWithIndex(index, true));
            return ImportSlipWriter.this.currentDataItem;
        }

        public ISDataItem selectDataItem(String id) throws ImportSlipWriterException {
            ImportSlipWriter.this.currentDataItem = new ISDataItem(this.currentDataset().findChildWithId(id, true));
            return ImportSlipWriter.this.currentDataItem;
        }

        public ISDataItem selectDataItem(int index, String id) throws ImportSlipWriterException {
            ImportSlipWriter.this.currentDataItem = new ISDataItem(this.currentDataset().findChildWithIndexOrId(index, id, true));
            return ImportSlipWriter.this.currentDataItem;
        }

        public ISDataset setHeaderRowIndex(long index) {
            return (ISDataset)this.put("header-row-index", index);
        }

        public ISDataset unsetHeaderRowIndex() {
            return (ISDataset)this.remove("header-row-index");
        }

        public ISDataset setGroupings(List<Grouping> groupings) {
            IONArray array = new IONArray();
            for (Grouping grouping : groupings) {
                IONObject o = new IONObject();
                grouping.encodeION(o);
                array.add((Object)o);
            }
            return (ISDataset)this.put("groupings", array);
        }

        public ISDataset unsetGroupings() {
            return (ISDataset)this.remove("groupings");
        }

        public ISDataset setRelatedArtifacts(IONObject artifacts) {
            return (ISDataset)this.put("related-artifacts", artifacts);
        }

        public ISDataset unsetRelatedArtifacts() {
            return (ISDataset)this.remove("related-artifacts");
        }

        @Override
        protected String getChildrenFieldName() {
            return "data-items";
        }

        @Override
        String getTypeName() {
            return ImportSlipWriter.TYPE_DATASET;
        }

        ISDataItem makeChild(IONObject childSource) {
            return new ISDataItem(childSource);
        }
    }

    public class ISDataSource
    extends ISElement<ISDataSource> {
        private ISDataSource(IONObject source) {
            super(source);
        }

        @Override
        String getChildrenFieldName() {
            return "datasets";
        }

        @Override
        String getTypeName() {
            return ImportSlipWriter.TYPE_DATASOURCE;
        }

        public ISDataset selectDataSet(int index) {
            ImportSlipWriter.this.currentDataset = new ISDataset(ImportSlipWriter.this.currentDataSource.findChildWithIndex(index, true));
            return ImportSlipWriter.this.currentDataset;
        }

        public ISDataset selectDataSet(String id) {
            ImportSlipWriter.this.currentDataset = new ISDataset(ImportSlipWriter.this.currentDataSource.findChildWithId(id, true));
            return ImportSlipWriter.this.currentDataset;
        }

        public ISDataset selectDataSet(int index, String id) throws ImportSlipWriterException {
            ImportSlipWriter.this.currentDataset = new ISDataset(ImportSlipWriter.this.currentDataSource.findChildWithIndexOrId(index, id, true));
            return ImportSlipWriter.this.currentDataset;
        }

        public ISDataSource setVersion(int version) {
            return (ISDataSource)this.put("slip-version", version);
        }

        public ISDataSource unsetVersion() {
            return (ISDataSource)this.remove("slip-version");
        }

        public ISDataSource setAppendData(boolean append) {
            return (ISDataSource)this.put("append-data", append);
        }

        public ISDataSource unsetAppendData() {
            return (ISDataSource)this.remove("append-data");
        }

        public ISDataSource setFieldEncapsulator(String encapsulator) {
            return (ISDataSource)this.put("field-encapsulator", encapsulator);
        }

        public ISDataSource unsetFieldEncapsulator() {
            return (ISDataSource)this.remove("field-encapsulator");
        }

        public ISDataSource setCharacterSetEncoding(String charset) {
            return (ISDataSource)this.put("iso-character-set-encoding", charset);
        }

        public ISDataSource unsetCharacterSetEncoding() {
            return (ISDataSource)this.remove("iso-character-set-encoding");
        }

        public ISDataSource setAnalyticsLocale(Locale locale) {
            return (ISDataSource)this.put("analytics-locale", locale.toLanguageTag());
        }

        public ISDataSource unsetAnalyticsLocale() {
            return (ISDataSource)this.remove("analytics-locale");
        }

        public ISDataSource setSelectedSections(List<Integer> sections) {
            return (ISDataSource)this.put("sections", new IONArray(sections));
        }

        public ISDataSource unsetSelectedSections() {
            return (ISDataSource)this.remove("sections");
        }

        public ISDataSource setUnmatchedColumnsMode(ImportSlip.UnmatchedColumnsMode mode) {
            return (ISDataSource)this.put("unmatched-columns", mode.name());
        }

        public ISDataSource unsetUnmatchedColumnsMode() {
            return (ISDataSource)this.remove("unmatched-columns");
        }

        ISDataset makeChild(IONObject childSource) {
            return new ISDataset(childSource);
        }
    }

    public abstract class ISElement<T extends ISElement<?>> {
        IONObject source;

        private ISElement(IONObject source) {
            this.source = source;
        }

        public ImportSlipWriter writer() {
            return ImportSlipWriter.this;
        }

        public ISDataSource currentDataSource() {
            return ImportSlipWriter.this.currentDataSource;
        }

        public ISDataset currentDataset() {
            if (ImportSlipWriter.this.currentDataset == null) {
                throw new ImportSlipWriterException(NeoImportError.NEOIMPORTAPI_ERR_SELECT_DATASET);
            }
            return ImportSlipWriter.this.currentDataset;
        }

        public ISDataItem currentDataItem() {
            if (ImportSlipWriter.this.currentDataItem == null) {
                throw new ImportSlipWriterException(NeoImportError.NEOIMPORTAPI_ERR_SELECT_DATAITEM);
            }
            return ImportSlipWriter.this.currentDataItem;
        }

        @Deprecated
        public T put(String key, Object value) {
            this.source.put((Object)key, value);
            return (T)this;
        }

        @Deprecated
        public T remove(String key) {
            this.source.remove((Object)key);
            return (T)this;
        }

        public T setName(String name) {
            return this.put("name", name);
        }

        public T unsetName() {
            return this.remove("name");
        }

        public T setIndex(int index) {
            return this.put("index", index);
        }

        public T unsetIndex() {
            return this.remove("index");
        }

        public T setId(String id) {
            return this.put("id", id);
        }

        public T unsetId() {
            return this.remove("id");
        }

        public T setCustomProperty(String key, Object value) {
            IONObject customProps = this.source.getIONObject("custom-properties");
            if (customProps == null) {
                customProps = new IONObject();
                this.source.put((Object)"custom-properties", (Object)customProps);
            }
            customProps.put((Object)key, value);
            return (T)this;
        }

        public T unsetCustomProperty(String key) {
            IONObject customProps = this.source.getIONObject("custom-properties");
            if (customProps != null) {
                customProps.remove((Object)key);
                if (customProps.isEmpty()) {
                    this.source.remove((Object)"custom-properties");
                }
            }
            return (T)this;
        }

        public T setCustomProperties(IONObject properties) {
            return this.put("custom-properties", properties);
        }

        public T unsetCustomProperties() {
            return this.remove("custom-properties");
        }

        abstract String getChildrenFieldName();

        abstract String getTypeName();

        private IONArray listChildren(boolean createIfMissing) {
            String field = this.getChildrenFieldName();
            if (field == null) {
                return null;
            }
            if (!this.source.containsKey((Object)field) && createIfMissing) {
                this.source.put((Object)field, (Object)new IONArray());
            }
            return this.source.getIONArray(field);
        }

        IONObject findChildWithIndex(int index, boolean createIfMissing) {
            IONArray children = this.listChildren(createIfMissing);
            if (children == null) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                IONObject child = children.getIONObject(i);
                if (child.getInt("index", -1) != index) continue;
                return child;
            }
            if (createIfMissing) {
                children.add((Object)this.makeChild(index));
                return children.getIONObject(children.size() - 1);
            }
            return null;
        }

        IONObject findChildWithId(String id, boolean createIfMissing) {
            IONArray children = this.listChildren(createIfMissing);
            if (children == null) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                IONObject child = children.getIONObject(i);
                if (!id.equals(child.getString("id", null))) continue;
                return child;
            }
            if (createIfMissing) {
                children.add((Object)this.makeChild(id));
                return children.getIONObject(children.size() - 1);
            }
            return null;
        }

        IONObject findChildWithIndexOrId(int index, String id, boolean createIfMissing) throws ImportSlipWriterException {
            IONArray children = this.listChildren(createIfMissing);
            if (children == null) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                IONObject child = children.getIONObject(i);
                if (child.getInt("index", -1) == index) {
                    this.completeLocatorPair(child, index, id);
                    return child;
                }
                if (!id.equals(child.getString("id"))) continue;
                this.completeLocatorPair(child, index, id);
                return child;
            }
            if (createIfMissing) {
                IONObject newChildION = this.makeChild(index);
                newChildION.put((Object)"id", (Object)id);
                children.add((Object)newChildION);
                return children.getIONObject(children.size() - 1);
            }
            return null;
        }

        void completeLocatorPair(IONObject entry, int index, String id) throws ImportSlipWriterException {
            if (index != entry.getInt("index", index)) {
                throw new ImportSlipWriterException(NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_INDEX_EXISTS, String.valueOf(entry.getInt("index")), String.valueOf(entry.toString())));
            }
            entry.put((Object)"index", (Object)index);
            if (!id.equals(entry.getString("id", id))) {
                throw new ImportSlipWriterException(NeoMessageUtil.getMessage(NeoImportError.NEOIMPORTAPI_PROP_INDEX_EXISTS, entry.getString("id"), entry.toString()));
            }
            entry.put((Object)"id", (Object)id);
        }

        IONObject findChildWithLocator(IONObject locator, boolean createIfMissing) {
            if (locator.containsKey((Object)"index")) {
                return this.findChildWithIndex(locator.getInt("index"), createIfMissing);
            }
            if (locator.containsKey((Object)"id")) {
                return this.findChildWithId(locator.getString("id"), createIfMissing);
            }
            return null;
        }

        void merge(IONObject merge) throws WAImportException {
            String childrenFieldName = this.getChildrenFieldName();
            for (Map.Entry entry : merge.entrySet()) {
                if (((String)entry.getKey()).equals(childrenFieldName)) continue;
                this.put((String)entry.getKey(), entry.getValue());
            }
            if (childrenFieldName != null && merge.containsKey((Object)childrenFieldName)) {
                IONArray childrenInMerge = merge.getIONArray(childrenFieldName);
                HashSet<Object> usedLocatorValues = new HashSet<Object>();
                for (int i = 0; i < childrenInMerge.size(); ++i) {
                    IONObject childMergeION = childrenInMerge.getIONObject(i);
                    this.validateLocator(childMergeION, usedLocatorValues);
                    IONObject childION = this.findChildWithLocator(childMergeION, true);
                    ISElement<?> child = this.makeChild(childION);
                    child.merge(childMergeION);
                }
            }
        }

        private void validateLocator(IONObject locator, Set<Object> usedLocatorValues) throws WAImportException {
            ArrayList<ImportSlipValidator.Concern> locatorConcerns = new ArrayList<ImportSlipValidator.Concern>();
            new ImportSlipValidator().validateLocatorProperties(locator, this.getTypeName(), usedLocatorValues, locatorConcerns);
            ImportSlipValidator.throwExceptionIfConcerned(locatorConcerns);
        }

        void unset(IONObject unset) {
            String childrenFieldName = this.getChildrenFieldName();
            for (Map.Entry entry : unset.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals(childrenFieldName) || key.equals("index") || key.equals("id")) continue;
                this.evaluateUnset(key, entry.getValue());
            }
            if (childrenFieldName != null && unset.containsKey((Object)childrenFieldName)) {
                Object entry = unset.get((Object)childrenFieldName);
                if (entry instanceof IONArray) {
                    if (this.listChildren(false) == null) {
                        return;
                    }
                    IONArray childUnsetEntries = (IONArray)entry;
                    for (int i = 0; i < childUnsetEntries.size(); ++i) {
                        IONObject childUnset = null;
                        try {
                            childUnset = childUnsetEntries.getIONObject(i);
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        IONObject childToClean = this.findChildWithLocator(childUnset, false);
                        if (childToClean == null) continue;
                        this.makeChild(childToClean).unset(childUnset);
                    }
                } else {
                    this.evaluateUnset(childrenFieldName, entry);
                }
            }
        }

        void evaluateUnset(String key, Object value) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                this.remove(key);
            }
        }

        private IONObject makeChild(int index) {
            return new IONObjectBuilder().put("index", (Object)index).toDocument();
        }

        private IONObject makeChild(String id) {
            return new IONObjectBuilder().put("id", (Object)id).toDocument();
        }

        abstract ISElement<?> makeChild(IONObject var1);

        void cleanChildEntries() {
            String childrenField = this.getChildrenFieldName();
            if (childrenField != null && this.source.containsKey((Object)childrenField)) {
                IONArray children = this.source.getIONArray(childrenField);
                for (int i = 0; i < children.size(); ++i) {
                    ISElement<?> childElem = this.makeChild(children.getIONObject(i));
                    childElem.cleanChildEntries();
                    if (!this.childContainsOnlyLocator(childElem.source)) continue;
                    children.remove(i);
                }
                if (children.isEmpty()) {
                    this.source.remove((Object)childrenField);
                }
            }
        }

        private boolean childContainsOnlyLocator(IONObject childSource) {
            if (childSource.isEmpty()) {
                return true;
            }
            int locatorCount = childSource.containsKey((Object)"index") ? 1 : 0;
            locatorCount = childSource.containsKey((Object)"id") ? locatorCount + 1 : locatorCount;
            return locatorCount == childSource.size();
        }
    }
}

