/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.api;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.exception.WatsonException;
import com.ibm.neo.exception.WatsonMessageContext;
import com.ibm.neo.messages.NeoMessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WAImportException
extends WatsonException {
    private static final long serialVersionUID = 1L;
    private IMessageKey mMessageKey;
    private Object[] mMessageArgs;

    public WAImportException(String _message, Throwable _cause, WatsonMessageContext _messageContext) {
        super(_message, _cause, _messageContext);
    }

    public WAImportException(IMessageKey _message, Object[] _args, Throwable _cause, WatsonMessageContext _messageContext) {
        super(null, _cause, _messageContext);
        this.mMessageKey = _message;
        this.mMessageArgs = _args == null ? new Object[]{} : _args;
    }

    public String getMessage() {
        if (this.mMessageKey == null) {
            return super.getMessage();
        }
        return this.getLocalizedMessage(NeoMessageUtil.getCurrProductLocale());
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(NeoMessageUtil.getCurrProductLocale());
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.mMessageKey == null) {
            super.getLocalizedMessage();
        }
        return NeoMessageUtil.getLocalizedMessage(this.mMessageKey, locale, this.mMessageArgs);
    }

    public String getErrorCode() {
        if (this.mMessageKey == null) {
            return null;
        }
        return this.mMessageKey.getErrorCode();
    }

    public List<Object> getDetails() {
        if (this.mMessageArgs == null) {
            return new ArrayList<Object>();
        }
        return Arrays.asList(this.mMessageArgs);
    }

    public EImportMessageCode getCode() {
        if (this.getWatsonMessageContext() != null) {
            return (EImportMessageCode)this.getWatsonMessageContext().getConditionCode();
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String mMessage = null;
        private Throwable mCause = null;
        private IMessageKey mMessageKey = null;
        private Object[] mMessageArgs = new Object[0];
        private EImportMessageCode mCoditionCode = EImportMessageCode.INTERNAL_ERROR;
        private EnumMap<EImportMessageContext, Object> mContextAttributes = new EnumMap(EImportMessageContext.class);

        public Builder withMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public Builder withMessage(IMessageKey message) {
            this.mMessageKey = message;
            return this;
        }

        public Builder withMessage(IMessageKey message, Object ... args) {
            this.mMessageKey = message;
            this.mMessageArgs = args;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.mCause = cause;
            return this;
        }

        public Builder withConditionCode(EImportMessageCode conditionCode) {
            this.mCoditionCode = conditionCode;
            return this;
        }

        public Builder withContextAttribute(EImportMessageContext key, Object value) {
            this.mContextAttributes.put(key, value);
            return this;
        }

        public Builder withContextAttributeIfNotNull(EImportMessageContext key, Object value) {
            if (value != null) {
                this.mContextAttributes.put(key, value);
            }
            return this;
        }

        public WAImportException build() {
            WatsonMessageContext context = new WatsonMessageContext((Enum)this.mCoditionCode);
            for (Map.Entry<EImportMessageContext, Object> e : this.mContextAttributes.entrySet()) {
                context.putItem((Enum)e.getKey(), e.getValue());
            }
            if (this.mMessageKey != null) {
                return new WAImportException(this.mMessageKey, this.mMessageArgs, this.mCause, context);
            }
            return new WAImportException(this.mMessage, this.mCause, context);
        }
    }
}

