/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.api;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.exception.WatsonMessageContext;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONObjectId;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class WAStorageException
extends WAImportException {
    private static final long serialVersionUID = 1L;

    public WAStorageException() {
        super((IMessageKey)NeoImportError.NEOIMPORTAPI_ERR_INTERNAL_ERROR, null, null, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(String _message) {
        super(_message, null, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(Throwable _cause) {
        super((IMessageKey)NeoImportError.NEOIMPORTAPI_ERR_INTERNAL_ERROR, null, _cause, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(String _message, Throwable _cause) {
        super(_message, _cause, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(String _message, Throwable _cause, IONObjectId _databaseId) {
        super(_message, _cause, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR, _databaseId));
    }

    public WAStorageException(String _message, Throwable _cause, WatsonMessageContext _messageContext) {
        super(_message, _cause, _messageContext);
    }

    public WAStorageException(IMessageKey.Param0 _message, Throwable _cause, WatsonMessageContext _messageContext) {
        super((IMessageKey)_message, null, _cause, _messageContext);
    }

    public WAStorageException(IMessageKey.Param0 _message) {
        super((IMessageKey)_message, null, null, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(IMessageKey.Param0 _message, Throwable _cause) {
        super((IMessageKey)_message, null, _cause, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR));
    }

    public WAStorageException(IMessageKey.Param0 _message, Throwable _cause, IONObjectId _databaseId) {
        super((IMessageKey)_message, null, _cause, WAStorageException.createMessageContext(EImportMessageCode.INTERNAL_ERROR, _databaseId));
    }

    public IONObjectId getDatabaseId() {
        String databaseId = (String)this.getContextItem(EImportMessageContext.DATABASE_ID, String.class);
        if (StringUtils.isNotEmpty((String)databaseId)) {
            return new IONObjectId(databaseId);
        }
        return null;
    }

    private static WatsonMessageContext createMessageContext(EImportMessageCode messageCode) {
        return WAStorageException.createMessageContext(messageCode, null);
    }

    private static WatsonMessageContext createMessageContext(EImportMessageCode messageCode, IONObjectId databaseId) {
        WatsonMessageContext context = new WatsonMessageContext((Enum)messageCode);
        if (databaseId != null) {
            context.putItem((Enum)EImportMessageContext.DATABASE_ID, (Object)databaseId.getIdentifier());
        }
        return context;
    }

    public static class ResourceExhaustion
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public ResourceExhaustion() {
            super(NeoImportError.NEOIMPORTAPI_ERR_INSUFF_DB_RESOURCES, null);
        }

        public ResourceExhaustion(IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_INSUFF_DB_RESOURCES, null, databaseId);
        }

        public ResourceExhaustion(Throwable _cause) {
            super(NeoImportError.NEOIMPORTAPI_ERR_INSUFF_DB_RESOURCES, _cause);
        }

        public ResourceExhaustion(Throwable _cause, IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_INSUFF_DB_RESOURCES, _cause, databaseId);
        }
    }

    public static class BulkLoadError
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public BulkLoadError() {
            this((Throwable)null);
        }

        public BulkLoadError(Throwable cause) {
            super(NeoImportError.NEOIMPORTAPI_ERR_BULK_LOAD_FAIL, cause);
        }

        public BulkLoadError(Throwable cause, IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_BULK_LOAD_FAIL, cause, databaseId);
        }
    }

    public static class TableRowLengthExceeded
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public TableRowLengthExceeded() {
            super(NeoImportError.NEOIMPORTAPI_ERR_DS_TOO_WIDE, null);
        }

        public TableRowLengthExceeded(IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_DS_TOO_WIDE, null, databaseId);
        }
    }

    public static class NoDatabaseAvailable
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public NoDatabaseAvailable() {
            super(NeoImportError.NEOIMPORTAPI_ERR_NO_DB_AVAIL);
        }
    }

    public static class NoSuchObjectException
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public NoSuchObjectException(String message) {
            super(message);
        }

        public NoSuchObjectException(String message, IONObjectId databaseId) {
            super(message, null, databaseId);
        }

        public NoSuchObjectException(String message, Throwable cause, IONObjectId databaseId) {
            super(message, cause, databaseId);
        }
    }

    public static class DuplicateNameException
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public DuplicateNameException(String message) {
            super(message);
        }

        public DuplicateNameException(String message, Throwable cause) {
            super(message, cause);
        }

        public DuplicateNameException(String message, Throwable cause, IONObjectId databaseId) {
            super(message, cause, databaseId);
        }
    }

    public static class JDBCException
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public JDBCException(String message, SQLException cause) {
            super(message, (Throwable)cause);
        }

        public JDBCException(String message, SQLException cause, IONObjectId databaseId) {
            super(message, (Throwable)cause, databaseId);
        }
    }

    public static class ConnectionBorrowInterrupted
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public ConnectionBorrowInterrupted(Throwable cause) {
            super(NeoImportError.NEOIMPORTAPI_ERR_CONN_BORROW_INTERRUPTED, cause);
        }

        public ConnectionBorrowInterrupted(Throwable cause, IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_CONN_BORROW_INTERRUPTED, cause, databaseId);
        }
    }

    public static class ConnectionBorrowTimeout
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public ConnectionBorrowTimeout() {
            super(NeoImportError.NEOIMPORTAPI_ERR_CONN_BORROW_TIMEOUT, null);
        }

        public ConnectionBorrowTimeout(IONObjectId databaseId) {
            super(NeoImportError.NEOIMPORTAPI_ERR_CONN_BORROW_TIMEOUT, null, databaseId);
        }
    }

    public static class ConnectionFailure
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public ConnectionFailure(String message, Throwable cause) {
            super(message, cause);
        }

        public ConnectionFailure(String message, Throwable cause, IONObjectId databaseId) {
            super(message, cause, databaseId);
        }
    }

    public static class DriverLoadFailure
    extends WAStorageException {
        private static final long serialVersionUID = 1L;

        public DriverLoadFailure(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

