/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import com.ibm.neo.dataimport.nodel.storage.SQLDataType;

public class CallParameter {
    private final int mIndex;
    private final String mName;
    private final boolean mInput;
    private final boolean mOutput;
    private final SQLDataType mDataType;
    private Object mValue;

    public static CallParameter newInput(int index, Object value) {
        return new CallParameter(index, true, false, null, value);
    }

    public static CallParameter newInput(String name, Object value) {
        return new CallParameter(name, true, false, null, value);
    }

    public static CallParameter newOutput(int index, SQLDataType dataType) {
        return new CallParameter(index, false, true, dataType, null);
    }

    public static CallParameter newOutput(String name, SQLDataType dataType) {
        return new CallParameter(name, false, true, dataType, null);
    }

    public static CallParameter newInputOutput(int index, SQLDataType dataType, Object value) {
        return new CallParameter(index, true, true, dataType, value);
    }

    public static CallParameter newInputOutput(String name, SQLDataType dataType, Object value) {
        return new CallParameter(name, true, true, dataType, value);
    }

    protected CallParameter(String name, boolean isInput, boolean isOuput, SQLDataType dataType, Object value) {
        this.mName = name;
        this.mIndex = -1;
        this.mInput = isInput;
        this.mOutput = isOuput;
        this.mDataType = dataType;
        this.mValue = value;
    }

    protected CallParameter(int index, boolean isInput, boolean isOuput, SQLDataType dataType, Object value) {
        this.mIndex = index;
        this.mName = null;
        this.mInput = isInput;
        this.mOutput = isOuput;
        this.mDataType = dataType;
        this.mValue = value;
    }

    public boolean isInput() {
        return this.mInput;
    }

    public boolean isOutput() {
        return this.mOutput;
    }

    public String getName() {
        return this.mName;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public SQLDataType getDataType() {
        return this.mDataType;
    }

    public Object getValue() {
        return this.mValue;
    }

    public void setValue(Object value) {
        this.mValue = value;
    }
}

