/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DatabaseLimits
implements Cloneable {
    private int mMaxColumnNameLength = 128;
    private int mMaxColumnsInSelect = 500;
    private int mMaxColumnsInTable = 500;
    private int mMaxTableNameLength = 128;

    public int getMaxColumnNameLength() {
        return this.mMaxColumnNameLength;
    }

    public int getMaxColumnsInSelect() {
        return this.mMaxColumnsInSelect;
    }

    public int getMaxColumnsInTable() {
        return this.mMaxColumnsInTable;
    }

    public int getMaxTableNameLength() {
        return this.mMaxTableNameLength;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static final class Builder {
        private DatabaseLimits mLimits = new DatabaseLimits();

        public DatabaseLimits build() {
            try {
                return (DatabaseLimits)this.mLimits.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder withMaxColumnNameLength(int maxColumnNameLength) {
            this.mLimits.mMaxColumnNameLength = maxColumnNameLength;
            return this;
        }

        public Builder withMaxColumnsInSelect(int maxColumnsInSelect) {
            this.mLimits.mMaxColumnsInSelect = maxColumnsInSelect;
            return this;
        }

        public Builder withMaxColumnsInTable(int maxColumnsInTable) {
            this.mLimits.mMaxColumnsInTable = maxColumnsInTable;
            return this;
        }

        public Builder withMaxTableNameLength(int maxTableNameLength) {
            this.mLimits.mMaxTableNameLength = maxTableNameLength;
            return this;
        }
    }
}

