/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IRowWriter;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import com.ibm.neo.dataimport.storage.SQLExceptionHandler;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import com.ibm.neo.dataimport.storage.util.IdentifierUtil;
import com.ibm.neo.util.ops.AbstractOperation;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLoader
extends AbstractOperation
implements IBulkLoader {
    public static final String PROP_INSERT_BATCH_SIZE = "com.ibm.neo.dataimport.storage.insert-batch-size";
    private static final String DEFAULT_INSERT_BATCH_SIZE = "5000";
    private static final int PROGRESS_UPDATE_INTERVAL = 1000;
    private static final int INSERT_WORK_UNITS = 70;
    private static final int COMMIT_WORK_UNITS = 30;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JdbcLoader.class);
    protected final IDatabaseAccessor mAccessor;
    protected final SQLExceptionHandler mErrorHandler;
    protected final int mBatchSize;
    protected final Database mDb;
    protected final Table mTable;
    protected final Map<String, Object> mLogContext = new HashMap<String, Object>();
    protected IPooledConnection mConnection = null;
    protected PreparedStatement mPrepStmt = null;
    private long mRowCount = 0L;
    private long mRowsInserted = 0L;

    public JdbcLoader(IDatabaseAccessor accessor, Database db, Table table, Properties configuration, SQLExceptionHandler errorHandler) throws WAStorageException {
        this.mAccessor = accessor;
        this.mErrorHandler = errorHandler;
        this.mBatchSize = Integer.parseInt(configuration.getProperty(PROP_INSERT_BATCH_SIZE, DEFAULT_INSERT_BATCH_SIZE));
        if (db == null) {
            throw new NullArgumentException("db cannot be null.");
        }
        this.mDb = db;
        this.mTable = table;
        this.mLogContext.put("database", db.getJdbcUrl());
        this.mLogContext.put("schema", table.getSchemaName());
        this.mLogContext.put("table", table.getTableName());
        this.setTotalWork(100L);
    }

    @Override
    public void setRowCount(long rowCount) {
        this.mRowCount = rowCount;
    }

    @Override
    public void setAuditTags(Map<String, String> tags) {
        this.mLogContext.putAll(tags);
    }

    @Override
    public final void start(IStreamingRowWriter srw) throws WAStorageException {
        this.markAsStarted();
        try {
            this.prepareConnection();
            this.prepareStatement();
            if (this.isCanceled()) {
                throw new CancellationException();
            }
            try (RowWriter writer = new RowWriter();){
                srw.write(writer);
            }
            this.markAsFinished();
        }
        catch (WAStorageException ex) {
            this.markAsFailed(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.markAsFailed(ex);
            throw ex;
        }
        finally {
            if (null != this.mPrepStmt) {
                try {
                    this.mPrepStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("An error occured while closing PreparedStatement", (Throwable)ex);
                }
            }
            if (null != this.mConnection) {
                this.mConnection.returnToPool();
            }
        }
    }

    protected void cancelImpl() {
    }

    protected void prepareConnection() throws WAStorageException {
        this.mConnection = this.mAccessor.borrowConnectionTo(this.mDb);
        try {
            this.mConnection.getSqlConnection().setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, this.mLogContext, this.mTable.getDatabaseId(), LOGGER);
        }
        this.lockTableInExclusiveMode();
    }

    protected void prepareStatement() throws WAStorageException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO \"").append(this.mTable.getSchemaName()).append("\".\"");
        sql.append(this.mTable.getTableName()).append("\" VALUES (");
        for (int i = 0; i < this.mTable.getColumns().size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        Connection sqlConn = this.mConnection.getSqlConnection();
        this.mLogContext.put("sql", sql.toString());
        try {
            this.mPrepStmt = sqlConn.prepareStatement(sql.toString());
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, this.mLogContext, this.mDb.getId(), LOGGER);
        }
        finally {
            this.mLogContext.remove("sql");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockTableInExclusiveMode() throws WAStorageException {
        String tableQName = IdentifierUtil.makeQualifiedName(this.mTable.getSchemaName(), this.mTable.getTableName());
        String sql = "LOCK TABLE " + tableQName + " IN EXCLUSIVE MODE";
        this.mLogContext.put("sql", sql);
        try (Statement stat = this.mConnection.getSqlConnection().createStatement();){
            stat.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, this.mLogContext, this.mTable.getDatabaseId(), LOGGER);
        }
        finally {
            this.mLogContext.remove("sql");
        }
    }

    private void updateProgress() {
        if (this.isRunning()) {
            double insertProgress = 0.0;
            if (this.mRowCount > 0L) {
                insertProgress = Math.max(1.0, (double)this.mRowsInserted / (double)this.mRowCount);
            }
            this.setCompletedWork((int)Math.round(insertProgress * 70.0));
        }
    }

    @Override
    public void setAppendHint(boolean isAppend) {
    }

    private class RowWriter
    implements IRowWriter {
        private int mInsertsPending = 0;
        private boolean mClosed = false;
        private boolean mNeedsRollback = false;
        private long mLastProgressUpdateNanos = System.nanoTime();

        @Override
        public void write(IValue[] row) throws WAStorageException {
            if (null == JdbcLoader.this.mPrepStmt) {
                throw new IllegalStateException("Batch insert was not started");
            }
            if (JdbcLoader.this.isCanceled()) {
                throw new CancellationException();
            }
            try {
                block14: for (int i = 0; i < row.length; ++i) {
                    if (null == row[i]) {
                        JdbcLoader.this.mPrepStmt.setNull(i + 1, 12);
                        continue;
                    }
                    switch (row[i].getType().getBaseType()) {
                        case BOOLEAN: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setBoolean(i + 1, row[i].booleanValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 16);
                            continue block14;
                        }
                        case DECIMAL: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setBigDecimal(i + 1, row[i].bigDecimalValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 3);
                            continue block14;
                        }
                        case DOUBLE: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setDouble(i + 1, row[i].doubleValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 8);
                            continue block14;
                        }
                        case FLOAT: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setFloat(i + 1, row[i].floatValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 6);
                            continue block14;
                        }
                        case INTEGER: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setInt(i + 1, row[i].intValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 4);
                            continue block14;
                        }
                        case LONG: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setLong(i + 1, row[i].longValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, -5);
                            continue block14;
                        }
                        case STRING: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setString(i + 1, row[i].stringValue());
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 12);
                            continue block14;
                        }
                        case TIMESTAMP: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setTimestamp(i + 1, new Timestamp(row[i].longValue()));
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 93);
                            continue block14;
                        }
                        case DATE: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setDate(i + 1, new Date(row[i].longValue()));
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 91);
                            continue block14;
                        }
                        case TIME: {
                            if (row[i].isOK()) {
                                JdbcLoader.this.mPrepStmt.setTime(i + 1, new Time(row[i].longValue()));
                                continue block14;
                            }
                            JdbcLoader.this.mPrepStmt.setNull(i + 1, 92);
                            continue block14;
                        }
                    }
                }
                JdbcLoader.this.mPrepStmt.addBatch();
                ++JdbcLoader.this.mRowsInserted;
                ++this.mInsertsPending;
                if (this.mInsertsPending >= JdbcLoader.this.mBatchSize) {
                    this.mInsertsPending = 0;
                    JdbcLoader.this.mPrepStmt.executeBatch();
                }
                if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.mLastProgressUpdateNanos) > 1000L) {
                    this.mLastProgressUpdateNanos = System.nanoTime();
                    JdbcLoader.this.updateProgress();
                }
            }
            catch (SQLException ex) {
                this.mNeedsRollback = true;
                throw JdbcLoader.this.mErrorHandler.handleSQLException(JdbcLoader.this.mConnection, ex, null, JdbcLoader.this.mDb.getId(), LOGGER);
            }
        }

        @Override
        public void close() throws WAStorageException {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            try {
                try {
                    if (this.mInsertsPending > 0) {
                        this.mInsertsPending = 0;
                        JdbcLoader.this.mPrepStmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    this.mNeedsRollback = true;
                    throw JdbcLoader.this.mErrorHandler.handleSQLException(JdbcLoader.this.mConnection, ex, null, JdbcLoader.this.mDb.getId(), LOGGER);
                }
            }
            finally {
                try {
                    if (this.mNeedsRollback) {
                        JdbcLoader.this.mConnection.getSqlConnection().rollback();
                    } else {
                        JdbcLoader.this.mConnection.getSqlConnection().commit();
                    }
                }
                catch (SQLException ex) {
                    throw JdbcLoader.this.mErrorHandler.handleSQLException(JdbcLoader.this.mConnection, ex, null, JdbcLoader.this.mDb.getId(), LOGGER);
                }
            }
        }
    }
}

