/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.DecimalValue;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.FloatValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.LongValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.SQLDataType;
import com.ibm.neo.dataimport.storage.IRowReader;
import com.ibm.neo.dataimport.storage.SQLExceptionHandler;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcResultSetReader
implements IRowReader {
    private final IPooledConnection mConnection;
    private final SQLExceptionHandler mErrorHandler;
    private final Database mDatabase;
    private final Statement mStatement;
    private final ResultSet mResultSet;
    private final ResultSetMetaData mMetadata;
    private final boolean mResetable;
    private SQLDataType[] mSQLColumnTypes = null;
    private IDataType[] mColumnTypes = null;
    private boolean mHasMore = false;
    private final Logger mLogger = LoggerFactory.getLogger(this.getClass());

    public JdbcResultSetReader(IPooledConnection connection, SQLExceptionHandler errorHandler, Database db, Statement statement, ResultSet resultSet) throws WAStorageException {
        this.mConnection = connection;
        this.mErrorHandler = errorHandler;
        this.mStatement = statement;
        this.mDatabase = db;
        this.mResultSet = resultSet;
        try {
            this.mResetable = this.mResultSet.getType() != 1003;
            this.mMetadata = resultSet.getMetaData();
            this.discoverColumnTypes();
            this.mHasMore = this.mResultSet.next();
        }
        catch (SQLException ex) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, db == null ? null : db.getId(), this.mLogger);
        }
    }

    private void discoverColumnTypes() throws SQLException {
        int numColumns = this.mMetadata.getColumnCount();
        this.mSQLColumnTypes = new SQLDataType[numColumns];
        this.mColumnTypes = new IDataType[numColumns];
        block13: for (int i = 0; i < numColumns; ++i) {
            int sqlType = this.mMetadata.getColumnType(i + 1);
            switch (sqlType) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[]{this.mMetadata.getColumnDisplaySize(i + 1)});
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Math.max(1, this.mMetadata.getColumnDisplaySize(i + 1)));
                    continue block13;
                }
                case 2005: 
                case 2011: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Integer.MAX_VALUE);
                    continue block13;
                }
                case -5: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getLongType();
                    continue block13;
                }
                case 3: {
                    this.mSQLColumnTypes[i] = SQLDataType.getDecimal((int)this.mMetadata.getPrecision(i + 1), (int)this.mMetadata.getScale(i + 1));
                    this.mColumnTypes[i] = DataTypes.getDecimalType((int)this.mMetadata.getPrecision(i + 1), (int)this.mMetadata.getScale(i + 1));
                    continue block13;
                }
                case 8: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getDoubleType();
                    continue block13;
                }
                case 6: 
                case 7: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getFloatType();
                    continue block13;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getIntegerType();
                    continue block13;
                }
                case 16: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getBooleanType();
                    continue block13;
                }
                case 91: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getDateType();
                    continue block13;
                }
                case 92: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getTimeType();
                    continue block13;
                }
                case 93: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getTimestampType();
                    continue block13;
                }
                default: {
                    this.mSQLColumnTypes[i] = new SQLDataType(sqlType, new Object[0]);
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Integer.MAX_VALUE);
                }
            }
        }
    }

    @Override
    public int getColumnCount() throws WAStorageException {
        return this.mColumnTypes.length;
    }

    @Override
    public String[] getColumnNames() throws WAStorageException {
        try {
            int labelCount = this.getColumnCount();
            String[] labels = new String[labelCount];
            for (int i = 0; i < labelCount; ++i) {
                labels[i] = this.mMetadata.getColumnLabel(i + 1);
            }
            return labels;
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, this.mDatabase.getId(), this.mLogger);
        }
    }

    @Override
    public IDataType[] getColumnTypes() throws WAStorageException {
        return this.mColumnTypes;
    }

    @Override
    public SQLDataType[] getSQLColumnTypes() throws WAStorageException {
        return this.mSQLColumnTypes;
    }

    @Override
    public boolean hasMore() {
        return this.mHasMore;
    }

    @Override
    public IValue[] read(IValue[] row) throws WAStorageException {
        if (!this.mHasMore) {
            return null;
        }
        try {
            int columnCount = this.getColumnCount();
            if (null == row) {
                row = new IValue[columnCount];
            } else if (row.length < columnCount) {
                throw new IllegalArgumentException("row.length < columnCount");
            }
            for (int i = 0; i < columnCount; ++i) {
                row[i] = this.mColumnTypes[i].newValue();
                switch (this.mColumnTypes[i].getBaseType()) {
                    case DECIMAL: {
                        ((DecimalValue)row[i]).set(this.mResultSet.getBigDecimal(i + 1));
                        break;
                    }
                    case DOUBLE: {
                        ((DoubleValue)row[i]).set(this.mResultSet.getDouble(i + 1));
                        break;
                    }
                    case FLOAT: {
                        ((FloatValue)row[i]).set(this.mResultSet.getFloat(i + 1));
                        break;
                    }
                    case INTEGER: {
                        ((IntegerValue)row[i]).set(this.mResultSet.getInt(i + 1));
                        break;
                    }
                    case LONG: {
                        ((LongValue)row[i]).set(this.mResultSet.getLong(i + 1));
                        break;
                    }
                    case BOOLEAN: {
                        ((BooleanValue)row[i]).set(this.mResultSet.getBoolean(i + 1));
                        break;
                    }
                    case DATE: {
                        ((DateValue)row[i]).set((Date)this.mResultSet.getDate(i + 1));
                        break;
                    }
                    case TIME: {
                        ((TimeValue)row[i]).set((Date)this.mResultSet.getTime(i + 1));
                        break;
                    }
                    case TIMESTAMP: {
                        ((TimestampValue)row[i]).set((Date)this.mResultSet.getTimestamp(i + 1));
                        break;
                    }
                    default: {
                        row[i].assignFrom(this.mResultSet.getString(i + 1));
                    }
                }
                if (!this.mResultSet.wasNull()) continue;
                row[i].setNull();
            }
            this.mHasMore = this.mResultSet.next();
            return row;
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, this.mDatabase.getId(), this.mLogger);
        }
    }

    @Override
    public boolean isResetable() throws WAStorageException {
        return this.mResetable;
    }

    @Override
    public void reset() throws WAStorageException, UnsupportedOperationException {
        if (!this.isResetable()) {
            throw new UnsupportedOperationException("Reader is not resetable");
        }
        try {
            this.mResultSet.beforeFirst();
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, this.mDatabase.getId(), this.mLogger);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws WAStorageException {
        try {
            if (null == this.mResultSet) return;
            this.mResultSet.close();
            return;
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, this.mDatabase.getId(), this.mLogger);
        }
        finally {
            try {
                if (null != this.mStatement) {
                    this.mStatement.close();
                }
            }
            catch (SQLException ex) {
                throw this.mErrorHandler.handleSQLException(this.mConnection, ex, null, this.mDatabase.getId(), this.mLogger);
            }
            finally {
                if (null != this.mConnection) {
                    this.mConnection.returnToPool();
                }
            }
        }
    }
}

