/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import com.ibm.neo.persist.ion.IONObjectId;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;

public class SQLExceptionHandler {
    private final Map<String, Object> mDefaultContext;

    public SQLExceptionHandler() {
        this.mDefaultContext = Collections.emptyMap();
    }

    public SQLExceptionHandler(Map<String, Object> defaultContext) {
        this.mDefaultContext = defaultContext;
    }

    public final WAStorageException handleSQLException(IPooledConnection connection, SQLException ex, Map<String, Object> context, Logger logger) {
        return this.handleSQLException(connection, ex, context, null, logger);
    }

    public final WAStorageException handleSQLException(IPooledConnection connection, SQLException ex, Map<String, Object> context, IONObjectId databaseId, Logger logger) {
        this.logIt(connection, context, ex, logger);
        return this.convertSQLException(connection, ex, databaseId);
    }

    private void logIt(IPooledConnection connection, Map<String, Object> context, SQLException ex, Logger logger) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Caught ").append(ex.getClass().getName());
        if (null != connection) {
            messageBuilder.append("\n -> connection=#").append(Integer.toHexString(System.identityHashCode(connection)));
        }
        if (!this.mDefaultContext.isEmpty()) {
            for (Map.Entry<String, Object> e : this.mDefaultContext.entrySet()) {
                messageBuilder.append("\n -> ").append(e.getKey()).append("=").append(e.getValue());
            }
        }
        if (null != context && !context.isEmpty()) {
            for (Map.Entry<String, Object> e : context.entrySet()) {
                messageBuilder.append("\n -> ").append(e.getKey()).append("=").append(e.getValue());
            }
        }
        messageBuilder.append("\n");
        this.printTrace(ex, messageBuilder);
        logger.error(messageBuilder.toString());
    }

    protected void printTrace(SQLException ex, StringBuilder messageBuilder) {
        messageBuilder.append("[Last Exception]: ").append(ExceptionUtils.getFullStackTrace((Throwable)ex));
        for (SQLException nextEx = ex.getNextException(); null != nextEx; nextEx = nextEx.getNextException()) {
            messageBuilder.append("\n[Next Exception]: ").append(ExceptionUtils.getFullStackTrace((Throwable)nextEx));
        }
    }

    protected WAStorageException convertSQLException(IPooledConnection connection, SQLException ex) {
        return this.convertSQLException(connection, ex, null);
    }

    protected WAStorageException convertSQLException(IPooledConnection connection, SQLException ex, IONObjectId databaseId) {
        SQLException actualCause;
        for (actualCause = ex; null != actualCause && null == actualCause.getSQLState(); actualCause = actualCause.getNextException()) {
        }
        String sqlState = null == actualCause ? "" : actualCause.getSQLState();
        WAStorageException.ConnectionFailure storageEx = null;
        boolean invalidateConnection = false;
        if (sqlState.startsWith("08")) {
            invalidateConnection = true;
            storageEx = new WAStorageException.ConnectionFailure(ex.getMessage(), (Throwable)ex, databaseId);
        } else if (sqlState.startsWith("05")) {
            invalidateConnection = true;
            storageEx = new WAStorageException.JDBCException(ex.getMessage(), ex, databaseId);
        } else if (sqlState.equals("54010") || sqlState.equals("54011")) {
            storageEx = new WAStorageException.TableRowLengthExceeded(databaseId);
        } else if (sqlState.equals("57011")) {
            invalidateConnection = true;
            storageEx = new WAStorageException.ResourceExhaustion((Throwable)ex, databaseId);
        } else {
            storageEx = new WAStorageException.JDBCException(ex.getMessage(), ex, databaseId);
        }
        if (invalidateConnection && null != connection) {
            connection.invalidate();
        }
        return storageEx;
    }
}

