/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.DeployJob;
import com.ibm.neo.dataimport.nodel.storage.StoragePersistence;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.DatabaseLimits;
import com.ibm.neo.dataimport.storage.DatabaseLoadAverages;
import com.ibm.neo.dataimport.storage.DatabaseSize;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IDatabaseAccessorFactory;
import com.ibm.neo.dataimport.storage.util.DeployJobTracker;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.SortBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.util.ThreadFactories;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.api.WranglerService;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.concurrent.SubjectAwareScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService {
    public static final String PROP_SCHEDULERS_CORE = "com.ibm.neo.dataimport.storage.schedulers.core";
    public static final String PROP_MAX_DROP_ATTEMPTS = "com.ibm.neo.dataimport.storage.max-drop-attempts";
    public static final String PROP_KLUDGE_SKIP_TABLE_DROP = "com.ibm.neo.dataimport.storage.kludges.skip-table-drop";
    public static final String PROP_SYNCHRONIZE_DDL = "com.ibm.neo.dataimport.storage.synchronize-ddl";
    private static final int DEFAULT_SCHEDULERS_CORE = 1;
    private static final int DEFAULT_MAX_DROP_ATTEMPTS = 5;
    private static final int DB_LOCK_TIMEOUT_SECONDS = 300;
    public static final int DROP_TIMEOUT_SEC = 15;
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageService.class);
    private final Properties mConfiguration;
    private final ScheduledExecutorService mScheduledExecutor;
    private final DeployJobTracker mDeployJobTracker;
    private final ConcurrentLinkedQueue<IDatabaseAccessorFactory> mAccessorFactories = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, IDatabaseAccessor> mDBType2Accessor = new ConcurrentHashMap();
    private boolean mDisposed = false;
    PersistenceService mPersistenceService;
    WranglerService mWranglerService;
    int mMaxTableDropAttempts;
    boolean mSynchronizeDDL;

    public StorageService(Properties configuration) throws PersistenceException, WAStorageException {
        this(configuration, PersistenceService.getInstance(), WranglerService.getInstance());
    }

    public StorageService(Properties configuration, PersistenceService persistenceService, WranglerService wranglerService) throws WAStorageException, PersistenceException {
        if (null == configuration) {
            throw new NullArgumentException("configuration");
        }
        this.mPersistenceService = persistenceService;
        this.mWranglerService = wranglerService;
        this.mConfiguration = (Properties)configuration.clone();
        int schedulersCore = 1;
        if (null != configuration.get(PROP_SCHEDULERS_CORE)) {
            schedulersCore = Integer.parseInt(configuration.getProperty(PROP_SCHEDULERS_CORE));
        }
        LOGGER.info("Number of scheduler threads = {}", (Object)this.mMaxTableDropAttempts);
        this.mScheduledExecutor = new SubjectAwareScheduledExecutorService(Executors.newScheduledThreadPool(schedulersCore, ThreadFactories.create((String)"StorageService-Scheduler", (boolean)true)));
        this.mMaxTableDropAttempts = null != configuration.get(PROP_MAX_DROP_ATTEMPTS) ? Integer.parseInt(configuration.getProperty(PROP_MAX_DROP_ATTEMPTS)) : 5;
        LOGGER.info("Maximum table drop attempts = {}", (Object)this.mMaxTableDropAttempts);
        this.mSynchronizeDDL = Boolean.parseBoolean(configuration.getProperty(PROP_SYNCHRONIZE_DDL, "false"));
        LOGGER.info("Synchronize DDL operations = {}", (Object)this.mSynchronizeDDL);
        this.mDeployJobTracker = new DeployJobTracker((NobjectCollection<Database>)StoragePersistence.getDatabaseCollection((PersistenceService)persistenceService), (NobjectCollection<DeployJob>)StoragePersistence.getDeployJobCollection((PersistenceService)persistenceService), this.mScheduledExecutor);
        for (IDatabaseAccessorFactory factory : ServiceLoader.load(IDatabaseAccessorFactory.class)) {
            LOGGER.info("Discovered IDatabaseAccessorFactory: " + factory.getClass().getName());
            this.mAccessorFactories.add(factory);
        }
        try {
            this.bootstrapDatabaseFromProperties(configuration);
        }
        catch (PersistenceException ex) {
            throw new WAStorageException("Failed to bootstrap database from QLS properties", (Throwable)ex);
        }
    }

    public Properties getConfiguration() {
        return this.mConfiguration;
    }

    public PersistenceService getPersistenceService() {
        return this.mPersistenceService;
    }

    public WranglerService getWranglerService() {
        return this.mWranglerService;
    }

    public DeployJobTracker getDeployJobTracker() {
        return this.mDeployJobTracker;
    }

    public IDatabaseAccessor getOrCreateAccessor(String dbType) throws WAStorageException {
        IDatabaseAccessorFactory factory;
        IDatabaseAccessor accessor = this.mDBType2Accessor.get(dbType);
        if (null != accessor) {
            return accessor;
        }
        Iterator<IDatabaseAccessorFactory> iterator = this.mAccessorFactories.iterator();
        while (iterator.hasNext() && null == (accessor = (factory = iterator.next()).create(dbType, this.mConfiguration, this.mScheduledExecutor))) {
        }
        if (null == accessor) {
            throw new WAStorageException("No IDatabaseAccessorFactory was found for database type: " + dbType);
        }
        IDatabaseAccessor other = this.mDBType2Accessor.putIfAbsent(dbType, accessor);
        if (null != other) {
            accessor.dispose();
            return other;
        }
        return accessor;
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        LOGGER.info("Shutting down");
        this.mDisposed = true;
        this.mScheduledExecutor.shutdown();
        for (IDatabaseAccessor accessor : this.mDBType2Accessor.values()) {
            try {
                accessor.dispose();
            }
            catch (Exception ex) {
                LOGGER.error("Error caught while disposing IDatabaseAccessor", (Throwable)ex);
            }
        }
    }

    public Database getDatabase(IONObjectId databaseId) throws WAStorageException {
        try {
            NobjectCollection dbCol = StoragePersistence.getDatabaseCollection((PersistenceService)this.mPersistenceService);
            Database db = (Database)dbCol.get(databaseId);
            if (null == db) {
                LOGGER.warn("Failed to resolve database (_id={})", (Object)databaseId.getIdentifier());
                throw new WAStorageException.NoSuchObjectException("Failed to resolve database id: " + databaseId, databaseId);
            }
            return db;
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public List<Database> listDatabases(String name, boolean includeDisabled) throws WAStorageException {
        return this.listDatabases(name, null, includeDisabled);
    }

    public List<Database> listDatabases(String name, String pool, boolean includeDisabled) throws WAStorageException {
        try {
            NobjectCollection dbCol = StoragePersistence.getDatabaseCollection((PersistenceService)this.mPersistenceService);
            QueryBuilder query = new QueryBuilder();
            if (null != pool) {
                if ("default".equals(pool)) {
                    query.or(new IONObject[]{new QueryBuilder().equalTo("pool", null).toDocument(), new QueryBuilder().equalTo("pool", (Object)"default").toDocument()});
                } else {
                    query.equalTo("pool", (Object)pool);
                }
            }
            if (null != name) {
                query.equalTo("name", (Object)name);
            }
            if (!includeDisabled) {
                query.notEqualTo("disabled", (Object)true);
            }
            return dbCol.find(query.toDocument()).toListAndClose();
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public boolean checkDatabase(Database db) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.checkDatabase(db);
    }

    public DatabaseLimits getDatabaseLimits(Database db) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.getDatabaseLimits(db);
    }

    public DatabaseSize getDatabaseSize(Database db, boolean immediate) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.getDatabaseSize(db, immediate);
    }

    public DatabaseLoadAverages getDatabaseLoadAverages(Database db) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.getDatabaseLoadAverages(db);
    }

    public boolean checkTable(Database db, String schemaName, String tableName) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.checkTable(db, schemaName, tableName);
    }

    public boolean checkTableHasData(Database db, String schemaName, String tableName) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.getTableRowCount(db, schemaName, tableName, null) > 0L;
    }

    public boolean checkSchema(Database db, String schemaName) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.checkSchema(db, schemaName);
    }

    public boolean ensureSchemaExists(final Database db, final String schemaName) throws WAStorageException {
        final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        for (int i = 0; i < 2; ++i) {
            if (accessor.checkSchema(db, schemaName)) {
                return false;
            }
            try {
                this.executeDDL(db, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        accessor.createSchema(db, schemaName);
                        return null;
                    }
                });
                return true;
            }
            catch (WAStorageException.DuplicateNameException ex) {
                continue;
            }
        }
        return false;
    }

    public boolean ensureTableExists(final Database db, final Table table) throws WAStorageException {
        final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        for (int i = 0; i < 2; ++i) {
            if (accessor.checkTable(db, table.getSchemaName(), table.getTableName())) {
                return false;
            }
            try {
                this.executeDDL(db, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        accessor.createTable(db, table);
                        return null;
                    }
                });
                return true;
            }
            catch (WAStorageException.DuplicateNameException ex) {
                continue;
            }
        }
        return false;
    }

    public Table getTable(IONObjectId tableId) throws WAStorageException {
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            Table table = (Table)tableCol.get(tableId);
            if (null == table) {
                LOGGER.warn("Failed to resolve table (_id={})", (Object)tableId.getIdentifier());
                throw new WAStorageException.NoSuchObjectException("Failed to resolve table id: " + tableId);
            }
            return table;
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public List<Table> getLeastRecentlyAccessedTables(IONObjectId tenantId, IONObjectId databaseId, String schemaName, int limit) throws WAStorageException {
        return this.getLeastRecentlyAccessedTables(tenantId, databaseId, schemaName, null, limit);
    }

    public List<Table> getLeastRecentlyAccessedTables(IONObjectId tenantId, IONObjectId databaseId, String schemaName, Date maxDate, int limit) throws WAStorageException {
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            QueryBuilder query = new QueryBuilder();
            IONObject sort = new SortBuilder().ascending("last-access-time").toDocument();
            if (null != tenantId) {
                query.equalTo("tenant-id", (Object)tenantId);
            }
            if (null != databaseId) {
                query.equalTo("database-id", (Object)databaseId);
            }
            if (null != schemaName) {
                query.equalTo("schema-name", (Object)schemaName);
            }
            if (null != maxDate) {
                query.or(new IONObject[]{new QueryBuilder().equalTo("last-access-time", null).toDocument(), new QueryBuilder().lessThan("last-access-time", (Object)maxDate).toDocument()});
            }
            return tableCol.find(query.toDocument()).sort(sort).limit(limit).toListAndClose();
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    @Deprecated
    public List<Table> listTables(IONObjectId tenantId, IONObjectId databaseId, IONObjectId datasetId, String schemaName, String tableName) throws WAStorageException {
        return this.listTables(tenantId, databaseId, datasetId, schemaName, tableName, true, true);
    }

    @Deprecated
    public List<Table> listTables(IONObjectId tenantId, IONObjectId databaseId, IONObjectId datasetId, String schemaName, String tableName, boolean includeDeleted) throws WAStorageException {
        return this.listTables(tenantId, databaseId, datasetId, schemaName, tableName, includeDeleted, true);
    }

    public List<Table> listTables(IONObjectId tenantId, IONObjectId databaseId, IONObjectId datasetId, String schemaName, String tableName, boolean includeDeleted, boolean includeInconsistent) throws WAStorageException {
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            QueryBuilder query = new QueryBuilder();
            if (null != tenantId) {
                query.equalTo("tenant-id", (Object)tenantId);
            }
            if (null != databaseId) {
                query.equalTo("database-id", (Object)databaseId);
            }
            if (null != datasetId) {
                query.equalTo("dataset-id", (Object)datasetId);
            }
            if (null != schemaName) {
                query.equalTo("schema-name", (Object)schemaName);
            }
            if (null != tableName) {
                query.equalTo("table-name", (Object)tableName);
            }
            if (!includeDeleted) {
                query.notEqualTo("deleted", (Object)true);
            }
            if (!includeInconsistent) {
                query.notEqualTo("inconsistent", (Object)true);
            }
            return tableCol.find(query.toDocument()).toListAndClose();
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public void createTable(final Database db, final Table table) throws WAStorageException {
        final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        this.executeDDL(db, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                accessor.createTable(db, table);
                return null;
            }
        });
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            tableCol.save((Nobject)table);
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public IBulkLoader createBulkLoader(Database db, Table table) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.createBulkLoader(db, table);
    }

    public IBulkLoader createBulkLoader(Database db, Table table, long expectedRowCount) throws WAStorageException {
        IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return accessor.createBulkLoader(db, table, expectedRowCount);
    }

    public void setTableInconsistentFlag(Table table, boolean inconsistent) throws WAStorageException {
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            table.setInconsistent(inconsistent);
            tableCol.getDocumentCollection().update(table.getId(), new UpdateBuilder().set("inconsistent", (Object)inconsistent).toDocument());
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    @Deprecated
    public boolean dropTable(IONObjectId tableId) throws WAStorageException {
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            Table table = (Table)tableCol.get(tableId);
            if (null == table) {
                LOGGER.warn("Failed to resolve table (_id={})", (Object)tableId.getIdentifier());
                throw new WAStorageException.NoSuchObjectException("Failed to resolve table id: " + tableId);
            }
            return this.dropTable(table, 0);
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public boolean dropTable(Table table) throws WAStorageException {
        return this.dropTable(table, 0);
    }

    public boolean dropTable(final Table table, final int timeoutSeconds) throws WAStorageException {
        boolean skipDropKludge = table.getExtendedFields().getBoolean("skip-drop", false) || "true".equals(this.mConfiguration.getProperty(PROP_KLUDGE_SKIP_TABLE_DROP, "false"));
        LOGGER.info("Attempting to drop table (_id={}, tableName={}, timeoutSeconds={})", new Object[]{table.getId().getIdentifier(), table.getTableName(), timeoutSeconds});
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            table.setDeleted(true);
            table.setDropAttempts(table.getDropAttempts() + 1);
            tableCol.getDocumentCollection().update(table.getId(), new UpdateBuilder().set("deleted", (Object)true).inc("drop-attempts", (Number)1).toDocument());
            if (!skipDropKludge && null != table.getDatabaseId()) {
                Database db = null;
                try {
                    db = this.getDatabase(table.getDatabaseId());
                }
                catch (WAStorageException.NoSuchObjectException ex) {
                    LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}) that does not exist", new Object[]{table.getId().getIdentifier(), table.getTableName(), table.getDatabaseId().getIdentifier()});
                }
                if (null != db) {
                    boolean dropFailed;
                    block13: {
                        final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
                        dropFailed = false;
                        if (accessor.checkDatabase(db)) {
                            try {
                                if (accessor.checkTable(db, table.getSchemaName(), table.getTableName())) {
                                    final Database finalDb = db;
                                    this.executeDDL(db, new Callable<Void>(){

                                        @Override
                                        public Void call() throws Exception {
                                            accessor.dropTable(finalDb, table.getSchemaName(), table.getTableName(), timeoutSeconds);
                                            return null;
                                        }
                                    });
                                    break block13;
                                }
                                LOGGER.warn("Nothing to drop, because table (_id={}, tableName={}) does not exist in database (_id={}, url={})", new Object[]{table.getId().getIdentifier(), table.getTableName(), db.getId().getIdentifier(), db.getJdbcUrl()});
                            }
                            catch (WAStorageException ex) {
                                dropFailed = true;
                                LOGGER.error("Failed to drop table", (Throwable)ex);
                            }
                        } else {
                            dropFailed = true;
                        }
                    }
                    if (dropFailed) {
                        if (table.getDropAttempts() < this.mMaxTableDropAttempts) {
                            LOGGER.warn("Failed to drop table (_id={}, tableName={}) from database (_id={}, url={}); it will be cleaned up by maintenace tasks at a later date", new Object[]{table.getId().getIdentifier(), table.getTableName(), db.getId().getIdentifier(), db.getJdbcUrl()});
                            return false;
                        }
                        LOGGER.warn("Exceeded maximum drop attempts for table (_id={}, tableName={}); forcing cleanup", new Object[]{table.getId().getIdentifier(), table.getTableName(), db.getId().getIdentifier(), db.getJdbcUrl()});
                    }
                }
            }
            tableCol.remove(table.getId());
            LOGGER.info("Table (_id={}, tableName={}) was dropped successfully", (Object)table.getId().getIdentifier(), (Object)table.getTableName());
            return true;
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public void dropTable(Database db, String schemaName, String tableName) throws WAStorageException {
        this.dropTable(db, schemaName, tableName, 0);
    }

    public void dropTable(final Database db, final String schemaName, final String tableName, final int timeoutSeconds) throws WAStorageException {
        boolean skipDropKludge = "true".equals(this.mConfiguration.getProperty(PROP_KLUDGE_SKIP_TABLE_DROP, "false"));
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            int numDropped = tableCol.remove(new QueryBuilder().equalTo("database-id", (Object)db.getId()).equalTo("schema-name", (Object)schemaName).equalTo("table-name", (Object)tableName).toDocument());
            LOGGER.info("Removed {} records from table collection (databaseId={}, databaseName={}, schemaName={}, tableName={})", new Object[]{numDropped, db.getId().getIdentifier(), db.getName(), schemaName, tableName});
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
        if (!skipDropKludge) {
            final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
            if (accessor.checkTable(db, schemaName, tableName)) {
                LOGGER.info("Dropping table from database (databaseId={}, databaseName={}, schemaName={}, tableName={})", new Object[]{db.getId().getIdentifier(), db.getName(), schemaName, tableName});
                this.executeDDL(db, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        accessor.dropTable(db, schemaName, tableName, timeoutSeconds);
                        return null;
                    }
                });
            } else {
                LOGGER.info("Nothing to drop - table does not exist in database (databaseId={}, databaseName={}, schemaName={}, tableName={})", new Object[]{db.getId().getIdentifier(), db.getName(), schemaName, tableName});
            }
        }
    }

    public void softDropTable(Table table) throws WAStorageException {
        LOGGER.info("Soft dropping table (_id={}, tableName={})", (Object)table.getId().getIdentifier(), (Object)table.getTableName());
        try {
            NobjectCollection tableCol = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
            table.setDeleted(true);
            tableCol.getDocumentCollection().update(table.getId(), new UpdateBuilder().set("deleted", (Object)true).toDocument());
        }
        catch (PersistenceException ex) {
            LOGGER.error("Unexpected error", (Throwable)ex);
            throw new WAStorageException((Throwable)ex);
        }
    }

    public boolean dropSchema(final Database db, final String schemaName) throws WAStorageException {
        final IDatabaseAccessor accessor = this.getOrCreateAccessor(db.getDbType());
        return this.executeDDL(db, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return accessor.dropSchema(db, schemaName);
            }
        });
    }

    private void bootstrapDatabaseFromProperties(Properties config) throws PersistenceException {
        String name = config.getProperty("com.ibm.neo.dataimport.storage.database.name");
        String dbName = config.getProperty("com.ibm.neo.dataimport.storage.database.db-name");
        String dbType = config.getProperty("com.ibm.neo.dataimport.storage.database.db-type");
        String jdbcUrl = config.getProperty("com.ibm.neo.dataimport.storage.database.jdbc-url");
        String db2bdmUrl = config.getProperty("com.ibm.neo.dataimport.storage.database.db2bdm-url");
        String dashdbUrl = config.getProperty("com.ibm.neo.dataimport.storage.database.dashdb-url");
        String user = config.getProperty("com.ibm.neo.dataimport.storage.database.user");
        String password = config.getProperty("com.ibm.neo.dataimport.storage.database.password");
        if (null == name || name.isEmpty()) {
            return;
        }
        NobjectCollection dbCol = StoragePersistence.getDatabaseCollection((PersistenceService)this.mPersistenceService);
        if (dbCol.count() > 0L) {
            Database db = (Database)dbCol.findOne(new QueryBuilder().equalTo("name", (Object)name).toDocument());
            if (null != db) {
                db.setDbName(dbName);
                db.setJdbcUrl(jdbcUrl);
                db.setDb2BdmUrl(db2bdmUrl);
                db.setDashDbUrl(dashdbUrl);
                db.setUser(user);
                db.setPassword(password);
                if (!StringUtils.isEmpty((String)dbType)) {
                    db.setDbType(dbType);
                } else {
                    db.setDbType("db2-blu");
                }
                dbCol.save((Nobject)db);
            }
        } else {
            Database db = new Database();
            db.setName(name);
            db.setDbName(dbName);
            db.setJdbcUrl(jdbcUrl);
            db.setDb2BdmUrl(db2bdmUrl);
            db.setUser(user);
            db.setPassword(password);
            if (!StringUtils.isEmpty((String)dbType)) {
                db.setDbType(dbType);
            } else {
                db.setDbType("db2-blu");
            }
            dbCol.save((Nobject)db);
        }
    }

    <T> T executeDDL(Database db, Callable<T> operation) throws WAStorageException {
        try {
            if (this.mSynchronizeDDL) {
                return this.executeWithDatabaseLock(db, operation);
            }
            return operation.call();
        }
        catch (WAStorageException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAStorageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T executeWithDatabaseLock(Database db, Callable<T> operation) throws Exception {
        String dbId = null != db.getId() ? db.getId().getIdentifier() : (null != db.getJdbcUrl() ? Integer.toHexString(db.getJdbcUrl().hashCode()) : Integer.toHexString(db.hashCode()));
        String lockName = String.format("import.storage.db.%s", dbId);
        try {
            DLock dbLock = this.mWranglerService.getDLock(lockName);
            try {
                if (!dbLock.tryAcquire(300L, TimeUnit.SECONDS)) {
                    LOGGER.error("Database lock ({}) could not be acquired before timeout", (Object)lockName);
                    throw new WAStorageException("Database lock could not be acquired before timeout: " + lockName, null, db.getId());
                }
            }
            catch (InterruptedException ex) {
                LOGGER.error("Database lock ({}) could not be acquired due to interrupt", (Object)lockName, (Object)ex);
                throw new WAStorageException("Database lock could not be acquired due to interrupt: " + lockName, (Throwable)ex, db.getId());
            }
            try {
                T t = operation.call();
                return t;
            }
            finally {
                dbLock.release();
            }
        }
        catch (WranglerException ex) {
            LOGGER.error("Database lock ({}) failed", (Object)lockName, (Object)ex);
            throw new WAStorageException("Database lock failed: " + lockName, (Throwable)ex);
        }
    }
}

