/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.connection;

import com.ibm.neo.dataimport.storage.connection.DefaultConnectionPool;
import com.ibm.neo.dataimport.storage.connection.IConnectionPool;
import com.ibm.neo.dataimport.storage.connection.IExpirationPolicy;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultConnection
implements IPooledConnection {
    private static final int VALIDATION_RETRY_INTERVAL_MS = 10000;
    private static final int VALIDATION_TIMEOUT_SEC = 5;
    private final Connection mSqlConnection;
    private final Map<String, Object> mParameters;
    private final DefaultConnectionPool mPool;
    private IExpirationPolicy mExpirationPolicy = null;
    private final AtomicBoolean mInUse = new AtomicBoolean(true);
    private final AtomicBoolean mClosed = new AtomicBoolean(false);
    private volatile boolean mInvalid = false;
    private final long mCreatedTimestamp;
    private volatile long mLastBorrowedTimestamp = this.mCreatedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    private volatile long mLastReturnedTimestamp = this.mCreatedTimestamp;
    private volatile long mLastValidatedTimestamp = 0L;

    public DefaultConnection(Connection sqlConnection, Map<String, Object> parameters, DefaultConnectionPool pool) {
        this.mSqlConnection = sqlConnection;
        this.mParameters = new HashMap<String, Object>(parameters);
        this.mPool = pool;
    }

    @Override
    public final Map<String, Object> getParameters() {
        return this.mParameters;
    }

    @Override
    public Connection getSqlConnection() {
        return this.mSqlConnection;
    }

    @Override
    public final IExpirationPolicy getExpirationPolicy() {
        return this.mExpirationPolicy;
    }

    public final void setExpirationPolicy(IExpirationPolicy policy) {
        this.mExpirationPolicy = policy;
    }

    @Override
    public final boolean isInUse() {
        return this.mInUse.get();
    }

    @Override
    public final boolean isClosed() {
        return this.mClosed.get();
    }

    @Override
    public final long aliveTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mCreatedTimestamp;
    }

    @Override
    public final long idleTime() {
        if (this.isInUse()) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastReturnedTimestamp;
    }

    @Override
    public final long inUseTime() {
        if (this.isInUse()) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastBorrowedTimestamp;
        }
        return 0L;
    }

    @Override
    public final void close() throws SQLException {
        if (!this.isInUse()) {
            throw new IllegalStateException("Connection was not borrowed before closing.");
        }
        if (this.mClosed.compareAndSet(false, true)) {
            this.mSqlConnection.close();
        }
    }

    @Override
    public final boolean validate() {
        if (!this.isInUse()) {
            throw new IllegalStateException("Connection was not borrowed before validating.");
        }
        if (this.mInvalid || this.isClosed()) {
            return false;
        }
        if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastValidatedTimestamp > 10000L) {
            this.mLastValidatedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            try {
                if (this.mSqlConnection.isClosed() || !this.mSqlConnection.isValid(5)) {
                    this.mInvalid = true;
                }
            }
            catch (SQLException ex) {
                this.mInvalid = true;
            }
        }
        return !this.mInvalid;
    }

    @Override
    public final void invalidate() {
        if (!this.isInUse()) {
            throw new IllegalStateException("Connection was not borrowed before invalidating.");
        }
        this.mInvalid = true;
    }

    final boolean casInUse(boolean expected, boolean update) {
        return this.mInUse.compareAndSet(expected, update);
    }

    @Override
    public final IConnectionPool getConnectionPool() {
        return this.mPool;
    }

    @Override
    public final void returnToPool() {
        if (null == this.mPool) {
            throw new IllegalStateException("Connection was not associated with a pool.");
        }
        if (!this.isInUse()) {
            throw new IllegalStateException("Connection must be borrowed to be returned to a pool.");
        }
        this.mPool.returnToPool(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isInUse()) {
                this.returnToPool();
            }
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

