/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.connection;

import com.ibm.neo.dataimport.storage.connection.IExpirationPolicy;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExpirationPolicy
implements IExpirationPolicy {
    private final int mMaxIdleTimeSeconds;
    private final Logger mLogger = LoggerFactory.getLogger(SimpleExpirationPolicy.class);

    public SimpleExpirationPolicy(int maxIdleTimeSeconds) {
        this.mMaxIdleTimeSeconds = maxIdleTimeSeconds;
    }

    @Override
    public boolean isExpired(IPooledConnection connection) {
        boolean expired;
        long idleTimeMillis = connection.idleTime();
        boolean bl = expired = idleTimeMillis > TimeUnit.SECONDS.toMillis(this.mMaxIdleTimeSeconds);
        if (expired) {
            this.mLogger.info("Connection #{} has expired due to inactivity (idle for {} ms)", (Object)Integer.toHexString(System.identityHashCode(connection)), (Object)idleTimeMillis);
        }
        return expired;
    }
}

