/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.storage.IRowWriter;
import com.ibm.neo.io.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.lang.time.FastDateFormat;

public class CSVRowWriter
implements IRowWriter {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd", (Locale)Locale.US);
    private static final FastDateFormat TIME_FORMAT = FastDateFormat.getInstance((String)"HH:mm:ss", (Locale)Locale.US);
    private static final FastDateFormat TIMESTAMP_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS", (Locale)Locale.US);
    private final CSVWriter csvWriter;
    private String[] record = null;
    private boolean closed = false;

    public CSVRowWriter(OutputStream out) throws IOException {
        this.csvWriter = new CSVWriter(out, ',', "\n", Character.valueOf('\"'), "");
    }

    @Override
    public void write(IValue[] row) throws WAStorageException {
        if (null == this.record) {
            this.record = new String[row.length];
        }
        for (int i = 0; i < row.length; ++i) {
            this.record[i] = CSVRowWriter.toString(row[i]);
        }
        try {
            this.csvWriter.writeRecord(this.record);
        }
        catch (IOException ex) {
            throw new WAStorageException.BulkLoadError((Throwable)ex);
        }
    }

    @Override
    public void close() throws WAStorageException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.csvWriter.close();
        }
        catch (IOException ex) {
            throw new WAStorageException.BulkLoadError((Throwable)ex);
        }
    }

    private static String toString(IValue v) {
        if (null == v || !v.isOK()) {
            return null;
        }
        switch (v.getType().getBaseType()) {
            case TIMESTAMP: {
                return TIMESTAMP_FORMAT.format(v.dateValue());
            }
            case TIME: {
                return TIME_FORMAT.format(v.dateValue());
            }
            case DATE: {
                return DATE_FORMAT.format(v.dateValue());
            }
            case BOOLEAN: {
                if (v.booleanValue()) {
                    return "1";
                }
                return "0";
            }
        }
        return v.stringValue();
    }
}

