/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.CallParameter;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IResultSetHandler;
import com.ibm.neo.dataimport.storage.IRowReader;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import com.ibm.neo.dataimport.storage.db2blu.CSVRowWriter;
import com.ibm.neo.dataimport.storage.db2blu.EDictionaryOption;
import com.ibm.neo.dataimport.storage.db2blu.ELoadMode;
import com.ibm.neo.dataimport.storage.db2blu.LoadUtils;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.util.ops.AbstractOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashDbLoader
extends AbstractOperation
implements IBulkLoader {
    private static final int MAX_RESTART_ATTEMPTS = 2;
    private static final int RESTART_DELAY_MILLIS = 10000;
    private static final int PROGRESS_UPDATE_INTERVAL = 1000;
    private static final int UPLOAD_WORK_UNITS = 200;
    private static final int RUNNING_WORK_UNITS = 800;
    private static final int DEFAULT_CONCURRENCY = 10;
    private static final int MIN_DATA_BUFFER_PAGES = 5000;
    private static final int MAX_MESSAGES_TO_RETRIEVE = 100;
    private static final String UPLOAD_FOLDER = "wa_load_data";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashDbLoader.class);
    private IDatabaseAccessor accessor;
    private final HttpClient httpClient;
    private final Database db;
    private final Table table;
    private final Properties configuration;
    private long rowCount = 0L;
    private boolean appendHint = false;
    private volatile long rowsSent = 0L;
    private volatile long lastProgressUpdateNanos = System.nanoTime();

    public DashDbLoader(IDatabaseAccessor accessor, HttpClient httpClient, Database db, Table table, Properties configuration) {
        this.accessor = accessor;
        this.httpClient = httpClient;
        this.db = db;
        this.table = table;
        this.configuration = configuration;
        if (db == null) {
            throw new NullArgumentException("db parameter cannot be null.");
        }
        this.setTotalWork(1000L);
    }

    @Override
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public void setAuditTags(Map<String, String> auditTags) {
    }

    @Override
    public void setAppendHint(boolean isAppend) {
        this.appendHint = isAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(IStreamingRowWriter srw) throws WAStorageException {
        this.markAsStarted();
        int maxConcurrency = this.db.getExtendedFields().getInt("load-concurrency", 10);
        RemoteFileInfo dataFile = null;
        try {
            block24: {
                StringBuilder messageHistory;
                block25: {
                    dataFile = this.uploadData(srw);
                    int restarts = 0;
                    while (true) {
                        this.waitForAcceptableConcurrency(maxConcurrency);
                        LoadResult result = null;
                        boolean resourceExaustion = false;
                        messageHistory = new StringBuilder();
                        try {
                            result = this.loadData(dataFile.absolute, dataFile.size, maxConcurrency);
                        }
                        catch (WAStorageException.ResourceExhaustion ex) {
                            LOGGER.error("The load utility failed due to resource exhaustion", (Throwable)ex);
                            resourceExaustion = true;
                        }
                        if (null != result) {
                            List<UtilityMessage> messages;
                            try {
                                messages = this.retrieveMessages(result);
                            }
                            finally {
                                this.removeMessages(result);
                            }
                            if (result.rowsLoaded <= 0L || result.rowsRejected != 0L) {
                                for (UtilityMessage m : messages) {
                                    messageHistory.append(m.sqlCode).append(": ").append(m.msg).append('\n');
                                    if (resourceExaustion || !LoadUtils.isResourceExhaustionSqlCode(m.sqlCode)) continue;
                                    LOGGER.error("The load utility failed due to resource exhaustion (sqlCode={})", (Object)m.sqlCode);
                                    resourceExaustion = true;
                                }
                            }
                            break block24;
                        }
                        if (!resourceExaustion) break block25;
                        if (restarts >= 2) break;
                        LOGGER.warn("A restart will be attempted in {} milliseconds", (Object)10000);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++restarts;
                    }
                    throw new WAStorageException.ResourceExhaustion(this.db.getId());
                }
                if (messageHistory.length() > 0) {
                    LOGGER.error("The load utility failed. Message history:\n{}", (Object)messageHistory.toString());
                }
                throw new WAStorageException("The load utility failed. See logs for details.", null, this.db.getId());
            }
            this.markAsFinished();
        }
        catch (WAStorageException.ResourceExhaustion ex) {
            this.markAsFailed(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.markAsFailed(ex);
            throw new WAStorageException.BulkLoadError((Throwable)ex, this.db.getId());
        }
        finally {
            if (null != dataFile) {
                try {
                    this.deleteRemoteFile(dataFile.relative);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to delete remote data file: {}", (Object)dataFile.relative, (Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteFileInfo uploadData(IStreamingRowWriter srw) throws Exception {
        String filename = String.format("load_%s.csv", UUID.randomUUID().toString());
        String relativePath = String.format("%s/%s", UPLOAD_FOLDER, filename);
        String absolutePath = null;
        MultipartEntity multiPart = new MultipartEntity(HttpMultipartMode.STRICT);
        StreamingRowBody body = new StreamingRowBody(filename, srw);
        multiPart.addPart("fileData", (ContentBody)body);
        HttpPost post = new HttpPost(DashDbLoader.buildUri(this.db.getDashDbUrl(), "home", UPLOAD_FOLDER));
        post.addHeader("Authorization", DashDbLoader.makeAuthHeader(this.db.getUser(), this.db.getPassword()));
        post.setEntity((HttpEntity)multiPart);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
        try {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw WAStorageException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_STORAGE_RESPONSE, new Object[]{response.getStatusLine()}).build();
            }
            JSONObject contentJson = JSONObject.parse((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            if (!"SUCCESS".equals(contentJson.get((Object)"resultCode"))) {
                throw WAStorageException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_UPLOAD_FAILED, new Object[]{(String)contentJson.get((Object)"errorMessageCode"), (String)contentJson.get((Object)"message")}).build();
            }
            JSONObject result = (JSONObject)contentJson.get((Object)"result");
            JSONArray filesUploaded = (JSONArray)result.get((Object)"filesUploaded");
            absolutePath = (String)filesUploaded.get(0);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        RemoteFileInfo fileInfo = new RemoteFileInfo(relativePath, absolutePath, body.getBytesWritten());
        LOGGER.info("Uploaded data file: {}", (Object)fileInfo);
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAcceptableConcurrency(int maxConcurrency) throws WAStorageException {
        while (true) {
            if (this.isCanceled()) {
                throw new CancellationException();
            }
            try (IRowReader reader = this.accessor.executeQuery(this.db, "SELECT COUNT(*) FROM TABLE(SNAP_GET_UTIL(-1)) WHERE UTILITY_TYPE='LOAD'");){
                IValue[] row = new IValue[1];
                if (reader.hasMore()) {
                    if ((row = reader.read(row))[0].intValue() < maxConcurrency) break;
                    LOGGER.warn("Delaying load, since {} load jobs are running, but the max concurrency is only {}.", (Object)row[0].intValue(), (Object)maxConcurrency);
                }
            }
            try {
                Thread.sleep(100 + RandomUtils.nextInt((int)4901));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private LoadResult loadData(String absolutePath, long fileSizeBytes, int maxConcurrency) throws Exception {
        int dataBufferSizePages;
        String tableQName = LoadUtils.getTableQName(this.table.getSchemaName(), this.table.getTableName());
        ELoadMode loadMode = this.appendHint ? ELoadMode.APPEND : ELoadMode.REPLACE;
        int maxAnalyzeSizeMb = LoadUtils.chooseMaxAnalyzeSizeMB(fileSizeBytes);
        int utilityHeapSizePages = this.getUtilHeapSize();
        if (utilityHeapSizePages > 0 && maxConcurrency > 1) {
            dataBufferSizePages = (int)Math.ceil((double)utilityHeapSizePages * 0.9 / (double)maxConcurrency);
            dataBufferSizePages = Math.max(dataBufferSizePages, 5000);
        } else {
            dataBufferSizePages = -1;
        }
        LOGGER.info("Loading data [filePath={}, fileSizeBytes={}, loadMode={}, tableQName={}, maxAnalyzeSizeMB={}, maxConcurrency={}, utilHeapSizePages={}, dataBufferSizePages={}]", new Object[]{absolutePath, fileSizeBytes, loadMode, tableQName, maxAnalyzeSizeMb, maxConcurrency, utilityHeapSizePages, dataBufferSizePages});
        if (loadMode == ELoadMode.REPLACE) {
            if (EOrganizedBy.COLUMN == this.table.getOrganizedBy()) {
                this.doAnalyzeOnly(absolutePath, maxAnalyzeSizeMb, dataBufferSizePages, tableQName);
                return this.doReplace(absolutePath, dataBufferSizePages, false, tableQName);
            }
            return this.doReplace(absolutePath, dataBufferSizePages, true, tableQName);
        }
        return this.doAppend(absolutePath, dataBufferSizePages, tableQName);
    }

    private void doAnalyzeOnly(String absolutePath, int maxAnalyzeSizeMb, int dataBufferSizePages, String tableQName) throws WAStorageException {
        LOGGER.info("Starting analyze [filePath={}, maxAnalyzeSizeMb={}, dataBufferSizePages={}, tableQName={}]", new Object[]{absolutePath, maxAnalyzeSizeMb, dataBufferSizePages, tableQName});
        String loadCommand = LoadUtils.generateLoadCommand(absolutePath, false, maxAnalyzeSizeMb, dataBufferSizePages, 0, false, ELoadMode.REPLACE, EDictionaryOption.RESET_DICTIONARY_ONLY, tableQName);
        LoadResult result = this.executeLoad(loadCommand);
        if (result.rowsRead == 0L) {
            throw new WAStorageException("The load utility read 0 rows.", null, this.db.getId());
        }
        LOGGER.info("Analyze completed: {}", (Object)String.valueOf(result));
    }

    private LoadResult doReplace(String absolutePath, int dataBufferSizePages, boolean resetDictionary, String tableQName) throws WAStorageException {
        LOGGER.info("Starting replace [filePath={}, dataBufferSizePages={}, resetDictionary={}, tableQName={}]", new Object[]{absolutePath, dataBufferSizePages, resetDictionary, tableQName});
        String loadCommand = LoadUtils.generateLoadCommand(absolutePath, true, -1, dataBufferSizePages, 1, true, ELoadMode.REPLACE, resetDictionary ? EDictionaryOption.RESET_DICTIONARY : EDictionaryOption.KEEP_DICTIONARY, tableQName);
        LoadResult result = this.executeLoad(loadCommand);
        LOGGER.info("Replace completed with result: {}", (Object)String.valueOf(result));
        return result;
    }

    private LoadResult doAppend(String absolutePath, int dataBufferSizePages, String tableQName) throws WAStorageException {
        LOGGER.info("Starting append [filePath={}, dataBufferSizePages={}, tableQName={}]", new Object[]{absolutePath, dataBufferSizePages, tableQName});
        String loadCommand = LoadUtils.generateLoadCommand(absolutePath, true, -1, dataBufferSizePages, 1, true, ELoadMode.APPEND, null, tableQName);
        LoadResult result = this.executeLoad(loadCommand);
        LOGGER.info("Append completed with result: {}", (Object)String.valueOf(result));
        return result;
    }

    private LoadResult executeLoad(String loadCommand) throws WAStorageException {
        CallParameter param = CallParameter.newInput(1, (Object)loadCommand);
        final MutableObject resultHolder = new MutableObject();
        IResultSetHandler handler = new IResultSetHandler(){

            @Override
            public void onResultSet(IRowReader reader) throws WAStorageException {
                Object[] colNames = reader.getColumnNames();
                int rowsReadIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"ROWS_READ");
                int rowsSkippedIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"ROWS_SKIPPED");
                int rowsLoadedIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"ROWS_LOADED");
                int rowsRejectedIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"ROWS_REJECTED");
                int msgRetrievalIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"MSG_RETRIEVAL");
                int msgRemovalIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"MSG_REMOVAL");
                if (reader.hasMore()) {
                    IValue[] row = reader.read(null);
                    resultHolder.setValue((Object)new LoadResult(row[rowsReadIndex].longValue(), row[rowsSkippedIndex].longValue(), row[rowsLoadedIndex].longValue(), row[rowsRejectedIndex].longValue(), row[msgRetrievalIndex].stringValue(), row[msgRemovalIndex].stringValue()));
                }
            }
        };
        this.accessor.executeCall(this.db, "CALL SYSPROC.ADMIN_CMD(?)", handler, param);
        LoadResult result = (LoadResult)resultHolder.getValue();
        if (null == result) {
            throw new WAStorageException("Load result was missing", null, this.db.getId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UtilityMessage> retrieveMessages(LoadResult result) throws WAStorageException {
        if (null != result.msgRetrievalSql) {
            ArrayList<UtilityMessage> messages = new ArrayList<UtilityMessage>();
            try (IRowReader reader = this.accessor.executeQuery(this.db, result.msgRetrievalSql);){
                Object[] colNames = reader.getColumnNames();
                int sqlCodeIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"SQLCODE");
                int msgIndex = ArrayUtils.indexOf((Object[])colNames, (Object)"MSG");
                IValue[] row = new IValue[reader.getColumnCount()];
                while (reader.hasMore() && messages.size() < 100) {
                    row = reader.read(row);
                    messages.add(new UtilityMessage(row[sqlCodeIndex].stringValue(), row[msgIndex].stringValue()));
                }
                ArrayList<UtilityMessage> arrayList = messages;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    private void removeMessages(LoadResult result) throws WAStorageException {
        if (null != result.msgRemovalSql) {
            this.accessor.execute(this.db, result.msgRemovalSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getRemoteFile(String relativePath) throws Exception {
        HttpGet get = new HttpGet(DashDbLoader.buildUri(this.db.getDashDbUrl(), "home", relativePath));
        get.addHeader("Authorization", DashDbLoader.makeAuthHeader(this.db.getUser(), this.db.getPassword()));
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        try {
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            return byArray;
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    boolean deleteRemoteFile(String relativePath) throws Exception {
        HttpDelete delete = new HttpDelete(DashDbLoader.buildUri(this.db.getDashDbUrl(), "home", relativePath));
        delete.addHeader("Authorization", DashDbLoader.makeAuthHeader(this.db.getUser(), this.db.getPassword()));
        HttpResponse response = this.httpClient.execute((HttpUriRequest)delete);
        try {
            switch (response.getStatusLine().getStatusCode()) {
                case 400: 
                case 404: {
                    boolean bl = false;
                    return bl;
                }
                case 200: {
                    boolean bl = true;
                    return bl;
                }
            }
            throw WAStorageException.newBuilder().withMessage((IMessageKey)NeoImportError.NEO_IS_STORAGE_RESPONSE, new Object[]{response.getStatusLine()}).build();
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUtilHeapSize() throws WAStorageException {
        try (IRowReader reader = this.accessor.executeQuery(this.db, "SELECT VALUE FROM SYSIBMADM.DBCFG WHERE NAME='util_heap_sz'");){
            if (reader.hasMore()) {
                IValue[] row = new IValue[1];
                row = reader.read(row);
                int n = row[0].intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    protected void cancelImpl() {
    }

    private static String buildUri(String ... parts) {
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.length() > 0 && part.startsWith("/")) {
                part = part.substring(1);
            }
            if (part.length() > 0 && part.endsWith("/")) {
                part = part.substring(0, part.length() - 1);
            }
            if (part.length() <= 0) continue;
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private static String makeAuthHeader(String user, String password) {
        String auth = user + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("ISO-8859-1")));
        return "Basic " + new String(encodedAuth);
    }

    private void updateProgress() {
        long millisSinceLastUpdate;
        if (this.isRunning() && (millisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastProgressUpdateNanos)) > 1000L) {
            this.lastProgressUpdateNanos = System.nanoTime();
            double uploadProgress = 0.0;
            double jobProgress = 0.0;
            if (this.rowCount > 0L && (uploadProgress = (double)this.rowsSent / (double)this.rowCount) > 1.0) {
                uploadProgress = 1.0;
            }
            this.setCompletedWork((int)Math.floor(uploadProgress * 200.0) + (int)Math.floor(jobProgress * 800.0));
        }
    }

    private final class StreamingRowBody
    extends AbstractContentBody {
        private final String filename;
        private final IStreamingRowWriter streamingRowWriter;
        private long bytesWritten;

        public StreamingRowBody(String filename, IStreamingRowWriter streamRowWriter) {
            super("application/octet-stream");
            this.bytesWritten = 0L;
            this.filename = filename;
            this.streamingRowWriter = streamRowWriter;
        }

        long getBytesWritten() {
            return this.bytesWritten;
        }

        public String getFilename() {
            return this.filename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream out) throws IOException {
            CloseShieldOutputStream shieldOut = new CloseShieldOutputStream(out);
            CountingOutputStream countingOut = new CountingOutputStream((OutputStream)shieldOut);
            RowWriter writer = new RowWriter((OutputStream)countingOut);
            try {
                try {
                    this.streamingRowWriter.write(writer);
                }
                finally {
                    writer.close();
                    this.bytesWritten = countingOut.getByteCount();
                }
            }
            catch (WAStorageException ex) {
                throw new IOException(ex);
            }
        }

        public String getCharset() {
            return null;
        }

        public String getTransferEncoding() {
            return "binary";
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private final class RowWriter
    extends CSVRowWriter {
        RowWriter(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        public void write(IValue[] row) throws WAStorageException {
            if (DashDbLoader.this.isCanceled()) {
                throw new CancellationException();
            }
            super.write(row);
            ++DashDbLoader.this.rowsSent;
            DashDbLoader.this.updateProgress();
        }
    }

    static final class UtilityMessage {
        final String sqlCode;
        final String msg;

        UtilityMessage(String sqlCode, String msg) {
            this.sqlCode = sqlCode;
            this.msg = msg;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    static final class LoadResult {
        final long rowsRead;
        final long rowsSkipped;
        final long rowsLoaded;
        final long rowsRejected;
        final String msgRetrievalSql;
        final String msgRemovalSql;

        LoadResult(long rowsRead, long rowsSkipped, long rowsLoaded, long rowsRejected, String msgRetrievalSql, String msgRemovalSql) {
            this.rowsRead = rowsRead;
            this.rowsSkipped = rowsSkipped;
            this.rowsLoaded = rowsLoaded;
            this.rowsRejected = rowsRejected;
            this.msgRetrievalSql = msgRetrievalSql;
            this.msgRemovalSql = msgRemovalSql;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    static final class RemoteFileInfo {
        final String relative;
        final String absolute;
        final long size;

        RemoteFileInfo(String relative, String absolute, long size) {
            this.relative = relative;
            this.absolute = absolute;
            this.size = size;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

