/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.db2bdm.api.Db2BdmClient;
import com.ibm.db2bdm.api.Db2BdmClientFactory;
import com.ibm.db2bdm.api.Db2BdmException;
import com.ibm.db2bdm.api.JobHandle;
import com.ibm.db2bdm.api.model.job.EFileFormat;
import com.ibm.db2bdm.api.model.job.EJobPhase;
import com.ibm.db2bdm.api.model.job.ELoadMode;
import com.ibm.db2bdm.api.model.job.spec.JobSpec;
import com.ibm.db2bdm.api.model.job.spec.LoadJobSpec;
import com.ibm.db2bdm.api.util.Secret;
import com.ibm.db2bdm.api.util.StreamedOutput;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import com.ibm.neo.dataimport.storage.db2blu.CSVRowWriter;
import com.ibm.neo.util.ops.AbstractOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2BdmLoader
extends AbstractOperation
implements IBulkLoader {
    public static final String PROP_MAX_QUEUED_TIME = "com.ibm.neo.dataimport.storage.bdm.max-queued-time";
    private static final int DEFAULT_MAX_QUEUED_TIME = (int)TimeUnit.MINUTES.toSeconds(10L);
    private static final int PROGRESS_UPDATE_INTERVAL = 1000;
    private static final long PHASE_CHANGE_WAIT = 2000L;
    private static final int UPLOAD_WORK_UNITS = 200;
    private static final int RUNNING_WORK_UNITS = 800;
    private static final EnumSet<EJobPhase> CANCELABLE_PHASES = EnumSet.of(EJobPhase.PENDING, EJobPhase.QUEUED, EJobPhase.RUNNING);
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2BdmLoader.class);
    private final Database db;
    private final Table table;
    private final Properties configuration;
    private Map<String, String> auditTags;
    private long rowCount = 0L;
    private boolean appendHint = false;
    private volatile long rowsSent = 0L;
    private volatile JobHandle job = null;
    private volatile long lastProgressUpdateNanos = System.nanoTime();

    public Db2BdmLoader(Database _db, Table _table, Properties _configuration) {
        if (_db == null) {
            throw new NullArgumentException("_db argument cannot be null.");
        }
        this.db = _db;
        this.table = _table;
        this.configuration = _configuration;
        this.setTotalWork(1000L);
    }

    @Override
    public void setRowCount(long _rowCount) {
        this.rowCount = _rowCount;
    }

    @Override
    public void setAuditTags(Map<String, String> _auditTags) {
        this.auditTags = _auditTags;
    }

    @Override
    public void setAppendHint(boolean isAppend) {
        this.appendHint = isAppend;
    }

    @Override
    public void start(final IStreamingRowWriter srw) throws WAStorageException {
        LoadJobSpec spec = new LoadJobSpec();
        spec.setDatabase(this.db.getDbName());
        spec.setSchema(this.table.getSchemaName());
        spec.setTable(this.table.getTableName());
        spec.setUser(this.db.getUser());
        if (!StringUtils.isEmpty((String)this.db.getPassword())) {
            spec.setPassword(new Secret(this.db.getPassword()));
        }
        if (this.appendHint) {
            spec.setMode(ELoadMode.APPEND);
        } else {
            spec.setMode(ELoadMode.REPLACE);
        }
        spec.setFormat(EFileFormat.CSV);
        spec.setCodePage(1208);
        spec.setWarningCount(-1);
        if (null != this.auditTags) {
            spec.setTags(this.auditTags);
        }
        this.markAsStarted();
        Db2BdmClient client = null;
        try {
            try {
                client = Db2BdmClientFactory.create((URI)new URI(this.db.getDb2BdmUrl()));
            }
            catch (URISyntaxException ex) {
                throw new WAStorageException("Bad DB2 BDM endpoint", (Throwable)ex);
            }
            this.job = client.createJob((JobSpec)spec);
            LOGGER.info("Created LOAD job ({}) with spec: {}", (Object)this.job.getId(), (Object)spec.toString());
            LOGGER.info("Uploading rows to LOAD job ({})", (Object)this.job.getId());
            this.job.sendInput(new StreamedOutput(){

                public void write(OutputStream out) throws IOException {
                    RowWriter writer = new RowWriter(out);
                    try {
                        try {
                            srw.write(writer);
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (WAStorageException ex) {
                        throw new IOException(ex);
                    }
                }
            }, false);
            LOGGER.info("Finished uploading rows to LOAD job ({})", (Object)this.job.getId());
            int maxQueuedTimeSeconds = this.getMaxQueuedTimeSeconds();
            long startNanos = System.nanoTime();
            block27: while (!this.isCanceled()) {
                String logDetails = "?";
                switch (this.job.getPhase()) {
                    case PENDING: {
                        if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos) > (long)maxQueuedTimeSeconds) {
                            LOGGER.error("LOAD job ({}) has been pending for over {} seconds - it will be canceled");
                            this.job.cancel();
                            throw new CancellationException();
                        }
                        LOGGER.info("LOAD job ({}) is pending", (Object)this.job.getId());
                        this.job.waitForPhaseChange(EJobPhase.PENDING, 2000L);
                        break;
                    }
                    case QUEUED: {
                        if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos) > (long)maxQueuedTimeSeconds) {
                            LOGGER.error("LOAD job ({}) has been queued for over {} seconds - it will be canceled");
                            this.job.cancel();
                            throw new CancellationException();
                        }
                        LOGGER.info("LOAD job ({}) is queued", (Object)this.job.getId());
                        this.job.waitForPhaseChange(EJobPhase.QUEUED, 2000L);
                        break;
                    }
                    case RUNNING: {
                        LOGGER.info("LOAD job ({}) is running [{}%]", (Object)this.job.getId(), (Object)this.job.getProgressPercent());
                        this.updateProgress();
                        this.job.waitForPhaseChange(EJobPhase.RUNNING, 2000L);
                        break;
                    }
                    case COMPLETE: {
                        LOGGER.info("LOAD job ({}) has completed", (Object)this.job.getId());
                        break block27;
                    }
                    case FAILED: {
                        try {
                            logDetails = this.job.receiveLogAsString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LOGGER.error("LOAD job ({}) has failed. Log details:\n{}", (Object)this.job.getId(), (Object)logDetails);
                        this.job.throwError();
                        break;
                    }
                    case CANCELLED: {
                        LOGGER.warn("LOAD job ({}) was cancelled", (Object)this.job.getId());
                        throw new CancellationException();
                    }
                    default: {
                        throw new IllegalStateException("Unexpected job phase: " + this.job.getPhase());
                    }
                }
            }
            this.markAsFinished();
        }
        catch (CancellationException ex) {
            throw ex;
        }
        catch (Db2BdmException ex) {
            this.markAsFailed(ex);
            if (Db2BdmException.EConditionCode.TOO_MANY_REQUESTS == ex.getWatsonMessageContext().getConditionCode()) {
                throw new WAStorageException.ResourceExhaustion((Throwable)ex, this.db.getId());
            }
            throw new WAStorageException.BulkLoadError((Throwable)ex, this.db.getId());
        }
        catch (RuntimeException ex) {
            this.markAsFailed(ex);
            throw new WAStorageException("Internal error", (Throwable)ex, this.db.getId());
        }
        finally {
            if (null != this.job && CANCELABLE_PHASES.contains(this.job.getPhase())) {
                try {
                    LOGGER.warn("Canceling incomplete LOAD job ({})", (Object)this.job.getId());
                    this.job.cancel();
                }
                catch (Db2BdmException ex) {
                    LOGGER.error("Failed to cancel job", (Throwable)ex);
                }
            }
            if (null != client) {
                try {
                    client.close();
                }
                catch (Db2BdmException ex) {
                    LOGGER.error("Error occured while shutting down DB2 BDM client", (Throwable)ex);
                }
            }
        }
    }

    protected void cancelImpl() {
        JobHandle _job = this.job;
        if (null != _job && CANCELABLE_PHASES.contains(_job.getPhase())) {
            try {
                LOGGER.warn("Canceling incomplete LOAD job ({})", (Object)this.job.getId());
                _job.cancel();
            }
            catch (Db2BdmException ex) {
                LOGGER.error("Failed to cancel job", (Throwable)ex);
            }
        }
    }

    private int getMaxQueuedTimeSeconds() {
        int result = DEFAULT_MAX_QUEUED_TIME;
        if (this.configuration.containsKey(PROP_MAX_QUEUED_TIME)) {
            try {
                result = Integer.parseInt(this.configuration.getProperty(PROP_MAX_QUEUED_TIME));
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Illegal value for property '{}': {}", new Object[]{PROP_MAX_QUEUED_TIME, this.configuration.getProperty(PROP_MAX_QUEUED_TIME), ex});
            }
            if (result <= 0) {
                LOGGER.error("Illegal value for property '{}': {}", (Object)PROP_MAX_QUEUED_TIME, (Object)result);
                result = DEFAULT_MAX_QUEUED_TIME;
            }
        }
        return result;
    }

    private void updateProgress() {
        long millisSinceLastUpdate;
        if (this.isRunning() && (millisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastProgressUpdateNanos)) > 1000L) {
            JobHandle _job;
            this.lastProgressUpdateNanos = System.nanoTime();
            double uploadProgress = 0.0;
            double jobProgress = 0.0;
            if (this.rowCount > 0L && (uploadProgress = (double)this.rowsSent / (double)this.rowCount) > 1.0) {
                uploadProgress = 1.0;
            }
            if (null != (_job = this.job)) {
                if (_job.getPhase() != EJobPhase.PENDING) {
                    uploadProgress = 1.0;
                }
                jobProgress = _job.getProgressPercent() / 100.0;
            }
            this.setCompletedWork((int)Math.floor(uploadProgress * 200.0) + (int)Math.floor(jobProgress * 800.0));
        }
    }

    private final class RowWriter
    extends CSVRowWriter {
        RowWriter(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        public void write(IValue[] row) throws WAStorageException {
            if (Db2BdmLoader.this.isCanceled()) {
                throw new CancellationException();
            }
            super.write(row);
            ++Db2BdmLoader.this.rowsSent;
            Db2BdmLoader.this.updateProgress();
        }
    }
}

