/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.db2bdm.api.Db2BdmClient;
import com.ibm.db2bdm.api.Db2BdmClientFactory;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Column;
import com.ibm.neo.dataimport.nodel.storage.ColumnStats;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.SQLDataType;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.CallParameter;
import com.ibm.neo.dataimport.storage.DatabaseLimits;
import com.ibm.neo.dataimport.storage.DatabaseLoadAverages;
import com.ibm.neo.dataimport.storage.DatabaseSize;
import com.ibm.neo.dataimport.storage.DatabaseVersion;
import com.ibm.neo.dataimport.storage.EOrderByDirection;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IResultSetHandler;
import com.ibm.neo.dataimport.storage.IRowReader;
import com.ibm.neo.dataimport.storage.JdbcResultSetReader;
import com.ibm.neo.dataimport.storage.JoinPath;
import com.ibm.neo.dataimport.storage.connection.DefaultConnectionPool;
import com.ibm.neo.dataimport.storage.connection.IConnectionFactory;
import com.ibm.neo.dataimport.storage.connection.IConnectionPool;
import com.ibm.neo.dataimport.storage.connection.IConnectionSelector;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import com.ibm.neo.dataimport.storage.connection.SecretParameter;
import com.ibm.neo.dataimport.storage.connection.SimpleExpirationPolicy;
import com.ibm.neo.dataimport.storage.db2blu.DashDbLoader;
import com.ibm.neo.dataimport.storage.db2blu.Db2BdmLoader;
import com.ibm.neo.dataimport.storage.db2blu.Db2ExceptionHandler;
import com.ibm.neo.dataimport.storage.db2blu.Db2JdbcLoader;
import com.ibm.neo.dataimport.storage.util.IdentifierUtil;
import com.ibm.neo.dataimport.storage.util.TableAliasMap;
import com.ibm.neo.exception.IllegalPropertyValueException;
import com.ibm.neo.exception.MissingRequiredPropertyException;
import com.ibm.neo.util.Assertions;
import com.ibm.wa.webclient.util.PoolingHttpClientBuilder;
import com.ibm.wa.webclient.util.RuleBasedRetryStrategy;
import java.io.Closeable;
import java.net.URI;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.AutoRetryHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2BluAccessor
implements IDatabaseAccessor {
    public static final String PROP_TABLESPACE_STRIPING_ENABLED = "com.ibm.neo.dataimport.storage.tablespace-striping.enabled";
    public static final String PROP_TABLESPACE_STRIPING_PREFIX = "com.ibm.neo.dataimport.storage.tablespace-striping.prefix";
    public static final String PROP_TABLESPACE_STRIPING_SIZE = "com.ibm.neo.dataimport.storage.tablespace-striping.size";
    public static final String DROP_SCHEMA_ERROR_SCHEMA_NAME = "DROP_SCHEMA_ERRORS";
    private static final String DEFAULT_TABLESPACE_STRIPING_ENABLED = "false";
    private static final String URL = "url";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String SSL_CONNECTION = "sslConnection";
    private static final String ISOLATION_LEVEL = "isolationLevel";
    private static final String EXTRA_CONNECTION_PROPS = "extraConnectionProps";
    private static final String RETRIEVE_MESSAGES_FROM_SERVER_ON_GET_MESSAGE = "retrieveMessagesFromServerOnGetMessage";
    private static final String LOGIN_TIMEOUT = "loginTimeout";
    private static final String BLOCKING_READ_CONNECTION_TIMEOUT = "blockingReadConnectionTimeout";
    private static final String COMMAND_TIMEOUT = "commandTimeout";
    private static final String ROW_ID = "__row_id__";
    private static final long MAX_ROWS_FOR_JDBC_LOAD = 20000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2BluAccessor.class);
    private static final Db2ExceptionHandler EXCEPTION_HANDLER = new Db2ExceptionHandler();
    private final Properties mConfiguration;
    private final boolean mTablespaceStriping;
    private final String mTablespaceStripingPrefix;
    private final int mTablespaceStripingSize;
    private final boolean mForceJdbcInsert;
    private final IConnectionPool mConnPool;
    private final HttpClient mHttpClient;

    public Db2BluAccessor(Properties configuration, ScheduledExecutorService scheduler) throws WAStorageException {
        this.mConfiguration = (Properties)configuration.clone();
        int connectionIdleTimeSeconds = Integer.parseInt(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.idle-time", "120"));
        if (connectionIdleTimeSeconds < 0) {
            throw new IllegalPropertyValueException("com.ibm.neo.dataimport.storage.connection.idle-time", (Object)this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.idle-time"));
        }
        int connectionMaxInUse = Integer.parseInt(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.max-in-use", "100"));
        if (connectionMaxInUse <= 0) {
            throw new IllegalPropertyValueException("com.ibm.neo.dataimport.storage.connection.max-in-use", (Object)this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.max-in-use"));
        }
        int connectionBorrowTimeoutSeconds = Integer.parseInt(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.borrow-timeout", "60"));
        if (connectionBorrowTimeoutSeconds <= 0) {
            throw new IllegalPropertyValueException("com.ibm.neo.dataimport.storage.connection.borrow-timeout", (Object)this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.borrow-timeout"));
        }
        boolean connectionDisableReuse = Boolean.parseBoolean(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.disable-reuse", DEFAULT_TABLESPACE_STRIPING_ENABLED));
        int connectionMaintenanceIntervalSeconds = Integer.parseInt(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.maintenance-interval", "30"));
        if (connectionMaintenanceIntervalSeconds <= 0) {
            throw new IllegalPropertyValueException("com.ibm.neo.dataimport.storage.connection.maintenance-interval", (Object)this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.connection.maintenance-interval"));
        }
        this.mTablespaceStriping = Boolean.parseBoolean(this.mConfiguration.getProperty(PROP_TABLESPACE_STRIPING_ENABLED, DEFAULT_TABLESPACE_STRIPING_ENABLED));
        if (this.mTablespaceStriping) {
            this.mTablespaceStripingPrefix = this.mConfiguration.getProperty(PROP_TABLESPACE_STRIPING_PREFIX);
            String stripSizeStr = this.mConfiguration.getProperty(PROP_TABLESPACE_STRIPING_SIZE);
            if (null == this.mTablespaceStripingPrefix || this.mTablespaceStripingPrefix.length() == 0) {
                throw new MissingRequiredPropertyException(PROP_TABLESPACE_STRIPING_PREFIX);
            }
            if (null == stripSizeStr || stripSizeStr.length() == 0) {
                throw new MissingRequiredPropertyException(PROP_TABLESPACE_STRIPING_SIZE);
            }
            try {
                this.mTablespaceStripingSize = Integer.parseInt(stripSizeStr);
            }
            catch (NumberFormatException ex) {
                throw new IllegalPropertyValueException(PROP_TABLESPACE_STRIPING_SIZE, (Object)stripSizeStr);
            }
        } else {
            this.mTablespaceStripingPrefix = null;
            this.mTablespaceStripingSize = -1;
        }
        this.mForceJdbcInsert = Boolean.parseBoolean(this.mConfiguration.getProperty("com.ibm.neo.dataimport.storage.force-jdbc-insert", DEFAULT_TABLESPACE_STRIPING_ENABLED));
        LOGGER.info("Initializing DB2 BLU accessor [connIdleTimeSeconds={}, connMaxInUse={}, connBorrowTimeoutSeconds={}, connDisableReuse={}, connMaintIntervalSeconds={}, stripingEnabled={}, stripingPrefix={}, stripingCount={}, forceJdbcInsert={}]", new Object[]{connectionIdleTimeSeconds, connectionMaxInUse, connectionBorrowTimeoutSeconds, connectionDisableReuse, connectionMaintenanceIntervalSeconds, this.mTablespaceStriping, this.mTablespaceStripingPrefix, this.mTablespaceStripingSize, this.mForceJdbcInsert});
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load JDBC driver (com.ibm.db2.jcc.DB2Driver)", (Throwable)ex);
            throw new WAStorageException.DriverLoadFailure("Failed to load JDBC driver (com.ibm.db2.jcc.DB2Driver)", (Throwable)ex);
        }
        this.mConnPool = new DefaultConnectionPool("db2-blu", new ConnectionFactory(), new ConnectionSelector(connectionDisableReuse), new SimpleExpirationPolicy(connectionIdleTimeSeconds), connectionMaxInUse, connectionBorrowTimeoutSeconds, scheduler, connectionMaintenanceIntervalSeconds);
        HttpClient poolingHttpClient = new PoolingHttpClientBuilder().withConnectionTotal(100).withConnectionRouteTotal(50).withConnectionTTL(300000).withConnectTimeout(180000).withSchemePortTLSProtocols("https", 443, new String[]{"SSLv3", "TLSv1.2"}).build();
        RuleBasedRetryStrategy retryStrategy = new RuleBasedRetryStrategy(1000L).addRule(500, 2).addRule(502, 2).addRule(503, 5).addRule(504, 5);
        this.mHttpClient = new AutoRetryHttpClient(poolingHttpClient, (ServiceUnavailableRetryStrategy)retryStrategy);
    }

    @Override
    public boolean charsHaveByteLengthSemantics(Database db) throws WAStorageException {
        return true;
    }

    @Override
    public int maxBytesPerChar(Database db) throws WAStorageException {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkDatabase(Database db) {
        LOGGER.debug("checkDatabase() called [database='{}']", (Object)db.getJdbcUrl());
        try {
            IPooledConnection conn = this.borrowConnectionTo(db);
            try {
                if (!conn.validate()) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                conn.returnToPool();
            }
        }
        catch (WAStorageException ex) {
            return false;
        }
        if (!StringUtils.isNotEmpty((String)db.getDb2BdmUrl())) return true;
        try (Db2BdmClient client = Db2BdmClientFactory.create((URI)new URI(db.getDb2BdmUrl()));){
            client.getServiceInfo();
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to validate connection to DB2 BDM", (Throwable)ex);
            return false;
        }
    }

    @Override
    public DatabaseLimits getDatabaseLimits(Database db) throws WAStorageException {
        LOGGER.debug("getDatabaseLimits() called [database='{}']", (Object)db.getJdbcUrl());
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            Connection sqlConn = conn.getSqlConnection();
            DatabaseMetaData metadata = sqlConn.getMetaData();
            DatabaseLimits.Builder builder = new DatabaseLimits.Builder();
            DatabaseLimits databaseLimits = builder.withMaxColumnNameLength(metadata.getMaxColumnNameLength()).withMaxColumnsInSelect(metadata.getMaxColumnsInSelect()).withMaxColumnsInTable(metadata.getMaxColumnsInTable()).withMaxTableNameLength(metadata.getMaxTableNameLength()).build();
            return databaseLimits;
        }
        catch (SQLException ex) {
            HashMap<String, Object> logContext = new HashMap<String, Object>();
            logContext.put("database", db.getJdbcUrl());
            throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public DatabaseVersion getDatabaseVersion(Database db) throws WAStorageException {
        LOGGER.debug("getDatabaseVersion() called [database='{}']", (Object)db.getJdbcUrl());
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            Connection sqlConn = conn.getSqlConnection();
            DatabaseMetaData metadata = sqlConn.getMetaData();
            DatabaseVersion databaseVersion = new DatabaseVersion(metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion(), metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion());
            return databaseVersion;
        }
        catch (SQLException ex) {
            HashMap<String, Object> logContext = new HashMap<String, Object>();
            logContext.put("database", db.getJdbcUrl());
            throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public DatabaseSize getDatabaseSize(Database db, boolean immediate) throws WAStorageException {
        LOGGER.debug("getDatabaseSize() called [database='{}', immediate={}]", (Object)db.getJdbcUrl(), (Object)immediate);
        CallParameter snapshotTimestampOut = CallParameter.newOutput(1, SQLDataType.getTimestamp());
        CallParameter dbSizeOut = CallParameter.newOutput(2, SQLDataType.getBigInt());
        CallParameter dbCapacityOut = CallParameter.newOutput(3, SQLDataType.getBigInt());
        CallParameter refreshWindowIn = CallParameter.newInput(4, (Object)(immediate ? 0 : -1));
        this.executeCall(db, "CALL GET_DBSIZE_INFO(?, ?, ?, ?)", snapshotTimestampOut, dbSizeOut, dbCapacityOut, refreshWindowIn);
        DatabaseSize dbSize = new DatabaseSize(((Number)dbSizeOut.getValue()).longValue(), ((Number)dbCapacityOut.getValue()).longValue());
        LOGGER.debug("getDatabaseSize() returned {}", (Object)dbSize);
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseLoadAverages getDatabaseLoadAverages(Database db) throws WAStorageException {
        LOGGER.debug("getDatabaseLoadAverages() called [database='{}']", (Object)db.getJdbcUrl());
        int numCpus = 0;
        double shortLoadAvg = 0.0;
        double mediumLoadAvg = 0.0;
        double longLoadAvg = 0.0;
        try (IRowReader reader = this.executeQuery(db, "SELECT NAME, VALUE FROM \"SYSIBMADM\".\"ENV_SYS_RESOURCES\"");){
            while (reader.hasMore()) {
                IValue[] row = reader.read(null);
                if ("CPU_TOTAL".equals(row[0].stringValue())) {
                    numCpus = row[1].intValue();
                    continue;
                }
                if ("CPU_LOAD_SHORT".equals(row[0].stringValue())) {
                    shortLoadAvg = row[1].doubleValue();
                    continue;
                }
                if ("CPU_LOAD_MEDIUM".equals(row[0].stringValue())) {
                    mediumLoadAvg = row[1].doubleValue();
                    continue;
                }
                if (!"CPU_LOAD_LONG".equals(row[0].stringValue())) continue;
                longLoadAvg = row[1].doubleValue();
            }
        }
        DatabaseLoadAverages averages = new DatabaseLoadAverages(shortLoadAvg / (double)numCpus, mediumLoadAvg / (double)numCpus, longLoadAvg / (double)numCpus);
        LOGGER.debug("getDatabaseLoadAverages() returned {}", (Object)averages);
        return averages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsColumnOrganizedTables(Database db) throws WAStorageException {
        DatabaseVersion version = this.getDatabaseVersion(db);
        if (version.getMajorVersion() < 10) {
            return false;
        }
        if (version.getMajorVersion() == 10 && version.getMinorVersion() < 5) {
            return false;
        }
        String tableName = "TestColumnOrganized_" + UUID.randomUUID().toString();
        boolean created = false;
        try {
            this.executeUpdate(db, "CREATE TABLE \"" + tableName + "\" (A INT) ORGANIZE BY COLUMN");
            created = true;
        }
        catch (WAStorageException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (created) {
                this.executeUpdate(db, "DROP TABLE \"" + tableName + "\"");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSchema(Database db, String schemaName) throws WAStorageException {
        LOGGER.debug("checkSchema() called [database='{}', schema='{}']", (Object)db.getJdbcUrl(), (Object)schemaName);
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            boolean bl;
            Connection sqlConn = conn.getSqlConnection();
            ResultSet rs = sqlConn.getMetaData().getSchemas(null, schemaName);
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    HashMap<String, Object> logContext = new HashMap<String, Object>();
                    logContext.put("database", db.getJdbcUrl());
                    logContext.put("schema", schemaName);
                    throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
                }
            }
            rs.close();
            return bl;
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public void createSchema(Database db, String schemaName) throws WAStorageException {
        LOGGER.debug("createSchema() called [database='{}', schema='{}']", (Object)db.getJdbcUrl(), (Object)schemaName);
        String sql = "CREATE SCHEMA \"" + schemaName + "\" AUTHORIZATION " + db.getUser();
        this.executeUpdate(db, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTable(Database db, String schemaName, String tableName) throws WAStorageException {
        LOGGER.debug("checkTable() called [database='{}', schema='{}', table='{}']", new Object[]{db.getJdbcUrl(), schemaName, tableName});
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            boolean bl;
            Connection sqlConn = conn.getSqlConnection();
            ResultSet rs = sqlConn.getMetaData().getTables(null, schemaName, tableName, null);
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    HashMap<String, Object> logContext = new HashMap<String, Object>();
                    logContext.put("database", db.getJdbcUrl());
                    logContext.put("schema", schemaName);
                    logContext.put("tableName", tableName);
                    throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
                }
            }
            rs.close();
            return bl;
        }
        finally {
            conn.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listTables(Database db, String schemaName) throws WAStorageException {
        LOGGER.debug("listTables() called [database='{}', schema='{}']", (Object)db.getJdbcUrl(), (Object)schemaName);
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            ArrayList<String> arrayList;
            Connection sqlConn = conn.getSqlConnection();
            ResultSet rs = sqlConn.getMetaData().getTables(null, schemaName, null, null);
            try {
                ArrayList<String> tables = new ArrayList<String>();
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                LOGGER.debug("Tables returned: {}", (Object)((Object)tables).toString());
                arrayList = tables;
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    HashMap<String, Object> logContext = new HashMap<String, Object>();
                    logContext.put("database", db.getJdbcUrl());
                    logContext.put("schema", schemaName);
                    throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
                }
            }
            rs.close();
            return arrayList;
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public void createTable(Database db, Table tbl) throws WAStorageException {
        LOGGER.debug("createTable() called [database='{}'] with definition: {}", (Object)db.getJdbcUrl(), (Object)tbl.toString());
        String sql = this.renderCreateTableStatement(db, tbl);
        this.executeUpdate(db, sql);
    }

    @Override
    public IBulkLoader createBulkLoader(Database db, Table table) throws WAStorageException {
        return this.createBulkLoader(db, table, -1L);
    }

    @Override
    public IBulkLoader createBulkLoader(Database db, Table table, long expectedRowCount) throws WAStorageException {
        boolean forceJdbc;
        LOGGER.debug("createBulkLoader() called [database='{}', schema='{}', table='{}', expectedRowCount={}]", new Object[]{db.getJdbcUrl(), table.getSchemaName(), table.getTableName(), expectedRowCount});
        boolean bl = forceJdbc = this.mForceJdbcInsert || expectedRowCount > 0L && expectedRowCount <= 20000L;
        if (!forceJdbc && StringUtils.isNotEmpty((String)db.getDashDbUrl())) {
            return new DashDbLoader(this, this.mHttpClient, db, table, this.mConfiguration);
        }
        if (!forceJdbc && StringUtils.isNotEmpty((String)db.getDb2BdmUrl())) {
            return new Db2BdmLoader(db, table, this.mConfiguration);
        }
        return new Db2JdbcLoader(this, db, table, this.mConfiguration, EXCEPTION_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Database db, String sql) throws WAStorageException {
        LOGGER.debug("executeUpdate() called [database='{}'] with SQL: {}", (Object)db.getJdbcUrl(), (Object)sql);
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            Connection sqlConn = conn.getSqlConnection();
            try (Statement statement = sqlConn.createStatement(1003, 1007, 2);){
                statement.execute(sql);
            }
        }
        catch (SQLException ex) {
            HashMap<String, Object> logContext = new HashMap<String, Object>();
            logContext.put("database", db.getJdbcUrl());
            logContext.put("sql", sql);
            throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
        }
        finally {
            conn.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRowReader executeQuery(Database db, String sql) throws WAStorageException {
        LOGGER.debug("executeQuery() called [database='{}'] with SQL: {}", (Object)db.getJdbcUrl(), (Object)sql);
        IPooledConnection conn = this.borrowConnectionTo(db);
        boolean success = false;
        try {
            JdbcResultSetReader jdbcResultSetReader;
            block10: {
                Connection sqlConn = conn.getSqlConnection();
                Statement statement = sqlConn.createStatement(1003, 1007, 2);
                try {
                    ResultSet rs = statement.executeQuery(sql);
                    JdbcResultSetReader reader = new JdbcResultSetReader(conn, new Db2ExceptionHandler(), db, statement, rs);
                    success = true;
                    jdbcResultSetReader = reader;
                    if (success) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (!success) {
                            statement.close();
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        HashMap<String, Object> logContext = new HashMap<String, Object>();
                        logContext.put("database", db.getJdbcUrl());
                        logContext.put("sql", sql);
                        throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
                    }
                }
                statement.close();
            }
            return jdbcResultSetReader;
        }
        finally {
            if (!success) {
                conn.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(Database db, String sql) throws WAStorageException {
        LOGGER.debug("executeUpdate() called [database='{}'] with SQL: {}", (Object)db.getJdbcUrl(), (Object)sql);
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            int n;
            Connection sqlConn = conn.getSqlConnection();
            Statement statement = sqlConn.createStatement();
            try {
                int rowsAffected = statement.executeUpdate(sql);
                LOGGER.debug("Update affected {} rows", (Object)rowsAffected);
                n = rowsAffected;
            }
            catch (Throwable throwable) {
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    HashMap<String, Object> logContext = new HashMap<String, Object>();
                    logContext.put("database", db.getJdbcUrl());
                    logContext.put("sql", sql);
                    throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
                }
            }
            statement.close();
            return n;
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public void executeCall(Database db, String sql, CallParameter ... params) throws WAStorageException {
        this.executeCall(db, sql, (IResultSetHandler)null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCall(Database db, String sql, IResultSetHandler resultSetHandler, CallParameter ... params) throws WAStorageException {
        LOGGER.debug("executeCall() called [database='{}', sql='{}', params={}]", new Object[]{db.getJdbcUrl(), sql, Arrays.toString(params)});
        IPooledConnection conn = this.borrowConnectionTo(db);
        try {
            Connection sqlConn = conn.getSqlConnection();
            try (CallableStatement statement = sqlConn.prepareCall(sql);){
                for (CallParameter p : params) {
                    if (p.isInput()) {
                        if (null != p.getName()) {
                            statement.setObject(p.getName(), p.getValue());
                        } else {
                            statement.setObject(p.getIndex(), p.getValue());
                        }
                    }
                    if (!p.isOutput()) continue;
                    if (null != p.getName()) {
                        statement.registerOutParameter(p.getName(), p.getDataType().getBaseType());
                        continue;
                    }
                    statement.registerOutParameter(p.getIndex(), p.getDataType().getBaseType());
                }
                statement.execute();
                for (CallParameter p : params) {
                    if (!p.isOutput()) continue;
                    if (null != p.getName()) {
                        p.setValue(statement.getObject(p.getName()));
                        continue;
                    }
                    p.setValue(statement.getObject(p.getIndex()));
                }
                if (null != resultSetHandler) {
                    ResultSet rs = statement.getResultSet();
                    while (null != rs) {
                        resultSetHandler.onResultSet(new JdbcResultSetReader(null, EXCEPTION_HANDLER, db, null, rs));
                        if (statement.getMoreResults()) {
                            rs = statement.getResultSet();
                            continue;
                        }
                        rs = null;
                    }
                }
            }
        }
        catch (SQLException ex) {
            HashMap<String, Object> logContext = new HashMap<String, Object>();
            logContext.put("database", db.getJdbcUrl());
            logContext.put("sql", sql);
            throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
        }
        finally {
            conn.returnToPool();
        }
    }

    @Override
    public void dropTable(Database db, String schemaName, String tableName) throws WAStorageException {
        this.dropTable(db, schemaName, tableName, 0);
    }

    @Override
    public void dropTable(Database db, String schemaName, String tableName, int timeoutSeconds) throws WAStorageException {
        LOGGER.debug("dropTable() called [database='{}', schema='{}', table='{}', timeoutSeconds={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, timeoutSeconds});
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String sql = "DROP TABLE " + tableQName;
        IPooledConnection conn = this.borrowConnectionTo(db);
        Connection sqlConn = conn.getSqlConnection();
        try (Statement statement = sqlConn.createStatement();){
            if (timeoutSeconds > 0) {
                statement.setQueryTimeout(timeoutSeconds);
            }
            statement.execute(sql);
        }
        catch (SQLException ex) {
            HashMap<String, Object> logContext = new HashMap<String, Object>();
            logContext.put("database", db.getJdbcUrl());
            logContext.put("sql", sql);
            throw EXCEPTION_HANDLER.handleSQLException(conn, ex, logContext, db.getId(), LOGGER);
        }
        finally {
            conn.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropSchema(Database db, String schemaName) throws WAStorageException {
        LOGGER.info("dropSchema() called [database='{}', schema='{}']", (Object)db.getJdbcUrl(), (Object)schemaName);
        String errorTableName = schemaName + "_" + UUID.randomUUID().toString();
        CallParameter schemaParam = CallParameter.newInput(1, (Object)schemaName);
        CallParameter dropMode = CallParameter.newInput(2, null);
        CallParameter errorTabSchemaParam = CallParameter.newInputOutput(3, SQLDataType.getVarChar((int)128), (Object)DROP_SCHEMA_ERROR_SCHEMA_NAME);
        CallParameter errorTabParam = CallParameter.newInputOutput(4, SQLDataType.getVarChar((int)128), (Object)errorTableName);
        this.executeCall(db, "CALL SYSPROC.ADMIN_DROP_SCHEMA(?,?,?,?)", schemaParam, dropMode, errorTabSchemaParam, errorTabParam);
        if (errorTabParam.getValue() == null) {
            return true;
        }
        try {
            boolean bl;
            IRowReader reader = this.executeQuery(db, "SELECT SQLCODE, SQLSTATE, CAST(DIAGTEXT AS VARCHAR(4096)) FROM \"DROP_SCHEMA_ERRORS\".\"" + errorTableName + "\"");
            try {
                StringBuilder sb = new StringBuilder();
                IValue[] row = new IValue[reader.getColumnCount()];
                while (reader.hasMore()) {
                    row = reader.read(row);
                    sb.append("> SqlCode: ").append(row[0].toString()).append(", SqlState: ").append(row[1].toString()).append(", DiagText: ").append(row[2].toString());
                    sb.append("\n");
                }
                LOGGER.error("Failed to drop schema [database='{}', schema='{}']. Some objects could not be dropped.\n{}", new Object[]{db.getJdbcUrl(), schemaName, sb.toString()});
                bl = false;
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return bl;
        }
        finally {
            this.dropTable(db, DROP_SCHEMA_ERROR_SCHEMA_NAME, errorTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTableRowCount(Database db, String schemaName, String tableName, JoinPath[] joinFilters) throws WAStorageException {
        LOGGER.debug("getTableRowCount() called [database='{}', schema='{}', table='{}', joins={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, Arrays.toString(joinFilters)});
        TableAliasMap aliasMap = new TableAliasMap();
        StringBuilder sql = new StringBuilder();
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String tableAlias = aliasMap.getOrCreateAlias(tableQName);
        sql.append("SELECT COUNT(*) FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
        if (null != joinFilters) {
            for (JoinPath jp : joinFilters) {
                Db2BluAccessor.appendJoin(sql, jp, aliasMap);
            }
        }
        try (IRowReader reader = this.executeQuery(db, sql.toString());){
            IValue[] row = reader.read(new IValue[1]);
            Assertions.assertNotNull((Object)row);
            long rowCount = row[0].longValue();
            LOGGER.debug("Table has {} rows", (Object)rowCount);
            long l = rowCount;
            return l;
        }
    }

    @Override
    public ColumnStats[] getTableColumnStats(Database db, String schemaName, String tableName, String[] columnNames, JoinPath[] joinFilters) throws WAStorageException {
        int i;
        if (columnNames.length == 0) {
            return new ColumnStats[0];
        }
        LOGGER.debug("getTableColumnStats() called [database='{}', schema='{}', table='{}', columns={}, joins={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, Arrays.toString(columnNames), Arrays.toString(joinFilters)});
        ColumnStats[] stats = new ColumnStats[columnNames.length];
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            stats[i2] = new ColumnStats();
        }
        DatabaseLimits dbLimits = this.getDatabaseLimits(db);
        int start = 0;
        int numColumnsLeft = columnNames.length;
        while (numColumnsLeft > 0) {
            int numColumnsToFetch = numColumnsLeft;
            if (numColumnsToFetch > dbLimits.getMaxColumnsInSelect() / 3) {
                numColumnsToFetch = dbLimits.getMaxColumnsInSelect() / 3;
            }
            this.selectCountMinMax(db, schemaName, tableName, columnNames, joinFilters, stats, start, numColumnsToFetch);
            numColumnsLeft -= numColumnsToFetch;
            start += numColumnsToFetch;
        }
        for (i = 0; i < columnNames.length; ++i) {
            stats[i].setDistinctCount(this.getColumnDistinctCount(db, schemaName, tableName, columnNames[i], joinFilters));
        }
        for (i = 0; i < columnNames.length; ++i) {
            LOGGER.debug("Stats for column '{}': {}", (Object)stats[i]);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCountMinMax(Database db, String schemaName, String tableName, String[] columnNames, JoinPath[] joinFilters, ColumnStats[] stats, int start, int count) throws WAStorageException {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start < 0");
        }
        if (count < 1) {
            return;
        }
        if (start + count > columnNames.length) {
            throw new IndexOutOfBoundsException("start + count > columnNames.length");
        }
        TableAliasMap aliasMap = new TableAliasMap();
        StringBuilder sql = new StringBuilder();
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String tableAlias = aliasMap.getOrCreateAlias(tableQName);
        String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, columnNames[start]);
        sql.append("SELECT COUNT(").append(columnQName).append(")").append(", MIN(").append(columnQName).append(")").append(", MAX(").append(columnQName).append(")");
        for (int i = 1; i < count; ++i) {
            columnQName = IdentifierUtil.makeQualifiedName(tableAlias, columnNames[start + i]);
            sql.append(", COUNT(").append(columnQName).append(")").append(", MIN(").append(columnQName).append(")").append(", MAX(").append(columnQName).append(")");
        }
        sql.append(" FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
        if (null != joinFilters) {
            for (JoinPath jp : joinFilters) {
                Db2BluAccessor.appendJoin(sql, jp, aliasMap);
            }
        }
        try (IRowReader reader = this.executeQuery(db, sql.toString());){
            IValue[] row = reader.read(new IValue[3 * count]);
            Assertions.assertNotNull((Object)row);
            for (int i = 0; i < count; ++i) {
                stats[i + start].setNonNullCount(row[i * 3].longValue());
                stats[i + start].setMin(row[i * 3 + 1].objectValue());
                stats[i + start].setMax(row[i * 3 + 2].objectValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getColumnDistinctCount(Database db, String schemaName, String tableName, String columnName, JoinPath[] joinFilters) throws WAStorageException {
        LOGGER.debug("getColumnDistinctCount() called [database='{}', schema='{}', table='{}', column={}, joins={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, columnName, Arrays.toString(joinFilters)});
        TableAliasMap aliasMap = new TableAliasMap();
        StringBuilder sql = new StringBuilder();
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String tableAlias = aliasMap.getOrCreateAlias(tableQName);
        String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, columnName);
        sql.append("SELECT COUNT(DISTINCT ").append(columnQName).append(") FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
        if (null != joinFilters) {
            for (JoinPath jp : joinFilters) {
                Db2BluAccessor.appendJoin(sql, jp, aliasMap);
            }
        }
        try (IRowReader reader = this.executeQuery(db, sql.toString());){
            IValue[] row = reader.read(new IValue[1]);
            Assertions.assertNotNull((Object)row);
            long l = row[0].longValue();
            return l;
        }
    }

    @Override
    public IRowReader getColumnDistinctValues(Database db, String schemaName, String tableName, String columnName, double sampleRate, int sampleSeed, int sampleLimit, JoinPath[] joinFilters) throws WAStorageException {
        if (sampleRate <= 0.0 || sampleRate > 1.0) {
            throw new IllegalArgumentException("sampleRate was outside of range (0.0, 1.0]");
        }
        LOGGER.debug("getColumnDistinctValues() called [database='{}', schema='{}', table='{}', column={}, sampleRate={}, sampleSeed={}, sampleLimit={}, joins={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, columnName, sampleRate, sampleSeed, sampleLimit, Arrays.toString(joinFilters)});
        TableAliasMap aliasMap = new TableAliasMap();
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String tableAlias = aliasMap.getOrCreateAlias(tableQName);
        StringBuilder sql = new StringBuilder();
        String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, columnName);
        sql.append("SELECT DISTINCT ").append(columnQName);
        sql.append(" FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
        if (sampleRate < 1.0) {
            sql.append(" TABLESAMPLE BERNOULLI(").append(Math.max(1, (int)Math.round(100.0 * sampleRate))).append(")").append(" REPEATABLE(").append(sampleSeed).append(")");
        }
        if (null != joinFilters) {
            for (JoinPath jp : joinFilters) {
                Db2BluAccessor.appendJoin(sql, jp, aliasMap);
            }
        }
        if (sampleLimit > 0) {
            sql.append(" FETCH FIRST ").append(sampleLimit).append(" ROWS ONLY");
        }
        return this.executeQuery(db, sql.toString());
    }

    @Override
    public IRowReader getTableSample(Database db, String schemaName, String tableName, String[] projectedColumns, String[] orderByColumns, EOrderByDirection[] orderByDirections, String[] groupByColumns, String groupByAggr, double sampleRate, int sampleSeed, int sampleLimit, JoinPath[] joinFilters) throws WAStorageException {
        boolean isOrderedByRowId;
        boolean isGrouping;
        if (sampleRate <= 0.0 || sampleRate > 1.0) {
            throw new IllegalArgumentException("sampleRate was outside of range (0.0, 1.0]");
        }
        boolean bl = isGrouping = null != groupByColumns && groupByColumns.length > 0;
        if (isGrouping) {
            if (StringUtils.isEmpty((String)groupByAggr)) {
                throw new IllegalArgumentException("groupByAggr was empty");
            }
            groupByAggr = groupByAggr.toUpperCase();
        }
        LOGGER.debug("getTableSample() called [database='{}', schema='{}', table='{}', projectedColumns={}, orderByColumns={}, orderByDirections={},groupByColumns={}, groupByAggr={},sampleRate={}, sampleSeed={}, sampleLimit={}, joins={}]", new Object[]{db.getJdbcUrl(), schemaName, tableName, Arrays.toString(projectedColumns), Arrays.toString(orderByColumns), Arrays.toString((Object[])orderByDirections), Arrays.toString(groupByColumns), groupByAggr, sampleRate, sampleSeed, sampleLimit, Arrays.toString(joinFilters)});
        TableAliasMap aliasMap = new TableAliasMap();
        String tableQName = IdentifierUtil.makeQualifiedName(schemaName, tableName);
        String tableAlias = aliasMap.getOrCreateAlias(tableQName);
        StringBuilder sql = new StringBuilder();
        boolean bl2 = isOrderedByRowId = null != orderByColumns && orderByColumns.length == 1 && orderByColumns[0].equals(ROW_ID);
        if (!isGrouping && sampleRate < 1.0 && isOrderedByRowId) {
            String nestedQueryName = "SAMPLE";
            sql.append("WITH \"").append("SAMPLE").append("\" AS (");
            sql.append("SELECT ");
            sql.append("\"").append(orderByColumns[0]).append("\"");
            sql.append(" FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
            this.appendSampling(sql, sampleRate, sampleSeed);
            this.appendOrderBy(sql, tableAlias, isGrouping, orderByColumns, orderByDirections, groupByColumns, groupByAggr);
            if (sampleLimit > 0) {
                sql.append(" FETCH FIRST ").append(sampleLimit).append(" ROWS ONLY");
            }
            sql.append(") ");
            String tableAliasOuter = aliasMap.getOrCreateAlias(tableQName);
            String tableAliasSample = aliasMap.getOrCreateAlias("SAMPLE");
            sql.append("SELECT ");
            this.appendProjectedColumns(sql, tableAliasOuter, projectedColumns, isGrouping, groupByColumns, groupByAggr);
            sql.append(" FROM ").append("SAMPLE").append(" AS \"").append(tableAliasSample).append("\", ");
            sql.append(tableQName).append(" AS \"").append(tableAliasOuter).append("\"");
            String tableOuterRowId = IdentifierUtil.makeQualifiedName(tableAliasOuter, ROW_ID);
            String tableSampleRowId = IdentifierUtil.makeQualifiedName(tableAliasSample, ROW_ID);
            sql.append(" WHERE ").append(tableOuterRowId).append(" = ").append(tableSampleRowId);
            sql.append(" FOR READ ONLY");
        } else {
            sql.append("SELECT ");
            this.appendProjectedColumns(sql, tableAlias, projectedColumns, isGrouping, groupByColumns, groupByAggr);
            sql.append(" FROM ").append(tableQName).append(" AS \"").append(tableAlias).append("\"");
            if (sampleRate < 1.0) {
                this.appendSampling(sql, sampleRate, sampleSeed);
            }
            if (isGrouping) {
                sql.append(" GROUP BY ");
                for (int i = 0; i < groupByColumns.length; ++i) {
                    String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, groupByColumns[i]);
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append(columnQName);
                }
            }
            if (null != orderByColumns && orderByColumns.length > 0) {
                this.appendOrderBy(sql, tableAlias, isGrouping, orderByColumns, orderByDirections, groupByColumns, groupByAggr);
            }
            if (null != joinFilters) {
                for (JoinPath jp : joinFilters) {
                    Db2BluAccessor.appendJoin(sql, jp, aliasMap);
                }
            }
            if (sampleLimit > 0) {
                sql.append(" FETCH FIRST ").append(sampleLimit).append(" ROWS ONLY");
            }
            sql.append(" FOR READ ONLY");
        }
        return this.executeQuery(db, sql.toString());
    }

    private void appendOrderBy(StringBuilder sql, String tableAlias, boolean isGrouping, String[] orderByColumns, EOrderByDirection[] orderByDirections, String[] groupByColumns, String groupByAggr) {
        sql.append(" ORDER BY ");
        for (int i = 0; i < orderByColumns.length; ++i) {
            String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, orderByColumns[i]);
            if (i > 0) {
                sql.append(", ");
            }
            if (isGrouping && !ArrayUtils.contains((Object[])groupByColumns, (Object)orderByColumns[i])) {
                sql.append("\"").append(groupByAggr).append("_").append(orderByColumns[i]).append("\"");
            } else {
                sql.append(columnQName);
            }
            if (EOrderByDirection.ASCENDING == orderByDirections[i]) {
                sql.append(" ASC");
                continue;
            }
            if (EOrderByDirection.DESCENDING != orderByDirections[i]) continue;
            sql.append(" DESC");
        }
    }

    private void appendSampling(StringBuilder sql, double sampleRate, int sampleSeed) {
        sql.append(" TABLESAMPLE BERNOULLI(").append((int)Math.ceil(sampleRate * 100.0)).append(")").append(" REPEATABLE(").append(sampleSeed).append(")");
    }

    private void appendProjectedColumns(StringBuilder sql, String tableAlias, String[] projectedColumns, boolean isGrouping, String[] groupByColumns, String groupByAggr) {
        for (int i = 0; i < projectedColumns.length; ++i) {
            String columnQName = IdentifierUtil.makeQualifiedName(tableAlias, projectedColumns[i]);
            if (i > 0) {
                sql.append(", ");
            }
            if (isGrouping && !ArrayUtils.contains((Object[])groupByColumns, (Object)projectedColumns[i])) {
                sql.append(groupByAggr).append('(').append(columnQName).append(") AS \"").append(groupByAggr).append("_").append(projectedColumns[i]).append("\"");
                continue;
            }
            sql.append(columnQName);
        }
    }

    @Override
    public int copyTable(Database db, String fromSchemaName, String fromTableName, String toSchemaName, String toTableName) throws WAStorageException {
        LOGGER.debug("copyTable() called [database='{}', fromSchema='{}', fromTable='{}', toSchema='{}', toTable='{}']", new Object[]{db.getJdbcUrl(), fromSchemaName, fromTableName, toSchemaName, toTableName});
        String fromTableQName = IdentifierUtil.makeQualifiedName(fromSchemaName, fromTableName);
        String toTableQName = IdentifierUtil.makeQualifiedName(toSchemaName, toTableName);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(toTableQName).append(" SELECT * FROM ").append(fromTableQName);
        return this.executeUpdate(db, sql.toString());
    }

    @Override
    public void dispose() {
        this.mConnPool.shutdown();
        if (this.mHttpClient instanceof Closeable) {
            try {
                ((Closeable)this.mHttpClient).close();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to close HttpClient", (Throwable)ex);
            }
        }
    }

    @Override
    public IPooledConnection borrowConnectionTo(Database db) throws WAStorageException {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put(URL, db.getJdbcUrl());
        params.put(USER, db.getUser());
        params.put(PASSWORD, new SecretParameter(db.getPassword()));
        params.put(SSL_CONNECTION, db.isSSLEnabled());
        Map extraConnectionProps = db.getConnectionProps();
        if (null != extraConnectionProps && !extraConnectionProps.isEmpty()) {
            params.put(EXTRA_CONNECTION_PROPS, extraConnectionProps);
        }
        if (db.getExtendedFields().getBoolean("allow-read-uncommitted", false)) {
            params.put(ISOLATION_LEVEL, 1);
        }
        try {
            return this.mConnPool.borrow(params);
        }
        catch (WAStorageException e) {
            if (e.getDatabaseId() == null && db.getId() != null) {
                e.getWatsonMessageContext().putItemIfNotNull((Enum)EImportMessageContext.DATABASE_ID, (Object)db.getId().getIdentifier());
            }
            throw e;
        }
    }

    private boolean isTablespaceStripingEnabled(Database db) {
        return db.getExtendedFields().getBoolean("tablespace-striping-enabled", this.mTablespaceStriping);
    }

    private String getTablespaceStripingPrefix(Database db) {
        return db.getExtendedFields().getString("tablespace-striping-prefix", this.mTablespaceStripingPrefix);
    }

    private int getTablespaceStripingSize(Database db) {
        return db.getExtendedFields().getInt("tablespace-striping-size", this.mTablespaceStripingSize);
    }

    private String renderCreateTableStatement(Database db, Table table) {
        StringBuilder sql = new StringBuilder();
        String tableQName = IdentifierUtil.makeQualifiedName(table.getSchemaName(), table.getTableName());
        boolean firstElement = true;
        sql.append("CREATE TABLE ").append(tableQName).append(" (");
        for (Column c : table.getColumns()) {
            if (firstElement) {
                firstElement = false;
            } else {
                sql.append(", ");
            }
            this.appendTableElement(sql, c);
            if (!c.isPrimaryKey()) continue;
            sql.append(" NOT NULL, PRIMARY KEY (\"").append(c.getColumnName()).append("\")");
        }
        sql.append(')');
        if (EOrganizedBy.COLUMN == table.getOrganizedBy()) {
            sql.append(" ORGANIZE BY COLUMN");
        } else if (EOrganizedBy.ROW == table.getOrganizedBy()) {
            sql.append(" ORGANIZE BY ROW");
        }
        if (this.isTablespaceStripingEnabled(db)) {
            int hash = tableQName.hashCode();
            if (hash == Integer.MIN_VALUE) {
                hash = 0;
            } else if (hash < 0) {
                hash = -hash;
            }
            int stripeIndex = hash % this.getTablespaceStripingSize(db);
            String tablespaceName = this.getTablespaceStripingPrefix(db) + stripeIndex;
            sql.append(" IN \"").append(tablespaceName).append("\"");
        }
        return sql.toString();
    }

    private void appendTableElement(StringBuilder sb, Column column) {
        sb.append("\"").append(column.getColumnName()).append("\" ").append(Db2BluAccessor.toSQLTypeName(column.getDataType()));
    }

    private static void appendJoin(StringBuilder sb, JoinPath jp, TableAliasMap aliasMap) {
        String primaryTableQName = IdentifierUtil.makeQualifiedName(jp.getPrimarySchemaName(), jp.getPrimaryTableName());
        String foreignTableQName = IdentifierUtil.makeQualifiedName(jp.getForeignSchemaName(), jp.getForeignTableName());
        String primaryTableAlias = aliasMap.getOrCreateAlias(primaryTableQName);
        String foreignTableAlias = aliasMap.getOrCreateAlias(foreignTableQName);
        switch (jp.getJoinType()) {
            case INNER_JOIN: {
                sb.append(" INNER JOIN ");
                break;
            }
            case LEFT_JOIN: {
                sb.append(" LEFT JOIN ");
                break;
            }
            case RIGHT_JOIN: {
                sb.append(" RIGHT JOIN ");
                break;
            }
            case FULL_OUTER_JOIN: {
                sb.append(" FULL OUTER JOIN ");
                break;
            }
            default: {
                throw new IllegalArgumentException(jp.getJoinType().toString());
            }
        }
        sb.append(foreignTableQName).append(" AS \"").append(foreignTableAlias).append("\" ON ");
        if (null != jp.getPrimaryCast()) {
            sb.append("CAST(");
        }
        sb.append("\"").append(primaryTableAlias).append("\".\"").append(jp.getPrimaryColumnName()).append("\"");
        if (null != jp.getPrimaryCast()) {
            sb.append(" AS ").append(Db2BluAccessor.toSQLTypeName(jp.getPrimaryCast())).append(")");
        }
        sb.append(" = ");
        if (null != jp.getForeignCast()) {
            sb.append("CAST(");
        }
        sb.append("\"").append(foreignTableAlias).append("\".\"").append(jp.getForeignColumnName()).append("\"");
        if (null != jp.getForeignCast()) {
            sb.append(" AS ").append(Db2BluAccessor.toSQLTypeName(jp.getForeignCast())).append(")");
        }
    }

    private static String toSQLTypeName(SQLDataType dataType) {
        switch (dataType.getBaseType()) {
            case -5: {
                return "BIGINT";
            }
            case 1: {
                return String.format("CHAR(%d)", (Integer)dataType.getParams()[0]);
            }
            case -15: {
                return String.format("NCHAR(%d)", (Integer)dataType.getParams()[0]);
            }
            case 2005: {
                return "CLOB";
            }
            case 2011: {
                return "NCLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return String.format("DECIMAL(%d, %d)", dataType.getParams()[0], dataType.getParams()[1]);
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case 7: {
                return "REAL";
            }
            case -6: 
            case 5: 
            case 16: {
                return "SMALLINT";
            }
            case 93: {
                if (dataType.getParams().length == 0) {
                    return "TIMESTAMP";
                }
                return String.format("TIMESTAMP(%d)", dataType.getParams()[0]);
            }
            case 92: {
                if (dataType.getParams().length == 0) {
                    return "TIME";
                }
                return String.format("TIME(%d)", dataType.getParams()[0]);
            }
            case 12: {
                return String.format("VARCHAR(%d)", (Integer)dataType.getParams()[0]);
            }
            case -9: {
                return String.format("NVARCHAR(%d)", (Integer)dataType.getParams()[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported SQLDataType: " + dataType);
    }

    private static final class ConnectionSelector
    implements IConnectionSelector {
        private final boolean mDisableReuse;

        public ConnectionSelector(boolean disableReuse) {
            this.mDisableReuse = disableReuse;
        }

        @Override
        public boolean canSelect(IPooledConnection connection, Map<String, Object> parameters) {
            return ConnectionSelector.isEqual(connection.getParameters().get(Db2BluAccessor.URL), parameters.get(Db2BluAccessor.URL)) && ConnectionSelector.isEqual(connection.getParameters().get(Db2BluAccessor.USER), parameters.get(Db2BluAccessor.USER)) && ConnectionSelector.isEqual(connection.getParameters().get(Db2BluAccessor.PASSWORD), parameters.get(Db2BluAccessor.PASSWORD)) && ConnectionSelector.isEqual(connection.getParameters().get(Db2BluAccessor.SSL_CONNECTION), parameters.get(Db2BluAccessor.SSL_CONNECTION));
        }

        @Override
        public void prepareForBorrow(IPooledConnection connection) throws WAStorageException {
            Connection sqlConn = connection.getSqlConnection();
            try {
                sqlConn.setAutoCommit(true);
            }
            catch (SQLException ex) {
                throw EXCEPTION_HANDLER.handleSQLException(connection, ex, null, LOGGER);
            }
        }

        @Override
        public void prepareForReturn(IPooledConnection connection) throws WAStorageException {
            if (this.mDisableReuse) {
                connection.invalidate();
            }
        }

        private static boolean isEqual(Object left, Object right) {
            if (null == left) {
                return null == right;
            }
            if (null == right) {
                return false;
            }
            return left.equals(right);
        }
    }

    private static final class ConnectionFactory
    implements IConnectionFactory {
        private ConnectionFactory() {
        }

        @Override
        public Connection create(Map<String, Object> parameters) throws WAStorageException {
            String url = (String)parameters.get(Db2BluAccessor.URL);
            String user = (String)parameters.get(Db2BluAccessor.USER);
            String password = (String)((SecretParameter)parameters.get(Db2BluAccessor.PASSWORD)).getSecret();
            Boolean sslConnection = (Boolean)parameters.get(Db2BluAccessor.SSL_CONNECTION);
            Integer isolationLevel = (Integer)parameters.get(Db2BluAccessor.ISOLATION_LEVEL);
            Map extraConnectionProps = (Map)parameters.get(Db2BluAccessor.EXTRA_CONNECTION_PROPS);
            LOGGER.info("Creating new connection [{}]", parameters);
            try {
                Properties connProps = new Properties();
                if (null != user) {
                    connProps.put(Db2BluAccessor.USER, user);
                }
                if (null != password) {
                    connProps.put(Db2BluAccessor.PASSWORD, password);
                }
                if (Boolean.TRUE.equals(sslConnection)) {
                    connProps.put(Db2BluAccessor.SSL_CONNECTION, "true");
                }
                connProps.put(Db2BluAccessor.LOGIN_TIMEOUT, "60");
                connProps.put(Db2BluAccessor.BLOCKING_READ_CONNECTION_TIMEOUT, "600");
                connProps.put(Db2BluAccessor.COMMAND_TIMEOUT, "600");
                connProps.put(Db2BluAccessor.RETRIEVE_MESSAGES_FROM_SERVER_ON_GET_MESSAGE, "true");
                if (null != extraConnectionProps) {
                    for (Map.Entry e : extraConnectionProps.entrySet()) {
                        connProps.put(e.getKey(), String.valueOf(e.getValue()));
                    }
                }
                Connection conn = DriverManager.getConnection(url, connProps);
                if (null != isolationLevel) {
                    conn.setTransactionIsolation(isolationLevel);
                }
                return conn;
            }
            catch (SQLException ex) {
                HashMap<String, Object> logContext = new HashMap<String, Object>();
                logContext.put("database", url);
                logContext.put(Db2BluAccessor.USER, user);
                logContext.put(Db2BluAccessor.SSL_CONNECTION, sslConnection);
                logContext.put(Db2BluAccessor.EXTRA_CONNECTION_PROPS, extraConnectionProps);
                throw EXCEPTION_HANDLER.handleSQLException(null, ex, logContext, LOGGER);
            }
        }
    }
}

