/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.storage.SQLExceptionHandler;
import com.ibm.neo.dataimport.storage.connection.IPooledConnection;
import com.ibm.neo.persist.ion.IONObjectId;
import java.sql.SQLException;
import java.util.Map;

public class Db2ExceptionHandler
extends SQLExceptionHandler {
    public Db2ExceptionHandler() {
    }

    public Db2ExceptionHandler(Map<String, Object> defaultContext) {
        super(defaultContext);
    }

    @Override
    protected WAStorageException convertSQLException(IPooledConnection connection, SQLException ex) {
        return this.convertSQLException(connection, ex, null);
    }

    @Override
    protected WAStorageException convertSQLException(IPooledConnection connection, SQLException ex, IONObjectId databaseId) {
        Object storageEx;
        boolean invalidateConnection = false;
        if (ex.getClass().getName().equals("com.ibm.db2.jcc.am.DisconnectNonTransientException")) {
            invalidateConnection = true;
            storageEx = new WAStorageException.ConnectionFailure("DB2 Connection Failure, please log into the firewall.", (Throwable)ex, databaseId);
        } else {
            switch (ex.getErrorCode()) {
                case -601: {
                    storageEx = new WAStorageException.DuplicateNameException(ex.getMessage(), (Throwable)ex, databaseId);
                    break;
                }
                case -670: {
                    storageEx = new WAStorageException.TableRowLengthExceeded(databaseId);
                    break;
                }
                case -206: 
                case -205: 
                case -204: {
                    storageEx = new WAStorageException.NoSuchObjectException(ex.getMessage(), (Throwable)ex, databaseId);
                    break;
                }
                case -981: 
                case -924: 
                case -923: 
                case -918: 
                case -900: {
                    invalidateConnection = true;
                    storageEx = new WAStorageException.ConnectionFailure(ex.getMessage(), (Throwable)ex, databaseId);
                    break;
                }
                case -3011: 
                case -959: 
                case -956: 
                case -955: 
                case -954: 
                case -904: {
                    invalidateConnection = true;
                    storageEx = new WAStorageException.ResourceExhaustion((Throwable)ex, databaseId);
                    break;
                }
                case -4470: {
                    invalidateConnection = true;
                    storageEx = new WAStorageException.JDBCException(ex.getMessage(), ex, databaseId);
                    break;
                }
                case -4499: {
                    invalidateConnection = true;
                    storageEx = new WAStorageException.ConnectionFailure(ex.getMessage(), (Throwable)ex, databaseId);
                    break;
                }
                default: {
                    storageEx = super.convertSQLException(connection, ex, databaseId);
                }
            }
        }
        if (invalidateConnection && null != connection) {
            connection.invalidate();
        }
        return storageEx;
    }
}

