/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.JdbcLoader;
import com.ibm.neo.dataimport.storage.SQLExceptionHandler;
import com.ibm.neo.dataimport.storage.util.IdentifierUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class Db2JdbcLoader
extends JdbcLoader {
    public Db2JdbcLoader(IDatabaseAccessor accessor, Database db, Table table, Properties configuration, SQLExceptionHandler errorHandler) throws WAStorageException {
        super(accessor, db, table, configuration, errorHandler);
    }

    @Override
    protected void prepareConnection() throws WAStorageException {
        super.prepareConnection();
        if (this.mTable.getOrganizedBy() == EOrganizedBy.ROW) {
            this.activateTableNotLoggedInitially();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateTableNotLoggedInitially() throws WAStorageException {
        String tableQName = IdentifierUtil.makeQualifiedName(this.mTable.getSchemaName(), this.mTable.getTableName());
        String sql = "ALTER TABLE " + tableQName + " ACTIVATE NOT LOGGED INITIALLY";
        this.mLogContext.put("sql", sql);
        try (Statement stat = this.mConnection.getSqlConnection().createStatement();){
            stat.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw this.mErrorHandler.handleSQLException(this.mConnection, ex, this.mLogContext, this.mDb.getId(), LOGGER);
        }
        finally {
            this.mLogContext.remove("sql");
        }
    }
}

