/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.db2blu;

import com.ibm.neo.dataimport.storage.db2blu.EDictionaryOption;
import com.ibm.neo.dataimport.storage.db2blu.ELoadMode;

public abstract class LoadUtils {
    private static final int ANALYZE_SIZE_THRESHOLD = 500;
    private static final float ANALYZE_SIZE_SAMPLE_RATE = 0.2f;
    private static final String[] RESOURCE_EXHAUSTION_SQL_CODES = new String[]{"SQL3011C", "SQL0973N"};

    public static int chooseMaxAnalyzeSizeMB(long fileSizeBytes) {
        int inputSizeMB = (int)(fileSizeBytes / 1024L / 1024L);
        if (inputSizeMB > 500) {
            return Math.max(500, (int)((float)inputSizeMB * 0.2f));
        }
        return 500;
    }

    public static String getTableQName(String schemaName, String tableName) {
        if (null != schemaName) {
            return String.format("\"%s\".\"%s\"", schemaName, tableName);
        }
        return String.format("\"%s\"", tableName);
    }

    public static String generateLoadCommand(String filePath, boolean fastparse, int maxAnalyzeSizeMB, int dataBufferSizePages, int warningCount, boolean messagesOnServer, ELoadMode mode, EDictionaryOption dictionaryOption, String tableQName) {
        StringBuilder sb = new StringBuilder();
        sb.append("load from \"").append(filePath).append("\" of del modified by anyorder");
        if (fastparse) {
            sb.append(" fastparse");
        }
        sb.append(" codepage=1208");
        if (maxAnalyzeSizeMB > 0) {
            sb.append(" maxanalyzesize=").append(maxAnalyzeSizeMB).append("M");
        }
        if (warningCount > 0) {
            sb.append(" warningcount ").append(warningCount);
        }
        if (messagesOnServer) {
            sb.append(" messages on server");
        }
        if (mode == ELoadMode.REPLACE) {
            sb.append(" replace");
            if (null == dictionaryOption) {
                sb.append(" resetdictionary");
            } else {
                switch (dictionaryOption) {
                    case KEEP_DICTIONARY: {
                        sb.append(" keepdictionary");
                        break;
                    }
                    case RESET_DICTIONARY_ONLY: {
                        sb.append(" resetdictionaryonly");
                        break;
                    }
                    default: {
                        sb.append(" resetdictionary");
                        break;
                    }
                }
            }
        } else if (mode == ELoadMode.APPEND) {
            sb.append(" insert");
        }
        sb.append(" into ").append(tableQName);
        sb.append(" nonrecoverable without prompting");
        if (dataBufferSizePages > 0) {
            sb.append(" data buffer ").append(dataBufferSizePages);
        }
        sb.append(" cpu_parallelism 1");
        sb.append(" allow no access lock with force");
        return sb.toString();
    }

    public static boolean isResourceExhaustionSqlCode(String sqlCode) {
        for (String code : RESOURCE_EXHAUSTION_SQL_CODES) {
            if (!code.equals(sqlCode)) continue;
            return true;
        }
        return false;
    }
}

