/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.util;

import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.DeployJob;
import com.ibm.neo.metrics.GaugeMetric;
import com.ibm.neo.metrics.NameUtils;
import com.ibm.neo.persist.AggregationPipelineBuilder;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployJobTracker {
    private static final long RENEWAL_TASK_DELAY_SEC = 15L;
    private static final GaugeMetric METRIC_IMPORT_DEPLOY_JOBS_RUNNING = new GaugeMetric("import.deploy.%s.jobs_running");
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployJobTracker.class);
    private final NobjectCollection<Database> dbCol;
    private final NobjectCollection<DeployJob> deployJobCol;
    private final ConcurrentLinkedQueue<IONObjectId> localJobIds = new ConcurrentLinkedQueue();
    private final ScheduledFuture<?> renewTaskFuture;

    public DeployJobTracker(NobjectCollection<Database> dbCol, NobjectCollection<DeployJob> deployJobCol, ScheduledExecutorService scheduler) throws PersistenceException {
        this.dbCol = dbCol;
        this.deployJobCol = deployJobCol;
        this.renewTaskFuture = scheduler.scheduleWithFixedDelay(new ValidationTask(), 15L, 15L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.renewTaskFuture.cancel(true);
    }

    public long getJobCount(IONObjectId databaseId) throws PersistenceException {
        return this.deployJobCol.count(new QueryBuilder().equalTo("database-id", (Object)databaseId).toDocument());
    }

    public IONObjectId startJob(IONObjectId tenantId, IONObjectId datasetId, IONObjectId databaseId) throws PersistenceException {
        DeployJob job = new DeployJob();
        job.setCreatedDate(new Date());
        job.setValidatedDate(job.getCreatedDate());
        job.setTenantId(tenantId);
        job.setDatasetId(datasetId);
        job.setDatabaseId(databaseId);
        this.deployJobCol.insert((Nobject)job);
        this.localJobIds.add(job.getId());
        LOGGER.info("Started tracking deploy job (jobId={}, tenantId={}, datasetId={}, databaseId={})", new Object[]{job.getId().getIdentifier(), tenantId.getIdentifier(), datasetId.getIdentifier(), databaseId.getIdentifier()});
        return job.getId();
    }

    public void endJob(IONObjectId jobId) throws PersistenceException {
        this.localJobIds.remove(jobId);
        this.deployJobCol.remove(jobId);
        LOGGER.info("Stopped tracking deploy job (jobId={})", (Object)jobId.getIdentifier());
    }

    private static String getHostFromUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return "missing";
        }
        int pos = url.indexOf("//");
        if (-1 == pos) {
            return "missing";
        }
        String host = url.substring(pos + 2);
        if (-1 != (pos = host.indexOf(58))) {
            host = host.substring(0, pos);
        }
        if (-1 != (pos = host.indexOf(47))) {
            host = host.substring(0, pos);
        }
        return NameUtils.replacePeriods((String)host, (char)'-');
    }

    private final class ValidationTask
    implements Runnable {
        private final LinkedList<IONObjectId> jobIdsToValidate = new LinkedList();

        private ValidationTask() {
        }

        @Override
        public void run() {
            try {
                this.jobIdsToValidate.clear();
                this.jobIdsToValidate.addAll(DeployJobTracker.this.localJobIds);
                if (this.jobIdsToValidate.isEmpty()) {
                    return;
                }
                IDocumentCollection dbDocCol = DeployJobTracker.this.dbCol.getDocumentCollection();
                IDocumentCollection jobDocCol = DeployJobTracker.this.deployJobCol.getDocumentCollection();
                int numJobs = jobDocCol.update(new QueryBuilder().in("_id", this.jobIdsToValidate).toDocument(), new UpdateBuilder().set("validated-date", (Object)new Date()).toDocument(), false, true);
                if (numJobs > 0) {
                    LOGGER.info("Renewed {} deploy jobs", (Object)numJobs);
                    if (jobDocCol.supportsAggregate()) {
                        IONArray result = jobDocCol.aggregate(new AggregationPipelineBuilder().match(new QueryBuilder().in("_id", (Collection)DeployJobTracker.this.localJobIds).toDocument(), false).group(new IONObjectBuilder().put("_id", (Object)"$database-id").put("count", (Object)new IONObjectBuilder().put("$sum", (Object)1).toDocument()).toDocument()).toIONDocuments());
                        for (int i = 0; i < result.size(); ++i) {
                            IONObject obj = result.getIONObject(i);
                            IONObjectId dbId = obj.getIONObjectId("_id");
                            long count = obj.getLong("count");
                            String jdbcUrl = (String)dbDocCol.findOneAndProject(new QueryBuilder().idEqualTo(dbId).toDocument(), "jdbc-url", String.class, EReadPreference.SECONDARY_PREFERRED);
                            METRIC_IMPORT_DEPLOY_JOBS_RUNNING.withArgs(new Object[]{DeployJobTracker.getHostFromUrl(jdbcUrl)}).gauge(count);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("An unexpected exception occured while renewing local deploy jobs", (Throwable)ex);
            }
        }
    }
}

