/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.storage.util;

import com.ibm.neo.util.Assertions;
import java.util.HashSet;
import java.util.List;

public class IdentifierUtil {
    public static String legalizeIdentifier(String id, int maxLength) {
        StringBuilder builder = new StringBuilder(Math.min(id.length(), maxLength));
        int i = 0;
        while (i < id.length()) {
            int cp = id.codePointAt(i);
            if (cp > 31) {
                if (cp == 34 || cp == 39 || cp == 96) {
                    i += Character.charCount(cp);
                    continue;
                }
                if (builder.length() == 0 && Character.isDigit(cp)) {
                    builder.append("_");
                }
                builder.append(Character.toChars(cp));
            } else {
                builder.append('?');
            }
            if (builder.length() >= maxLength) break;
            i += Character.charCount(cp);
        }
        return builder.toString().trim();
    }

    public static void uniquizeIdentifiers(String[] ids, int maxLength) {
        HashSet<String> uniqueSet = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            String uniqueId = ids[i];
            int count = 2;
            if (uniqueId.length() > maxLength) {
                uniqueId = uniqueId.substring(0, maxLength);
            }
            while (uniqueSet.contains(uniqueId)) {
                String countStr = Integer.toString(count++);
                uniqueId = ids[i];
                if (uniqueId.length() > maxLength - countStr.length()) {
                    uniqueId = uniqueId.substring(0, maxLength - countStr.length());
                }
                uniqueId = uniqueId + countStr;
            }
            uniqueSet.add(uniqueId);
            ids[i] = uniqueId;
        }
    }

    public static void uniquizeIdentifiers(List<String> ids, int maxLength) {
        HashSet<String> uniqueSet = new HashSet<String>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            String uniqueId = ids.get(i);
            int count = 2;
            if (uniqueId.length() > maxLength) {
                uniqueId = uniqueId.substring(0, maxLength);
            }
            while (uniqueSet.contains(uniqueId)) {
                String countStr = Integer.toString(count++);
                uniqueId = ids.get(i);
                if (uniqueId.length() > maxLength - countStr.length()) {
                    uniqueId = uniqueId.substring(0, maxLength - countStr.length());
                }
                uniqueId = uniqueId + countStr;
            }
            uniqueSet.add(uniqueId);
            ids.set(i, uniqueId);
        }
    }

    public static String makeTableNameForDataset(String datasetName, String datasetId, int maxTableNameLength) {
        datasetName = IdentifierUtil.legalizeIdentifier(datasetName.trim(), maxTableNameLength);
        int maxDatasetNameLength = maxTableNameLength - datasetId.length() - 3;
        Assertions.assertPositive((long)maxDatasetNameLength, (String)"maxDatasetNameLength > 0");
        return String.format("%s (%s)", datasetName.substring(0, Math.min(datasetName.length(), maxDatasetNameLength)).trim(), datasetId);
    }

    public static String makeQualifiedName(String ... parts) {
        if (parts.length < 1) {
            throw new IllegalArgumentException("parts.length < 1");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append('\"').append(parts[i]).append('\"');
        }
        return sb.toString();
    }
}

