/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.plugin.framework;

import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.plugin.IPluginContext;
import com.ibm.neo.persist.PersistenceService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PluginContext
implements IPluginContext {
    private final Properties mConfiguration;
    private final PersistenceService mPersistenceService;
    private final CDFService mCDFService;
    private final Map<String, Object> mStateMap = new HashMap<String, Object>();

    public PluginContext(Properties configuration, PersistenceService persistenceService, CDFService cdfService) {
        this.mConfiguration = configuration;
        this.mPersistenceService = persistenceService;
        this.mCDFService = cdfService;
    }

    @Override
    public Properties getConfiguration() {
        return this.mConfiguration;
    }

    @Override
    public final PersistenceService getPersistenceService() {
        return this.mPersistenceService;
    }

    @Override
    public final CDFService getCDFService() {
        return this.mCDFService;
    }

    @Override
    public final boolean containsKey(String key) {
        return this.mStateMap.containsKey(key);
    }

    @Override
    public final <T> T get(String key, Class<T> type) {
        return type.cast(this.mStateMap.get(key));
    }

    @Override
    public final void put(String key, Object value) {
        this.mStateMap.put(key, value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

