/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.plugin.framework;

import com.ibm.neo.dataimport.plugin.EPluginType;
import com.ibm.neo.dataimport.plugin.IPlugin;
import com.ibm.neo.dataimport.plugin.PluginException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final Map<String, IPlugin> mName2Plugin = new HashMap<String, IPlugin>();
    private final EnumMap<EPluginType, List<IPlugin>> mType2PluginChain = new EnumMap(EPluginType.class);
    private final Properties mConfiguration;
    private final ReadWriteLock mRWLock = new ReentrantReadWriteLock();

    public PluginManager(Properties configuration) {
        this.mConfiguration = configuration;
        this.discoverPlugins();
    }

    void discoverPlugins() {
        ServiceLoader<IPlugin> pluginLoader = ServiceLoader.load(IPlugin.class);
        for (IPlugin plugin : pluginLoader) {
            try {
                this.registerPlugin(plugin);
            }
            catch (PluginException ex) {
                LOGGER.error("Failed to register import plugin", (Throwable)ex);
            }
        }
    }

    public void registerPlugin(String className) throws PluginException {
        IPlugin pluginInstance;
        try {
            Class<?> pluginClass = this.getClass().getClassLoader().loadClass(className);
            pluginInstance = (IPlugin)pluginClass.newInstance();
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        this.registerPlugin(pluginInstance);
    }

    public void registerPlugin(IPlugin plugin) throws PluginException {
        this.mRWLock.writeLock().lock();
        try {
            plugin.initialize(this.mConfiguration);
            if (this.mName2Plugin.containsKey(plugin.getName())) {
                throw new PluginException("Plugin was already registered: " + plugin.getName());
            }
            this.mName2Plugin.put(plugin.getName(), plugin);
            List<IPlugin> chain = this.mType2PluginChain.get((Object)plugin.getType());
            if (null == chain) {
                chain = new ArrayList<IPlugin>();
                this.mType2PluginChain.put(plugin.getType(), chain);
            }
            chain.add(plugin);
            Collections.sort(chain);
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlugin(String name) {
        this.mRWLock.writeLock().lock();
        try {
            IPlugin plugin = this.mName2Plugin.remove(name);
            if (null != plugin) {
                List<IPlugin> chain = this.mType2PluginChain.get((Object)plugin.getType());
                if (null != chain) {
                    chain.remove(plugin);
                }
                try {
                    plugin.dispose();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to dispose plugin", (Throwable)ex);
                }
            }
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllPlugins() {
        this.mRWLock.writeLock().lock();
        try {
            for (IPlugin plugin : this.mName2Plugin.values()) {
                try {
                    plugin.dispose();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to dispose plugin", (Throwable)ex);
                }
            }
            this.mName2Plugin.clear();
            this.mType2PluginChain.clear();
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    public IPlugin[] getAllPlugins() {
        this.mRWLock.readLock().lock();
        try {
            IPlugin[] iPluginArray = this.mName2Plugin.values().toArray(new IPlugin[this.mName2Plugin.size()]);
            return iPluginArray;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IPlugin> T getPlugin(String name, Class<T> castTo) {
        this.mRWLock.readLock().lock();
        try {
            IPlugin iPlugin = (IPlugin)castTo.cast(this.mName2Plugin.get(name));
            return (T)iPlugin;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IPlugin> List<T> getPluginChain(EPluginType pluginType, Class<T> castTo) {
        this.mRWLock.readLock().lock();
        try {
            List<IPlugin> chain = this.mType2PluginChain.get((Object)pluginType);
            if (null == chain || chain.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            ArrayList<T> result = new ArrayList<T>(chain.size());
            for (IPlugin p : chain) {
                result.add(castTo.cast(p));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }
}

